/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.cdn;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.models.WidgetScriptSource;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.cdn.WidgetCDNs;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.common.IWidgetScriptSourceProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterHttpClient;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J*\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/cdn/CDNWidgetScriptSourceProvider;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/common/IWidgetScriptSourceProvider;", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/models/WidgetScriptSource;", "dispose", "", "getWidgetScriptSource", "moduleName", "moduleVersion", "isWebViewOnline", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWidgetScriptSourceImplementation", "getValidUri", "cdn", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/cdn/WidgetCDNs;", "moduleNameToCDNUrl", "getModuleKey", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nCDNWidgetScriptSourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CDNWidgetScriptSourceProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/cdn/CDNWidgetScriptSourceProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n23#2:109\n23#2:111\n1#3:110\n*S KotlinDebug\n*F\n+ 1 CDNWidgetScriptSourceProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/cdn/CDNWidgetScriptSourceProvider\n*L\n27#1:109\n62#1:111\n*E\n"})
public final class CDNWidgetScriptSourceProvider
implements IWidgetScriptSourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentSkipListMap<String, WidgetScriptSource> cache = new ConcurrentSkipListMap();
    @NotNull
    private static final Logger logger;

    public void dispose() {
        this.cache.clear();
    }

    @Override
    @Nullable
    public Object getWidgetScriptSource(@NotNull String moduleName, @NotNull String moduleVersion, @Nullable Boolean isWebViewOnline, @NotNull Continuation<? super WidgetScriptSource> $completion) {
        if (Intrinsics.areEqual((Object)isWebViewOnline, (Object)Boxing.boxBoolean((boolean)false))) {
            CDNWidgetScriptSourceProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CDNWidgetScriptSourceProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Jupyter: Not access to the internet from the web view. ModuleName " + moduleName);
            return null;
        }
        String key = this.getModuleKey(moduleName, moduleVersion);
        WidgetScriptSource cached = this.cache.get(key);
        if (cached != null) {
            return cached;
        }
        WidgetScriptSource widgetScriptSource = this.getWidgetScriptSourceImplementation(moduleName, moduleVersion);
        if (widgetScriptSource == null) {
            return null;
        }
        WidgetScriptSource calculated = widgetScriptSource;
        ((Map)this.cache).put(key, calculated);
        return calculated;
    }

    private final WidgetScriptSource getWidgetScriptSourceImplementation(String moduleName, String moduleVersion) {
        logger.trace("Searching for Widget Script " + moduleName + "#" + moduleVersion + " using CDNs");
        for (WidgetCDNs cdn : WidgetCDNs.getEntries()) {
            String string = this.getValidUri(moduleName, moduleVersion, cdn);
            if (string == null) continue;
            String url = string;
            WidgetScriptSource.Source source = WidgetScriptSource.Source.CDN;
            return new WidgetScriptSource(moduleName, source, url, null, 8, null);
        }
        return null;
    }

    private final String getValidUri(String moduleName, String moduleVersion, WidgetCDNs cdn) {
        CharSequence charSequence;
        try {
            CharSequence charSequence2;
            CharSequence charSequence3;
            String downloadUrl = this.moduleNameToCDNUrl(cdn.getUrl(), moduleName, moduleVersion);
            boolean isUrlExists = JupyterHttpClient.exists$default(JupyterHttpClient.INSTANCE, downloadUrl, 0, 2, null);
            String it = charSequence3 = downloadUrl;
            boolean bl = false;
            String string = isUrlExists ? charSequence3 : null;
            if (string != null) {
                CharSequence charSequence4;
                charSequence3 = string;
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    boolean bl2 = false;
                    charSequence4 = null;
                } else {
                    charSequence4 = charSequence3;
                }
                charSequence2 = charSequence4;
            } else {
                charSequence2 = null;
            }
            charSequence = charSequence2;
        }
        catch (Exception ex) {
            CDNWidgetScriptSourceProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CDNWidgetScriptSourceProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed downloading " + moduleName + ":" + moduleVersion + " from " + cdn, (Throwable)ex);
            charSequence = null;
        }
        return charSequence;
    }

    private final String moduleNameToCDNUrl(String cdn, String moduleName, String moduleVersion) {
        String packageName = moduleName;
        Object fileName = "index";
        int index = StringsKt.indexOf$default((CharSequence)moduleName, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index != -1 && StringsKt.startsWith$default((String)moduleName, (String)"@", (boolean)false, (int)2, null)) {
            index = StringsKt.indexOf$default((CharSequence)moduleName, (char)'/', (int)(index + 1), (boolean)false, (int)4, null);
        }
        if (index != -1) {
            String string = moduleName.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fileName = string;
            String string2 = moduleName.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            packageName = string2;
        }
        String newModuleVersion = moduleVersion;
        if (Intrinsics.areEqual((Object)cdn, (Object)WidgetCDNs.JSDelivr.getUrl())) {
            if (StringsKt.startsWith$default((CharSequence)newModuleVersion, (char)'^', (boolean)false, (int)2, null)) {
                newModuleVersion = StringsKt.removePrefix((String)newModuleVersion, (CharSequence)"^");
            }
            if (!StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null)) {
                fileName = (String)fileName + ".js";
            }
            return cdn + packageName + "@" + newModuleVersion + "/dist/" + (String)fileName;
        }
        return cdn + packageName + "@" + newModuleVersion + "/dist/" + (String)fileName;
    }

    private final String getModuleKey(String moduleName, String moduleVersion) {
        return moduleName + moduleVersion;
    }

    static {
        Logger logger = Logger.getInstance(CDNWidgetScriptSourceProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CDNWidgetScriptSourceProvider.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/cdn/CDNWidgetScriptSourceProvider$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

