/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.server.ui;

import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerContentCloseListener;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"JUPYTER_TOOL_WINDOW_ID", "", "getJupyterToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "getOrCreateJupyterToolWindow", "attachJupyterServerContentCloseListener", "", "content", "Lcom/intellij/ui/content/Content;", "sessionName", "handler", "Lcom/intellij/execution/process/KillableProcessHandler;", "intellij.jupyter.core"})
public final class JupyterServerToolWindowKt {
    @NotNull
    private static final String JUPYTER_TOOL_WINDOW_ID = "Jupyter";

    @Nullable
    public static final ToolWindow getJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ToolWindowManager.Companion.getInstance(project).getToolWindow(JUPYTER_TOOL_WINDOW_ID);
    }

    @NotNull
    public static final ToolWindow getOrCreateJupyterToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(JUPYTER_TOOL_WINDOW_ID);
        if (toolWindow == null) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
            ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
            toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(JUPYTER_TOOL_WINDOW_ID, toolWindowAnchor2, null, false, true, false, false, null, null, null, 1004, null));
        }
        ToolWindow toolWindow2 = toolWindow;
        toolWindow2.setIcon(JupyterCoreIcons.JupyterToolWindow);
        return toolWindow2;
    }

    public static final void attachJupyterServerContentCloseListener(@NotNull Content content, @NotNull Project project, @Nls @NotNull String sessionName, @NotNull KillableProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        new JupyterServerContentCloseListener(content, project, sessionName, handler2);
    }
}

