/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.trust;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAware;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.outputs.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.trust.JupyterHashTrustManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.EventDispatcher;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "getCellLines", "()Lcom/intellij/notebooks/visualization/NotebookCellLines;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "isNotebookTrusted", "", "isOutputTrusted", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "trustNotebook", "", "trustOutput", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1786#2,3:106\n1915#2,2:109\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager\n*L\n47#1:106,3\n75#1:109,2\n*E\n"})
public final class JupyterNotebookTrustManager
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<JupyterNotebookTrustManager> NOTEBOOK_TRUST_MANAGER_KEY = new Key(JupyterNotebookTrustManager.class.getName());
    @NotNull
    private static final Key<Boolean> POINTER_IS_TRUSTED = new Key("POINTER_IS_TRUSTED");

    public JupyterNotebookTrustManager(@NotNull Editor editor, @NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.editor = editor;
            this.project = project;
            EventDispatcher<CellExecutionListener> eventDispatcher = this.getNotebook();
            if (eventDispatcher == null || (eventDispatcher = eventDispatcher.getListeners()) == null || (eventDispatcher = eventDispatcher.getCellExecutionListeners()) == null) break block0;
            eventDispatcher.addListener((EventListener)new CellExecutionListener(){

                @Override
                public void executionStarted(NotebookIntervalPointer cellPointer, ZonedDateTime startTime) {
                    Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                    Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
                    cellPointer.putUserData(POINTER_IS_TRUSTED, (Object)true);
                }

                @Override
                public void executionStopped(NotebookIntervalPointer cellPointer, JupyterExecutionStatus jupyterStatus, ZonedDateTime endTime) {
                    Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
                    Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
                    Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
                    this.trustOutput(cellPointer);
                }
            }, (Disposable)this);
        }
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NotebookCellLines getCellLines() {
        return NotebookCellLines.Companion.get(this.editor);
    }

    private final BackedNotebookVirtualFile getNotebookFile() {
        return JupyterEditorExtensionsKt.getNotebookFileOrNull(this.editor);
    }

    @Nullable
    public final JupyterNotebook getNotebook() {
        BackedNotebookVirtualFile backedNotebookVirtualFile = this.getNotebookFile();
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebook() : null;
    }

    public final boolean isNotebookTrusted() {
        boolean isTrusted;
        block6: {
            BackedNotebookVirtualFile backedNotebookVirtualFile;
            block5: {
                boolean isTrustedCached;
                Object object = this.getNotebookFile();
                boolean bl = object != null && (object = object.getFile()) != null && (object = (Boolean)object.getUserData(POINTER_IS_TRUSTED)) != null ? (Boolean)object : (isTrustedCached = false);
                if (isTrustedCached) {
                    return true;
                }
                Iterable $this$all$iv = NotebookCellLines.Companion.get(this.editor).getIntervals();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        NotebookIntervalPointer pointer;
                        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)element$iv;
                        boolean bl2 = false;
                        if (NotebookIntervalPointerFactory.Companion.get(this.editor).getForOrdinalIfExists(interval.getOrdinal()) == null) {
                            return true;
                        }
                        if (this.isOutputTrusted(pointer)) continue;
                        v2 = false;
                        break block5;
                    }
                    v2 = isTrusted = true;
                }
            }
            if ((backedNotebookVirtualFile = this.getNotebookFile()) == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) break block6;
            backedNotebookVirtualFile.putUserData(POINTER_IS_TRUSTED, isTrusted);
        }
        return isTrusted;
    }

    public final boolean isOutputTrusted(@NotNull NotebookIntervalPointer cellPointer) {
        boolean isCellTrusted;
        boolean isNotebookTrusted;
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Object object = this.getNotebookFile();
        boolean bl = object != null && (object = object.getFile()) != null && (object = (Boolean)object.getUserData(POINTER_IS_TRUSTED)) != null ? (Boolean)object : (isNotebookTrusted = false);
        if (isNotebookTrusted) {
            return true;
        }
        Boolean bl2 = (Boolean)cellPointer.getUserData(POINTER_IS_TRUSTED);
        boolean bl3 = isCellTrusted = bl2 != null ? bl2 : false;
        if (isCellTrusted) {
            return true;
        }
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return true;
        }
        int index = interval.getOrdinal();
        JupyterMetadataAware<JsonNode> jupyterMetadataAware = this.getNotebook();
        if (jupyterMetadataAware == null || (jupyterMetadataAware = jupyterMetadataAware.getCellOrNull(index)) == null) {
            return true;
        }
        JupyterMetadataAware<JsonNode> jupyterCell = jupyterMetadataAware;
        JupyterOutputs jupyterOutputs = jupyterCell.getOutputs();
        if (jupyterOutputs == null) {
            return true;
        }
        JupyterOutputs outputs = jupyterOutputs;
        boolean storedIsTrusted = JupyterHashTrustManager.Companion.getInstance().isOutputTrusted(outputs);
        cellPointer.putUserData(POINTER_IS_TRUSTED, (Object)storedIsTrusted);
        return storedIsTrusted;
    }

    public final void trustNotebook() {
        BackedNotebookVirtualFile backedNotebookVirtualFile = this.getNotebookFile();
        if (backedNotebookVirtualFile != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) != null) {
            backedNotebookVirtualFile.putUserData(POINTER_IS_TRUSTED, true);
        }
        Iterable $this$forEach$iv = NotebookCellLines.Companion.get(this.editor).getIntervals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookIntervalPointer pointer;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)element$iv;
            boolean bl = false;
            if (NotebookIntervalPointerFactory.Companion.get(this.editor).getForOrdinalIfExists(interval.getOrdinal()) == null) continue;
            this.trustOutput(pointer);
        }
    }

    private final void trustOutput(NotebookIntervalPointer cellPointer) {
        cellPointer.putUserData(POINTER_IS_TRUSTED, (Object)true);
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return;
        }
        int index = interval.getOrdinal();
        JupyterMetadataAware<JsonNode> jupyterMetadataAware = this.getNotebook();
        if (jupyterMetadataAware == null || (jupyterMetadataAware = jupyterMetadataAware.getCellOrNull(index)) == null) {
            return;
        }
        JupyterMetadataAware<JsonNode> jupyterCell = jupyterMetadataAware;
        JupyterOutputs jupyterOutputs = jupyterCell.getOutputs();
        if (jupyterOutputs == null) {
            return;
        }
        JupyterOutputs outputs = jupyterOutputs;
        JupyterHashTrustManager.Companion.getInstance().trustOutputs(outputs);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager$Companion;", "", "<init>", "()V", "NOTEBOOK_TRUST_MANAGER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterNotebookTrustManager;", "POINTER_IS_TRUSTED", "", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "get", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            JupyterNotebookTrustManager notebookTrustManager = new JupyterNotebookTrustManager(editor, project2);
            Disposer.register((Disposable)((EditorImpl)editor).getDisposable(), (Disposable)((Disposable)notebookTrustManager));
            ((EditorImpl)editor).putUserData(NOTEBOOK_TRUST_MANAGER_KEY, (Object)notebookTrustManager);
        }

        @Nullable
        public final JupyterNotebookTrustManager get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (JupyterNotebookTrustManager)editor.getUserData(NOTEBOOK_TRUST_MANAGER_KEY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

