/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.visualization.EditorNotebookPostprocessor;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookIntervalPointersEvent;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.EditorCellViewEventListener;
import com.intellij.notebooks.visualization.ui.EditorEmbeddedComponentContainer;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.notebooks.visualization.ui.JupyterCellSelectionNotifier;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.notebooks.visualization.ui.endInlay.EditorNotebookEndInlay;
import com.intellij.notebooks.visualization.ui.endInlay.EditorNotebookEndInlayProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 m2\u00020\u00012\u00020\u0002:\u0001mB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010 \u001a\u00020!J0\u0010'\u001a\u00020!2\b\b\u0002\u0010(\u001a\u00020\u00102\b\b\u0002\u0010)\u001a\u00020\u00102\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020!0+H\u0002J\b\u0010-\u001a\u00020!H\u0016J\u000e\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020!J\b\u00102\u001a\u00020!H\u0002J\u0006\u00103\u001a\u00020!J\u0016\u0010'\u001a\u00020!2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J\u000e\u0010'\u001a\u00020!2\u0006\u00107\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020!2\u0006\u00108\u001a\u000206J \u00109\u001a\u00020!2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010(\u001a\u00020\u0010H\u0002J\b\u0010:\u001a\u00020!H\u0002J\u0006\u0010;\u001a\u00020!J\u0010\u0010<\u001a\u0004\u0018\u00010\u00132\u0006\u0010=\u001a\u00020>J\u0018\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u00020>2\u0006\u00107\u001a\u00020\u0013H\u0002J\u0018\u0010A\u001a\u00020@2\u0006\u0010=\u001a\u00020>2\u0006\u00107\u001a\u00020\u001dH\u0002J\u0018\u0010B\u001a\u00020@2\u0006\u0010=\u001a\u00020>2\u0006\u00107\u001a\u00020\u0013H\u0002J\u0016\u0010C\u001a\u00020!2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u0012H\u0002J\u0018\u0010F\u001a\u00020!2\u0006\u00107\u001a\u00020\u00132\u0006\u0010G\u001a\u00020\u0010H\u0002J\u0018\u0010H\u001a\u00020!2\u0006\u00107\u001a\u00020\u00132\u0006\u0010I\u001a\u00020,H\u0002J\u0018\u0010J\u001a\u00020!2\u0006\u00107\u001a\u00020\u00132\u0006\u0010I\u001a\u00020,H\u0002J\u0010\u0010K\u001a\u00020!2\u0006\u00107\u001a\u00020\u0013H\u0002J\b\u0010L\u001a\u00020!H\u0002J\b\u0010M\u001a\u00020!H\u0002J\b\u0010N\u001a\u00020!H\u0002J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010P\u001a\u00020QH\u0002J\b\u0010R\u001a\u00020!H\u0002J\u0016\u0010S\u001a\u00020!2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010W\u001a\u00020!2\u0006\u0010X\u001a\u00020VH\u0016J\b\u0010Y\u001a\u00020!H\u0016J\u0018\u0010Z\u001a\u00020!2\u0006\u0010[\u001a\u00020\\2\u0006\u0010I\u001a\u00020,H\u0002J\u0010\u0010]\u001a\u00020!2\u0006\u00108\u001a\u000206H\u0002J\u0010\u0010^\u001a\u00020!2\u0006\u0010_\u001a\u00020@H\u0002J\u0016\u0010`\u001a\u00020!2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u0001J\u0016\u0010d\u001a\u00020!2\u0006\u0010e\u001a\u00020$2\u0006\u0010c\u001a\u00020\u0001J\u0015\u0010f\u001a\u00020!2\u0006\u0010g\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bhJ\u0015\u0010i\u001a\u00020!2\u0006\u0010g\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bjJ\u000e\u0010k\u001a\u00020\u00132\u0006\u0010_\u001a\u00020@J\u000e\u0010k\u001a\u00020\u00132\u0006\u0010/\u001a\u000200J\u0010\u0010l\u001a\u0004\u0018\u00010\u00132\u0006\u0010_\u001a\u00020@J\u0010\u0010l\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u000200J\u0010\u0010k\u001a\u0004\u0018\u00010\u00132\u0006\u00108\u001a\u000206R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR!\u0010\"\u001a\u0015\u0012\f\u0012\n %*\u0004\u0018\u00010$0$0#\u00a2\u0006\u0002\b&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020V0UX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerFactory$ChangeListener;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "notebook", "Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorNotebook;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getNotebook", "()Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "notebookCellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "initialized", "", "cells", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "getCells", "()Ljava/util/List;", "endNotebookInlays", "Lcom/intellij/notebooks/visualization/ui/endInlay/EditorNotebookEndInlay;", "getEndNotebookInlays", "setEndNotebookInlays", "(Ljava/util/List;)V", "views", "", "Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "getViews$intellij_notebooks_visualization", "()Ljava/util/Map;", "refresh", "", "cellViewEventListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "update", "force", "keepScrollingPosition", "block", "Lkotlin/Function1;", "Lcom/intellij/notebooks/visualization/UpdateContext;", "dispose", "getCellForInterval", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "updateAllOutputs", "updateAll", "forceUpdateAll", "pointers", "", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "cell", "pointer", "updateCells", "addViewportChangeListener", "initialize", "getCellByPoint", "point", "Ljava/awt/Point;", "comparePointWithCell", "", "comparePointWithCellByCellView", "comparePointWithCellByLogicalLine", "updateUI", "events", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener$EditorCellEvent;", "updateCellVisibility", "visible", "createCellViewIfNecessary", "ctx", "createCellView", "disposeCellView", "setupSelectionUI", "updateSelection", "setupFoldingListener", "editorCells", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "handleRefreshedDocument", "updateCellsFolding", "currentEventsQueue", "", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointersEvent;", "onUpdated", "event", "bulkUpdateFinished", "fixInlaysOffsetsAfterNewCellInsert", "change", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointersEvent$OnInserted;", "addCell", "removeCell", "index", "addCellEventsListener", "editorCellEventListener", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener;", "disposable", "addCellViewEventsListener", "editorCellViewEventListener", "fireCellViewCreated", "cellView", "fireCellViewCreated$intellij_notebooks_visualization", "fireCellViewRemoved", "fireCellViewRemoved$intellij_notebooks_visualization", "getCell", "getCellOrNull", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookCellInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,486:1\n1915#2,2:487\n1586#2:489\n1661#2,3:490\n777#2:493\n873#2,2:494\n1915#2,2:496\n1642#2,10:498\n1915#2:508\n1916#2:510\n1652#2:511\n1586#2:512\n1661#2,3:513\n1915#2,2:516\n1915#2,2:518\n1915#2,2:520\n1915#2,2:534\n1915#2,2:536\n1915#2,2:538\n1915#2,2:540\n1915#2,2:542\n812#2,12:544\n1915#2,2:556\n812#2,12:558\n1915#2,2:570\n1#3:509\n4253#4,12:522\n*S KotlinDebug\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager\n*L\n49#1:487,2\n240#1:489\n240#1:490,3\n292#1:493\n292#1:494,2\n74#1:496,2\n93#1:498,10\n93#1:508\n93#1:510\n93#1:511\n93#1:512\n93#1:513,3\n106#1:516,2\n115#1:518,2\n304#1:520,2\n312#1:534,2\n317#1:536,2\n381#1:538,2\n386#1:540,2\n397#1:542,2\n421#1:544,12\n421#1:556,2\n424#1:558,12\n426#1:570,2\n93#1:509\n311#1:522,12\n*E\n"})
public final class NotebookCellInlayManager
implements Disposable,
NotebookIntervalPointerFactory.ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorNotebook notebook;
    @NotNull
    private final NotebookCellLines notebookCellLines;
    private boolean initialized;
    @NotNull
    private List<? extends EditorNotebookEndInlay> endNotebookInlays;
    @NotNull
    private final Map<EditorCell, EditorCellView> views;
    @NotNull
    private final EventDispatcher<EditorCellViewEventListener> cellViewEventListeners;
    @NotNull
    private final List<NotebookIntervalPointersEvent> currentEventsQueue;
    @NotNull
    private static final Key<Boolean> FOLDING_MARKER_KEY = new Key("jupyter.folding.paragraph");
    @NotNull
    private static final Key<NotebookCellInlayManager> CELL_INLAY_MANAGER_KEY;

    private NotebookCellInlayManager(EditorImpl editor, EditorNotebook notebook) {
        this.editor = editor;
        this.notebook = notebook;
        this.notebookCellLines = NotebookCellLines.Companion.get((Editor)this.editor);
        this.endNotebookInlays = EditorNotebookEndInlayProvider.Companion.create(this);
        this.views = new LinkedHashMap();
        EventDispatcher eventDispatcher = EventDispatcher.create(EditorCellViewEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.cellViewEventListeners = eventDispatcher;
        this.currentEventsQueue = new ArrayList();
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final EditorNotebook getNotebook() {
        return this.notebook;
    }

    @NotNull
    public final List<EditorCell> getCells() {
        return this.notebook.getCells();
    }

    @NotNull
    public final List<EditorNotebookEndInlay> getEndNotebookInlays() {
        return this.endNotebookInlays;
    }

    public final void setEndNotebookInlays(@NotNull List<? extends EditorNotebookEndInlay> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.endNotebookInlays = list;
    }

    @NotNull
    public final Map<EditorCell, EditorCellView> getViews$intellij_notebooks_visualization() {
        return this.views;
    }

    public final void refresh() {
        Iterable $this$forEach$iv = this.endNotebookInlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorNotebookEndInlay it = (EditorNotebookEndInlay)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        this.endNotebookInlays = EditorNotebookEndInlayProvider.Companion.create(this);
        for (EditorCell cell : this.getCells()) {
            this.disposeCellView(cell);
            this.updateCellVisibility(cell, cell.isUnfolded().get());
        }
    }

    private final void update(boolean force, boolean keepScrollingPosition, Function1<? super UpdateContext, Unit> block) {
        UpdateManagerKt.getUpdateManager((Editor)this.editor).update(force, keepScrollingPosition, block);
    }

    static /* synthetic */ void update$default(NotebookCellInlayManager notebookCellInlayManager, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        notebookCellInlayManager.update(bl, bl2, (Function1<? super UpdateContext, Unit>)function1);
    }

    public void dispose() {
        this.views.clear();
        RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.editor), CELL_INLAY_MANAGER_KEY);
    }

    @NotNull
    public final EditorCell getCellForInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.notebook.getCells().get(interval.getOrdinal());
    }

    public final void updateAllOutputs() {
        NotebookCellInlayManager.update$default(this, false, false, arg_0 -> NotebookCellInlayManager.updateAllOutputs$lambda$0(this, arg_0), 3, null);
    }

    private final void updateAll() {
        if (this.initialized) {
            this.updateCells(this.getCells(), false);
        }
    }

    public final void forceUpdateAll() {
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.forceUpdateAll$lambda$0(this), (int)1, null);
    }

    private final void update(Collection<? extends NotebookIntervalPointer> pointers) {
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.update$lambda$0(this, pointers), (int)1, null);
    }

    public final void update(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.update$lambda$1(this, cell), (int)1, null);
    }

    public final void update(@NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        ActionsKt.runInEdt$default(null, () -> NotebookCellInlayManager.update$lambda$2(this, pointer), (int)1, null);
    }

    private final void updateCells(List<EditorCell> cells, boolean force) {
        NotebookCellInlayManager.update$default(this, force, false, arg_0 -> NotebookCellInlayManager.updateCells$lambda$0(cells, this, arg_0), 2, null);
    }

    static /* synthetic */ void updateCells$default(NotebookCellInlayManager notebookCellInlayManager, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        notebookCellInlayManager.updateCells(list, bl);
    }

    private final void addViewportChangeListener() {
        this.editor.getScrollPane().getViewport().addChangeListener(arg_0 -> NotebookCellInlayManager.addViewportChangeListener$lambda$0(this, arg_0));
    }

    public final void initialize() {
        this.editor.putUserData(CELL_INLAY_MANAGER_KEY, (Object)this);
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Disposable disposable = this.editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection connection = messageBus.connect(disposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> NotebookCellInlayManager.initialize$lambda$0(this, arg_0));
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> NotebookCellInlayManager.initialize$lambda$1(this, arg_0));
        this.addViewportChangeListener();
        this.initialized = true;
        this.setupFoldingListener();
        this.setupSelectionUI();
        this.notebook.addCellEventsListener(this, arg_0 -> NotebookCellInlayManager.initialize$lambda$2(this, arg_0));
        this.handleRefreshedDocument();
    }

    @Nullable
    public final EditorCell getCellByPoint(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        int index = CollectionsKt.binarySearch$default(this.getCells(), (int)0, (int)0, arg_0 -> NotebookCellInlayManager.getCellByPoint$lambda$0(this, point, arg_0), (int)3, null);
        return (EditorCell)CollectionsKt.getOrNull(this.getCells(), (int)index);
    }

    private final int comparePointWithCell(Point point, EditorCell cell) {
        EditorCellView cellView = cell.getView();
        return cellView == null ? this.comparePointWithCellByLogicalLine(point, cell) : this.comparePointWithCellByCellView(point, cellView);
    }

    private final int comparePointWithCellByCellView(Point point, EditorCellView cell) {
        Rectangle bounds = cell.calculateBounds();
        if (bounds.contains(point)) {
            return 0;
        }
        if (bounds.y >= point.y) {
            return 1;
        }
        return -1;
    }

    private final int comparePointWithCellByLogicalLine(Point point, EditorCell cell) {
        int line = this.editor.xyToLogicalPosition((Point)point).line;
        return line < cell.getInterval().getLines().getFirst() ? 1 : (line >= cell.getInterval().getLines().getLast() + 1 ? -1 : 0);
    }

    private final void updateUI(List<? extends EditorCellEventListener.EditorCellEvent> events) {
        NotebookCellInlayManager.update$default(this, false, false, arg_0 -> NotebookCellInlayManager.updateUI$lambda$0(events, this, arg_0), 3, null);
    }

    private final void updateCellVisibility(EditorCell cell, boolean visible) {
        NotebookCellInlayManager.update$default(this, false, false, arg_0 -> NotebookCellInlayManager.updateCellVisibility$lambda$0(visible, this, cell, arg_0), 3, null);
    }

    private final void createCellViewIfNecessary(EditorCell cell, UpdateContext ctx) {
        if (this.views.get(cell) == null) {
            this.createCellView(cell, ctx);
        }
    }

    private final void createCellView(EditorCell cell, UpdateContext ctx) {
        EditorCellView view = new EditorCellView(cell);
        Disposer.register((Disposable)cell, (Disposable)((Disposable)view));
        view.updateCellFolding(ctx);
        this.views.put(cell, view);
        this.fireCellViewCreated$intellij_notebooks_visualization(view);
    }

    private final void disposeCellView(EditorCell cell) {
        block0: {
            EditorCellView editorCellView = this.views.remove(cell);
            if (editorCellView == null) break block0;
            EditorCellView view = editorCellView;
            boolean bl = false;
            this.fireCellViewRemoved$intellij_notebooks_visualization(view);
            Disposer.dispose((Disposable)((Disposable)view));
        }
    }

    private final void setupSelectionUI() {
        this.editor.getCaretModel().addCaretListener(new CaretListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NotebookCellInlayManager.access$updateSelection(this.this$0);
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelection() {
        void $this$mapTo$iv$iv;
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)this.editor);
        if (notebookCellSelectionModel == null) {
            throw new IllegalStateException("The selection model is supposed to be installed".toString());
        }
        NotebookCellSelectionModel selectionModel = notebookCellSelectionModel;
        Iterable $this$map$iv = selectionModel.getSelectedCells();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOrdinal());
        }
        List selectedCells = (List)destination$iv$iv;
        for (EditorCell cell : this.getCells()) {
            NotebookCellLines.Interval interval = cell.getIntervalPointer().get();
            cell.isSelected().set(CollectionsKt.contains((Iterable)selectedCells, (Object)(interval != null ? Integer.valueOf(interval.getOrdinal()) : null)));
            if (!cell.isSelected().get().booleanValue()) continue;
            Object object = this.editor.getProject();
            if (object == null || (object = object.getMessageBus()) == null || (object = (JupyterCellSelectionNotifier)object.syncPublisher(JupyterCellSelectionNotifier.Companion.getTOPIC())) == null) continue;
            object.cellSelected(cell.getInterval(), (Editor)this.editor);
        }
    }

    private final void setupFoldingListener() {
        FoldingModelImpl foldingModelImpl = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelImpl, (String)"getFoldingModel(...)");
        FoldingModelImpl foldingModel = foldingModelImpl;
        foldingModel.addListener(new FoldingListener(this){
            private final LinkedHashSet<FoldRegion> changedRegions;
            private final LinkedHashSet<FoldRegion> removedRegions;
            final /* synthetic */ NotebookCellInlayManager this$0;
            {
                this.this$0 = $receiver;
                this.changedRegions = new LinkedHashSet<E>();
                this.removedRegions = new LinkedHashSet<E>();
            }

            public final LinkedHashSet<FoldRegion> getChangedRegions() {
                return this.changedRegions;
            }

            public final LinkedHashSet<FoldRegion> getRemovedRegions() {
                return this.removedRegions;
            }

            public void beforeFoldRegionDisposed(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.removedRegions.add(region);
                this.changedRegions.remove(region);
            }

            public void beforeFoldRegionRemoved(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.removedRegions.add(region);
                this.changedRegions.remove(region);
            }

            public void onFoldRegionStateChange(FoldRegion region) {
                Intrinsics.checkNotNullParameter((Object)region, (String)"region");
                this.changedRegions.add(region);
            }

            /*
             * WARNING - void declaration
             */
            public void onFoldProcessingEnd() {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = this.changedRegions;
                boolean $i$f$filter22 = false;
                Object object = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo22 = false;
                for (T element$iv$iv : $this$filterTo$iv$iv2) {
                    FoldRegion it = (FoldRegion)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUserData(NotebookCellInlayManager.Companion.getFOLDING_MARKER_KEY()), (Object)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List changedRegions = (List)destination$iv$iv;
                this.changedRegions.clear();
                Iterable $i$f$filter22 = this.removedRegions;
                object = this.this$0;
                boolean $i$f$filter = false;
                void $i$f$filterTo22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    FoldRegion it = (FoldRegion)element$iv$iv;
                    boolean bl = false;
                    if (!(((NotebookCellInlayManager)object).getEditor().getFoldingModel().getCollapsedRegionAtOffset(it.getStartOffset()) == null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List removedRegions = (List)destination$iv$iv2;
                this.removedRegions.clear();
                NotebookCellInlayManager.update$default(this.this$0, false, false, arg_0 -> setupFoldingListener.1.onFoldProcessingEnd$lambda$2(changedRegions, removedRegions, this.this$0, arg_0), 3, null);
            }

            private static final Unit onFoldProcessingEnd$lambda$2(List $changedRegions, List $removedRegions, NotebookCellInlayManager this$0, UpdateContext it) {
                EditorCell it2;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                FoldRegion region;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable $this$forEach$iv2 = $changedRegions;
                boolean $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv2) {
                    region = (FoldRegion)element$iv;
                    boolean bl = false;
                    $this$forEach$iv = NotebookCellInlayManager.access$editorCells(this$0, region);
                    $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        it2 = (EditorCell)element$iv2;
                        boolean bl2 = false;
                        it2.isUnfolded().set(region.isExpanded());
                    }
                }
                $this$forEach$iv2 = $removedRegions;
                $i$f$forEach2 = false;
                for (T element$iv : $this$forEach$iv2) {
                    region = (FoldRegion)element$iv;
                    boolean bl = false;
                    $this$forEach$iv = NotebookCellInlayManager.access$editorCells(this$0, region);
                    $i$f$forEach = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        it2 = (EditorCell)element$iv2;
                        boolean bl3 = false;
                        it2.isUnfolded().set(true);
                    }
                }
                return Unit.INSTANCE;
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorCell> editorCells(FoldRegion region) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.notebook.getCells();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EditorCell cell = (EditorCell)element$iv$iv;
            boolean bl = false;
            DocumentEx documentEx = this.editor.getDocument();
            NotebookCellLines.Interval interval = cell.getIntervalPointer().get();
            Intrinsics.checkNotNull((Object)interval);
            int startOffset = documentEx.getLineStartOffset(interval.getLines().getFirst());
            DocumentEx documentEx2 = this.editor.getDocument();
            NotebookCellLines.Interval interval2 = cell.getIntervalPointer().get();
            Intrinsics.checkNotNull((Object)interval2);
            int endOffset = documentEx2.getLineEndOffset(interval2.getLines().getLast());
            if (!(startOffset >= region.getStartOffset() && endOffset <= region.getEndOffset())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void handleRefreshedDocument() {
        ThreadingAssertions.softAssertReadAccess();
        this.notebook.clear();
        NotebookIntervalPointerFactory pointerFactory = NotebookIntervalPointerFactory.Companion.get((Editor)this.editor);
        NotebookCellInlayManager.update$default(this, false, false, arg_0 -> NotebookCellInlayManager.handleRefreshedDocument$lambda$0(this, pointerFactory, arg_0), 1, null);
        NotebookCellInlayManager.update$default(this, false, false, arg_0 -> NotebookCellInlayManager.handleRefreshedDocument$lambda$1(this, arg_0), 1, null);
    }

    private final void updateCellsFolding(List<EditorCell> editorCells) {
        NotebookCellInlayManager.update$default(this, false, false, arg_0 -> NotebookCellInlayManager.updateCellsFolding$lambda$0(editorCells, arg_0), 3, null);
    }

    @Override
    public void onUpdated(@NotNull NotebookIntervalPointersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.currentEventsQueue.add(event);
        if (!event.isInBulkUpdate()) {
            this.bulkUpdateFinished();
        }
    }

    @Override
    public void bulkUpdateFinished() {
        NotebookCellInlayManager.update$default(this, false, false, arg_0 -> NotebookCellInlayManager.bulkUpdateFinished$lambda$0(this, arg_0), 3, null);
    }

    private final void fixInlaysOffsetsAfterNewCellInsert(NotebookIntervalPointersEvent.OnInserted change, UpdateContext ctx) {
        int prevCellIndex = ((NotebookIntervalPointersEvent.PointerSnapshot)CollectionsKt.first(change.getSubsequentPointers())).getInterval().getOrdinal() - 1;
        if (prevCellIndex >= 0) {
            EditorCell prevCell = this.getCell(prevCellIndex);
            prevCell.update(ctx);
        }
    }

    private final void addCell(NotebookIntervalPointer pointer) {
        this.notebook.addCell(pointer);
    }

    private final void removeCell(int index) {
        this.notebook.removeCell(index);
    }

    public final void addCellEventsListener(@NotNull EditorCellEventListener editorCellEventListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editorCellEventListener, (String)"editorCellEventListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.notebook.addCellEventsListener(disposable, editorCellEventListener);
    }

    public final void addCellViewEventsListener(@NotNull EditorCellViewEventListener editorCellViewEventListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editorCellViewEventListener, (String)"editorCellViewEventListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.cellViewEventListeners.addListener((EventListener)editorCellViewEventListener, disposable);
    }

    public final void fireCellViewCreated$intellij_notebooks_visualization(@NotNull EditorCellView cellView) {
        Intrinsics.checkNotNullParameter((Object)cellView, (String)"cellView");
        ((EditorCellViewEventListener)this.cellViewEventListeners.getMulticaster()).onEditorCellViewEvents(CollectionsKt.listOf((Object)new EditorCellViewEventListener.CellViewCreated(cellView)));
    }

    public final void fireCellViewRemoved$intellij_notebooks_visualization(@NotNull EditorCellView cellView) {
        Intrinsics.checkNotNullParameter((Object)cellView, (String)"cellView");
        ((EditorCellViewEventListener)this.cellViewEventListeners.getMulticaster()).onEditorCellViewEvents(CollectionsKt.listOf((Object)new EditorCellViewEventListener.CellViewRemoved(cellView)));
    }

    @NotNull
    public final EditorCell getCell(int index) {
        return this.getCells().get(index);
    }

    @NotNull
    public final EditorCell getCell(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.getCells().get(interval.getOrdinal());
    }

    @Nullable
    public final EditorCell getCellOrNull(int index) {
        return (EditorCell)CollectionsKt.getOrNull(this.getCells(), (int)index);
    }

    @Nullable
    public final EditorCell getCellOrNull(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return (EditorCell)CollectionsKt.getOrNull(this.getCells(), (int)interval.getOrdinal());
    }

    @Nullable
    public final EditorCell getCell(@NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        NotebookCellLines.Interval interval = pointer.get();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        return this.getCellOrNull(interval2);
    }

    private static final Unit updateAllOutputs$lambda$0(NotebookCellInlayManager this$0, UpdateContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.notebook.getCells();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it2 = (EditorCell)element$iv;
            boolean bl = false;
            it2.updateOutputs();
        }
        return Unit.INSTANCE;
    }

    private static final Unit forceUpdateAll$lambda$0(NotebookCellInlayManager this$0) {
        if (this$0.initialized) {
            this$0.updateCells(this$0.getCells(), true);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit update$lambda$0(NotebookCellInlayManager this$0, Collection $pointers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = $pointers;
        NotebookCellInlayManager notebookCellInlayManager = this$0;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            NotebookIntervalPointer it = (NotebookIntervalPointer)element$iv$iv;
            boolean bl2 = false;
            NotebookCellLines.Interval interval = it.get();
            if ((interval != null ? Integer.valueOf(interval.getOrdinal()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.getCells().get((int)it));
        }
        notebookCellInlayManager.updateCells((List)destination$iv$iv, false);
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$1(NotebookCellInlayManager this$0, EditorCell $cell) {
        this$0.update($cell.getIntervalPointer());
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$2(NotebookCellInlayManager this$0, NotebookIntervalPointer $pointer) {
        this$0.update((Collection)new SmartList((Object)$pointer));
        return Unit.INSTANCE;
    }

    private static final Unit updateCells$lambda$0(List $cells, NotebookCellInlayManager this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable $this$forEach$iv = $cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it = (EditorCell)element$iv;
            boolean bl = false;
            it.update(ctx);
        }
        this$0.updateCellsFolding($cells);
        return Unit.INSTANCE;
    }

    private static final void addViewportChangeListener$lambda$0(NotebookCellInlayManager this$0, ChangeEvent it) {
        Iterable $this$forEach$iv = this$0.notebook.getCells();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell it2 = (EditorCell)element$iv;
            boolean bl = false;
            it2.updateIfInVisibleRect();
        }
    }

    private static final void initialize$lambda$0(NotebookCellInlayManager this$0, EditorColorsScheme it) {
        this$0.updateAll();
    }

    private static final void initialize$lambda$1(NotebookCellInlayManager this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateAll();
    }

    private static final void initialize$lambda$2(NotebookCellInlayManager this$0, List events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        this$0.updateUI(events);
    }

    private static final int getCellByPoint$lambda$0(NotebookCellInlayManager this$0, Point $point, EditorCell it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.comparePointWithCell($point, it);
    }

    private static final Unit updateUI$lambda$0$0(NotebookCellInlayManager this$0, EditorCell $cell, boolean visible) {
        this$0.updateCellVisibility($cell, visible);
        return Unit.INSTANCE;
    }

    private static final Unit updateUI$lambda$0(List $events, NotebookCellInlayManager this$0, UpdateContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (EditorCellEventListener.EditorCellEvent event : $events) {
            EditorCellEventListener.EditorCellEvent editorCellEvent = event;
            if (editorCellEvent instanceof EditorCellEventListener.CellCreated) {
                EditorCell cell = ((EditorCellEventListener.CellCreated)event).getCell();
                NotebookEditorUiUtilKt.bind((ObservableProperty)cell.isUnfolded(), cell, arg_0 -> NotebookCellInlayManager.updateUI$lambda$0$0(this$0, cell, arg_0));
                continue;
            }
            if (editorCellEvent instanceof EditorCellEventListener.CellRemoved) {
                this$0.disposeCellView(((EditorCellEventListener.CellRemoved)event).getCell());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateCellVisibility$lambda$0(boolean $visible, NotebookCellInlayManager this$0, EditorCell $cell, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if ($visible) {
            this$0.createCellViewIfNecessary($cell, ctx);
        } else {
            this$0.disposeCellView($cell);
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleRefreshedDocument$lambda$0(NotebookCellInlayManager this$0, NotebookIntervalPointerFactory $pointerFactory, UpdateContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = this$0.notebookCellLines.getIntervals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)element$iv;
            boolean bl = false;
            this$0.notebook.addCell($pointerFactory.create(interval));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit handleRefreshedDocument$lambda$1(NotebookCellInlayManager this$0, UpdateContext it) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Component[] componentArray = this$0.editor.getContentComponent().getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$filterIsInstance$iv = componentArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EditorEmbeddedComponentManager.FullEditorWidthRenderer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorEmbeddedComponentManager.FullEditorWidthRenderer it2 = (EditorEmbeddedComponentManager.FullEditorWidthRenderer)element$iv;
            boolean bl = false;
            it2.doLayout();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateCellsFolding$lambda$0(List $editorCells, UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        Iterable $this$forEach$iv = $editorCells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell cell = (EditorCell)element$iv;
            boolean bl = false;
            EditorCellView editorCellView = cell.getView();
            if (editorCellView == null) continue;
            editorCellView.updateCellFolding(updateContext);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit bulkUpdateFinished$lambda$0(NotebookCellInlayManager this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List events = CollectionsKt.toList((Iterable)this$0.currentEventsQueue);
        this$0.currentEventsQueue.clear();
        for (NotebookIntervalPointersEvent event : events) {
            void $this$filterIsInstanceTo$iv$iv;
            Object element$iv;
            void $this$forEach$iv;
            Iterator $this$filterIsInstanceTo$iv$iv2;
            Object secondCell;
            Object object;
            for (NotebookIntervalPointersEvent.Change change : event.getChanges()) {
                NotebookIntervalPointersEvent.PointerSnapshot it;
                Iterable $this$forEach$iv2;
                object = change;
                if (object instanceof NotebookIntervalPointersEvent.OnEdited) {
                    EditorCell cell = this$0.notebook.getCells().get(((NotebookIntervalPointersEvent.OnEdited)change).getIntervalAfter().getOrdinal());
                    cell.updateInput();
                    continue;
                }
                if (object instanceof NotebookIntervalPointersEvent.OnInserted) {
                    $this$forEach$iv2 = ((NotebookIntervalPointersEvent.OnInserted)change).getSubsequentPointers();
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        it = (NotebookIntervalPointersEvent.PointerSnapshot)element$iv2;
                        boolean bl = false;
                        this$0.addCell(it.getPointer());
                    }
                    $this$forEach$iv2 = ((NotebookIntervalPointersEvent.OnInserted)change).getSubsequentPointers();
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        it = (NotebookIntervalPointersEvent.PointerSnapshot)element$iv2;
                        boolean bl = false;
                        EditorCell editorCell = this$0.getCellOrNull(it.getInterval().getOrdinal() - 1);
                        if (editorCell == null) continue;
                        editorCell.checkAndRebuildInlays();
                    }
                    if (!((NotebookIntervalPointersEvent.OnInserted)change).getOrdinals().contains(0)) continue;
                    EditorCell editorCell = this$0.getCellOrNull(((NotebookIntervalPointersEvent.OnInserted)change).getOrdinals().getLast() + 1);
                    if (editorCell == null) continue;
                    editorCell.checkAndRebuildInlays();
                    continue;
                }
                if (object instanceof NotebookIntervalPointersEvent.OnRemoved) {
                    $this$forEach$iv2 = CollectionsKt.reversed((Iterable)((NotebookIntervalPointersEvent.OnRemoved)change).getSubsequentPointers());
                    boolean $i$f$forEach = false;
                    for (Object element$iv3 : $this$forEach$iv2) {
                        it = (NotebookIntervalPointersEvent.PointerSnapshot)element$iv3;
                        boolean bl = false;
                        int index = it.getInterval().getOrdinal();
                        this$0.removeCell(index);
                        if (index != 0) continue;
                        EditorCell editorCell = this$0.getCellOrNull(0);
                        if (editorCell == null) continue;
                        editorCell.checkAndRebuildInlays();
                    }
                    continue;
                }
                if (object instanceof NotebookIntervalPointersEvent.OnSwapped) {
                    EditorCell firstCell = this$0.notebook.getCells().get(((NotebookIntervalPointersEvent.OnSwapped)change).getFirstOrdinal());
                    NotebookIntervalPointer first = firstCell.getIntervalPointer();
                    secondCell = this$0.notebook.getCells().get(((NotebookIntervalPointersEvent.OnSwapped)change).getSecondOrdinal());
                    firstCell.setIntervalPointer(((EditorCell)secondCell).getIntervalPointer());
                    ((EditorCell)secondCell).setIntervalPointer(first);
                    firstCell.update(ctx);
                    ((EditorCell)secondCell).update(ctx);
                    firstCell.checkAndRebuildInlays();
                    ((EditorCell)secondCell).checkAndRebuildInlays();
                    EditorCell editorCell = this$0.getCellOrNull(firstCell.getInterval().getOrdinal() - 1);
                    if (editorCell != null) {
                        editorCell.checkAndRebuildInlays();
                    }
                    EditorCell editorCell2 = this$0.getCellOrNull(((EditorCell)secondCell).getInterval().getOrdinal() - 1);
                    if (editorCell2 != null) {
                        editorCell2.checkAndRebuildInlays();
                    }
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            Iterable $this$filterIsInstance$iv = event.getChanges();
            boolean $i$f$filterIsInstance = false;
            object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            secondCell = $this$filterIsInstanceTo$iv$iv2.iterator();
            while (secondCell.hasNext()) {
                Object element$iv$iv = secondCell.next();
                if (!(element$iv$iv instanceof NotebookIntervalPointersEvent.OnInserted)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterIsInstanceTo$iv$iv2 = $this$forEach$iv.iterator();
            while ($this$filterIsInstanceTo$iv$iv2.hasNext()) {
                element$iv = $this$filterIsInstanceTo$iv$iv2.next();
                NotebookIntervalPointersEvent.OnInserted change = (NotebookIntervalPointersEvent.OnInserted)element$iv;
                boolean bl = false;
                this$0.fixInlaysOffsetsAfterNewCellInsert(change, ctx);
            }
            Iterable $this$filterIsInstance$iv2 = event.getChanges();
            boolean $i$f$filterIsInstance2 = false;
            element$iv = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof NotebookIntervalPointersEvent.OnEdited)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List changedEvents = (List)destination$iv$iv2;
            if (changedEvents.size() <= 1) continue;
            Iterable $this$forEach$iv3 = changedEvents;
            boolean $i$f$forEach2 = false;
            for (Object element$iv4 : $this$forEach$iv3) {
                EditorCell cell;
                NotebookIntervalPointersEvent.OnEdited event2 = (NotebookIntervalPointersEvent.OnEdited)element$iv4;
                boolean bl = false;
                if ((EditorCell)CollectionsKt.getOrNull(this$0.notebook.getCells(), (int)event2.getIntervalAfter().getOrdinal()) == null) continue;
                cell.checkAndRebuildInlays();
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateSelection(NotebookCellInlayManager $this) {
        $this.updateSelection();
    }

    public static final /* synthetic */ List access$editorCells(NotebookCellInlayManager $this, FoldRegion region) {
        return $this.editorCells(region);
    }

    public /* synthetic */ NotebookCellInlayManager(EditorImpl editor, EditorNotebook notebook, DefaultConstructorMarker $constructor_marker) {
        this(editor, notebook);
    }

    static {
        Key key = Key.create((String)NotebookCellInlayManager.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CELL_INLAY_MANAGER_KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u00050\u0010\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/notebooks/visualization/NotebookCellInlayManager$Companion;", "", "<init>", "()V", "install", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "editorNotebookPostprocessors", "", "Lcom/intellij/notebooks/visualization/EditorNotebookPostprocessor;", "createNotebook", "Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "get", "Lcom/intellij/openapi/editor/Editor;", "FOLDING_MARKER_KEY", "Lcom/intellij/openapi/util/Key;", "", "getFOLDING_MARKER_KEY", "()Lcom/intellij/openapi/util/Key;", "CELL_INLAY_MANAGER_KEY", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nNotebookCellInlayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,486:1\n1#2:487\n1915#3,2:488\n*S KotlinDebug\n*F\n+ 1 NotebookCellInlayManager.kt\ncom/intellij/notebooks/visualization/NotebookCellInlayManager$Companion\n*L\n345#1:488,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookCellInlayManager install(@NotNull EditorImpl editor, @NotNull List<? extends EditorNotebookPostprocessor> editorNotebookPostprocessors) {
            NotebookCellInlayManager notebookCellInlayManager;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(editorNotebookPostprocessors, (String)"editorNotebookPostprocessors");
            new EditorEmbeddedComponentContainer((EditorEx)editor);
            UpdateManager updateManager = new UpdateManager(editor);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)updateManager);
            EditorNotebook notebook = this.createNotebook(editor, editorNotebookPostprocessors);
            NotebookCellInlayManager it = notebookCellInlayManager = new NotebookCellInlayManager(editor, notebook, null);
            boolean bl = false;
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)it);
            NotebookCellInlayManager notebookCellInlayManager2 = notebookCellInlayManager;
            NotebookIntervalPointerFactory.Companion.get((Editor)editor).getChangeListeners().addListener((EventListener)notebookCellInlayManager2, (Disposable)notebookCellInlayManager2);
            return notebookCellInlayManager2;
        }

        public static /* synthetic */ NotebookCellInlayManager install$default(Companion companion, EditorImpl editorImpl, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.install(editorImpl, list);
        }

        private final EditorNotebook createNotebook(EditorImpl editor, List<? extends EditorNotebookPostprocessor> editorNotebookPostprocessors) {
            EditorNotebook notebook = new EditorNotebook(editor);
            Iterable $this$forEach$iv = editorNotebookPostprocessors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EditorNotebookPostprocessor it = (EditorNotebookPostprocessor)element$iv;
                boolean bl = false;
                it.postprocess(notebook);
            }
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)notebook);
            return notebook;
        }

        @Nullable
        public final NotebookCellInlayManager get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (NotebookCellInlayManager)CELL_INLAY_MANAGER_KEY.get((UserDataHolder)editor);
        }

        @NotNull
        public final Key<Boolean> getFOLDING_MARKER_KEY() {
            return FOLDING_MARKER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

