/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.ActionToGutterRendererAdapter;
import com.intellij.notebooks.visualization.ui.CellCustomFoldingRender;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.EditorEmbeddedComponentContainerKt;
import com.intellij.notebooks.visualization.ui.EditorEmbeddedComponentLayoutManager;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.properties.ObservableProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0005H\u0007J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0017H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/notebooks/visualization/ui/CustomFoldingEditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;Ljavax/swing/JComponent;)V", "getCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "getComponent$intellij_notebooks_visualization", "()Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "foldingRegion", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "gutterActionRenderer", "Lcom/intellij/notebooks/visualization/ui/ActionToGutterRendererAdapter;", "bottomContainer", "Ljavax/swing/JPanel;", "mainComponent", "presentationToComponent", "", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "getComponentForTest", "updateGutterIcons", "", "gutterAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "disposeFolding", "ctx", "Lcom/intellij/notebooks/visualization/UpdateContext;", "calculateBounds", "Ljava/awt/Rectangle;", "updateCellFolding", "updateContext", "addInlayBelow", "presentation", "removeInlayBelow", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nCustomFoldingEditorCellViewComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomFoldingEditorCellViewComponent.kt\ncom/intellij/notebooks/visualization/ui/CustomFoldingEditorCellViewComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public class CustomFoldingEditorCellViewComponent
extends EditorCellViewComponent {
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final JComponent component;
    @NotNull
    private final EditorEx editor;
    @Nullable
    private CustomFoldRegion foldingRegion;
    @Nullable
    private ActionToGutterRendererAdapter gutterActionRenderer;
    @NotNull
    private final JPanel bottomContainer;
    @NotNull
    private final JPanel mainComponent;
    @NotNull
    private final Map<InlayPresentation, JComponent> presentationToComponent;

    /*
     * WARNING - void declaration
     */
    public CustomFoldingEditorCellViewComponent(@NotNull EditorCell cell, @NotNull JComponent component) {
        void $this$mainComponent_u24lambda_u240;
        JPanel $this$bottomContainer_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.cell = cell;
        this.component = component;
        this.editor = (EditorEx)this.cell.getEditor();
        JPanel jPanel2 = jPanel = new JPanel();
        CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent = this;
        boolean bl = false;
        $this$bottomContainer_u24lambda_u240.setOpaque(false);
        $this$bottomContainer_u24lambda_u240.setLayout(new BoxLayout($this$bottomContainer_u24lambda_u240, 1));
        customFoldingEditorCellViewComponent.bottomContainer = jPanel;
        $this$bottomContainer_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        customFoldingEditorCellViewComponent = this;
        boolean bl2 = false;
        $this$mainComponent_u24lambda_u240.setOpaque(false);
        $this$mainComponent_u24lambda_u240.add((Component)this.component, "Center");
        $this$mainComponent_u24lambda_u240.add((Component)this.bottomContainer, "South");
        customFoldingEditorCellViewComponent.mainComponent = jPanel;
        this.presentationToComponent = new LinkedHashMap();
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)this.cell.getGutterAction(), (Disposable)this, arg_0 -> CustomFoldingEditorCellViewComponent._init_$lambda$0(this, arg_0));
        NotebookEditorUiUtilKt.bind(NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getEditorBackgroundColor(), (Disposable)this, arg_0 -> CustomFoldingEditorCellViewComponent._init_$lambda$1(this, arg_0));
    }

    @NotNull
    protected final EditorCell getCell() {
        return this.cell;
    }

    @NotNull
    public final JComponent getComponent$intellij_notebooks_visualization() {
        return this.component;
    }

    @TestOnly
    @NotNull
    public final JComponent getComponentForTest() {
        return this.component;
    }

    private final void updateGutterIcons(AnAction gutterAction) {
        UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.editor), false, false, arg_0 -> CustomFoldingEditorCellViewComponent.updateGutterIcons$lambda$0(this, gutterAction, arg_0), 3, null);
    }

    public void dispose() {
        UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.editor), false, false, arg_0 -> CustomFoldingEditorCellViewComponent.dispose$lambda$0(this, arg_0), 3, null);
    }

    private final void disposeFolding(UpdateContext ctx) {
        ctx.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> CustomFoldingEditorCellViewComponent.disposeFolding$lambda$0(this, arg_0)));
        EditorEmbeddedComponentContainerKt.getComponentContainer((Editor)this.editor).remove(this.mainComponent);
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        CustomFoldRegion customFoldRegion = this.foldingRegion;
        if (customFoldRegion == null) {
            Rectangle rectangle = this.mainComponent.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            return rectangle;
        }
        CustomFoldRegion region = customFoldRegion;
        Point point = region.getLocation();
        if (point == null) {
            Rectangle rectangle = this.mainComponent.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            return rectangle;
        }
        Point location = point;
        return new Rectangle(location.x, location.y, region.getWidthInPixels(), region.getHeightInPixels());
    }

    @Override
    public void updateCellFolding(@NotNull UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        updateContext.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> CustomFoldingEditorCellViewComponent.updateCellFolding$lambda$0(this, arg_0)));
    }

    @Override
    public void addInlayBelow(@NotNull InlayPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        JComponent inlayComponent2 = new JComponent(presentation){
            final /* synthetic */ InlayPresentation $presentation;
            {
                this.$presentation = $presentation;
                this.enableEvents(48L);
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.$presentation.getWidth(), this.$presentation.getHeight());
            }

            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                Graphics2D cfr_ignored_0 = (Graphics2D)g;
                TextAttributes attributes = new TextAttributes();
                this.$presentation.paint((Graphics2D)g, attributes);
            }

            protected void processMouseMotionEvent(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getID() == 503) {
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    this.$presentation.mouseMoved(e, point);
                }
            }

            protected void processMouseEvent(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getID()) {
                    case 505: {
                        this.$presentation.mouseExited();
                        break;
                    }
                    case 500: {
                        Point point = e.getPoint();
                        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                        this.$presentation.mouseClicked(e, point);
                        break;
                    }
                    case 501: {
                        Point point = e.getPoint();
                        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                        this.$presentation.mousePressed(e, point);
                        break;
                    }
                    case 502: {
                        Point point = e.getPoint();
                        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                        this.$presentation.mouseReleased(e, point);
                    }
                }
            }
        };
        this.presentationToComponent.put(presentation, inlayComponent2);
        this.bottomContainer.add(inlayComponent2);
    }

    @Override
    public void removeInlayBelow(@NotNull InlayPresentation presentation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            JComponent jComponent = this.presentationToComponent.remove(presentation);
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            this.bottomContainer.remove(it);
        }
    }

    private static final Unit updateGutterIcons$lambda$0$1(CustomFoldingEditorCellViewComponent this$0, FoldingModelEx it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CustomFoldRegion customFoldRegion = this$0.foldingRegion;
            if (customFoldRegion == null) break block0;
            customFoldRegion.update();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateGutterIcons$lambda$0(CustomFoldingEditorCellViewComponent this$0, AnAction $gutterAction, UpdateContext ctx) {
        ActionToGutterRendererAdapter actionToGutterRendererAdapter;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent = this$0;
        AnAction anAction = $gutterAction;
        if (anAction != null) {
            void it;
            AnAction anAction2 = anAction;
            CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent2 = customFoldingEditorCellViewComponent;
            boolean bl = false;
            actionToGutterRendererAdapter = new ActionToGutterRendererAdapter((AnAction)it);
            customFoldingEditorCellViewComponent = customFoldingEditorCellViewComponent2;
        } else {
            actionToGutterRendererAdapter = null;
        }
        customFoldingEditorCellViewComponent.gutterActionRenderer = actionToGutterRendererAdapter;
        ctx.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> CustomFoldingEditorCellViewComponent.updateGutterIcons$lambda$0$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(CustomFoldingEditorCellViewComponent this$0, AnAction action2) {
        this$0.updateGutterIcons(action2);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CustomFoldingEditorCellViewComponent this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.bottomContainer.setBackground(it);
        return Unit.INSTANCE;
    }

    private static final Unit dispose$lambda$0(CustomFoldingEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.disposeFolding(ctx);
        return Unit.INSTANCE;
    }

    private static final Unit disposeFolding$lambda$0(CustomFoldingEditorCellViewComponent this$0, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        CustomFoldRegion region = this$0.foldingRegion;
        this$0.foldingRegion = null;
        CustomFoldRegion customFoldRegion = region;
        boolean bl = customFoldRegion != null ? customFoldRegion.isValid() : false;
        if (bl) {
            foldingModel.removeFoldRegion((FoldRegion)region);
        }
        return Unit.INSTANCE;
    }

    private static final GutterIconRenderer updateCellFolding$lambda$0$0(CustomFoldingEditorCellViewComponent this$0) {
        return this$0.gutterActionRenderer;
    }

    private static final CharSequence updateCellFolding$lambda$0$1(FoldRegion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final Unit updateCellFolding$lambda$0(CustomFoldingEditorCellViewComponent this$0, FoldingModelEx foldingModel) {
        IntRange lines;
        CustomFoldRegion newFolding;
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        CustomFoldRegion prevFolding = this$0.foldingRegion;
        if (prevFolding != null) {
            foldingModel.removeFoldRegion((FoldRegion)prevFolding);
        }
        if ((newFolding = foldingModel.addCustomLinesFolding((lines = this$0.cell.getInterval().getLines()).getFirst(), lines.getLast(), (CustomFoldRegionRenderer)new CellCustomFoldingRender(this$0.mainComponent, (Function0<? extends GutterIconRenderer>)((Function0)() -> CustomFoldingEditorCellViewComponent.updateCellFolding$lambda$0$0(this$0))))) == null) {
            FoldRegion[] foldRegionArray = foldingModel.getAllFoldRegions();
            Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
            String string = "Folding for " + lines + ", cannot be created (e.g., due to unsupported overlapping with already existing regions.\nExisting regions:\n " + ArraysKt.joinToString$default((Object[])foldRegionArray, (CharSequence)"\n", null, null, (int)0, null, CustomFoldingEditorCellViewComponent::updateCellFolding$lambda$0$1, (int)30, null);
            throw new IllegalStateException(string.toString());
        }
        newFolding.putUserData(CustomFoldRegion.IMMUTABLE_FOLD_REGION, (Object)true);
        this$0.foldingRegion = newFolding;
        EditorEmbeddedComponentContainerKt.getComponentContainer((Editor)this$0.editor).add(this$0.mainComponent, new EditorEmbeddedComponentLayoutManager.CustomFoldingConstraint(newFolding, true));
        return Unit.INSTANCE;
    }
}

