/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.ui.EditorTextField;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LocalTimeCounter;
import com.jetbrains.ide.model.uiautomation.BeTextControlWithLanguage;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.views.TextControlWithLanguageViewControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IProperty;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/TextControlWithLanguageViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeTextControlWithLanguage;", "<init>", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createDocument", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "createPsi", "", "intellij.rd.ui"})
public final class TextControlWithLanguageViewControl
implements ViewBinder<BeTextControlWithLanguage> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeTextControlWithLanguage viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        RdLanguage rdLanguage = viewModel.getLanguage();
        if (rdLanguage == null || (rdLanguage = ProtocolLanguageManagerKt.toIdeaFileType((RdLanguage)rdLanguage)) == null) {
            LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
            Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"PLAIN_TEXT");
            rdLanguage = (FileType)languageFileType;
        }
        RdLanguage fileType = rdLanguage;
        RdProjectId rdProjectId = viewModel.getProjectId();
        Project project = rdProjectId != null ? ProjectUtilKt.toProject((RdProjectId)rdProjectId) : null;
        JComponent result = null;
        if (((Boolean)viewModel.getTextControl().getSettings().getReadonly().getValue()).booleanValue()) {
            result = (JComponent)new MethodSignatureComponent(project, (FileType)fileType){

                protected EditorEx createEditor() {
                    EditorEx editorEx;
                    EditorEx $this$createEditor_u24lambda_u240 = editorEx = super.createEditor();
                    boolean bl = false;
                    $this$createEditor_u24lambda_u240.getSettings().setUseSoftWraps(true);
                    this.setMinimumSize(new Dimension(300, 60));
                    EditorEx editorEx2 = editorEx;
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"apply(...)");
                    return editorEx2;
                }
            };
            viewModel.getTextControl().getText().advise(lifetime, arg_0 -> TextControlWithLanguageViewControl.bind$lambda$0(result, arg_0));
        } else {
            String fileName = viewModel.getCustomFileName();
            Document document = this.createDocument(project, fileName, (FileType)fileType, viewModel.getCreatePsiFile());
            EditorTextField textField2 = new EditorTextField(document, project, (FileType)fileType){
                final /* synthetic */ Project $project;
                final /* synthetic */ FileType $fileType;
                {
                    this.$project = $project;
                    this.$fileType = $fileType;
                    super($document, $project, $fileType);
                }

                protected EditorEx createEditor() {
                    EditorEx editorEx = super.createEditor();
                    Project project = this.$project;
                    FileType fileType = this.$fileType;
                    EditorEx $this$createEditor_u24lambda_u240 = editorEx;
                    boolean bl = false;
                    $this$createEditor_u24lambda_u240.getSettings().setUseSoftWraps(true);
                    $this$createEditor_u24lambda_u240.setHighlighter(EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(project, fileType));
                    $this$createEditor_u24lambda_u240.getSettings().setWhitespacesShown(false);
                    $this$createEditor_u24lambda_u240.getSettings().setCaretRowShown(true);
                    $this$createEditor_u24lambda_u240.setHorizontalScrollbarVisible(true);
                    $this$createEditor_u24lambda_u240.setVerticalScrollbarVisible(true);
                    this.setMinimumSize(new Dimension(300, 60));
                    EditorEx editorEx2 = editorEx;
                    Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"apply(...)");
                    return editorEx2;
                }
            };
            textField2.setFont(EditorFontType.PLAIN.getGlobalFont());
            textField2.setCaretPosition(0);
            Ref.BooleanRef localCookie = new Ref.BooleanRef();
            DocumentListener value2 = new DocumentListener(localCookie, viewModel, textField2){
                final /* synthetic */ Ref.BooleanRef $localCookie;
                final /* synthetic */ BeTextControlWithLanguage $viewModel;
                final /* synthetic */ bind.textField.1 $textField;
                {
                    this.$localCookie = $localCookie;
                    this.$viewModel = $viewModel;
                    this.$textField = $textField;
                }

                public void documentChanged(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (this.$localCookie.element) {
                        return;
                    }
                    this.$localCookie.element = true;
                    IProperty iProperty = this.$viewModel.getTextControl().getText();
                    String string = this.$textField.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    iProperty.set((Object)string);
                    this.$localCookie.element = false;
                }
            };
            lifetime.bracketIfAlive(() -> TextControlWithLanguageViewControl.bind$lambda$1(textField2, value2), () -> TextControlWithLanguageViewControl.bind$lambda$2(textField2, value2));
            viewModel.getTextControl().getText().advise(lifetime, arg_0 -> TextControlWithLanguageViewControl.bind$lambda$3(localCookie, textField2, arg_0));
            textField2.setOneLineMode(false);
            AnAction findAction = ActionManager.getInstance().getAction("Find");
            if (findAction != null) {
                textField2.addFocusListener(new FocusListener(lifetime, textField2, findAction){
                    private final SequentialLifetimes sequentialLifetimes;
                    final /* synthetic */ bind.textField.1 $textField;
                    final /* synthetic */ AnAction $findAction;
                    {
                        this.$textField = $textField;
                        this.$findAction = $findAction;
                        this.sequentialLifetimes = new SequentialLifetimes($lifetime);
                    }

                    public void focusGained(FocusEvent e) {
                        JComponent component = this.$textField.getComponent();
                        this.$findAction.registerCustomShortcutSet(this.$findAction.getShortcutSet(), component, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)this.sequentialLifetimes.next()), null, (int)1, null));
                    }

                    public void focusLost(FocusEvent e) {
                        this.sequentialLifetimes.terminateCurrent();
                    }
                });
            }
            result = (JComponent)textField2;
        }
        viewModel.getEnabled().advise(lifetime, arg_0 -> TextControlWithLanguageViewControl.bind$lambda$4(result, arg_0));
        return result;
    }

    private final Document createDocument(Project project, String fileName, FileType fileType, boolean createPsi) {
        if (!createPsi || project == null) {
            return EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        long stamp = LocalTimeCounter.currentTime();
        Object object = fileName;
        if (object == null) {
            object = "Dummy." + fileType.getDefaultExtension();
        }
        PsiFile psiFile = factory.createFileFromText((String)object, fileType, (CharSequence)"", stamp, true, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        PsiFile psiFile2 = psiFile;
        return PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
    }

    private static final void bind$lambda$3$0(bind.textField.1 $textField, String $it) {
        $textField.getDocument().setText((CharSequence)$it);
    }

    private static final Unit bind$lambda$0(JComponent $result, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Object)$result).setSignature(it);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$1(bind.textField.1 $textField, DocumentListener $value) {
        $textField.addDocumentListener($value);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$2(bind.textField.1 $textField, DocumentListener $value) {
        $textField.removeDocumentListener($value);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(Ref.BooleanRef $localCookie, bind.textField.1 $textField, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($localCookie.element) {
            return Unit.INSTANCE;
        }
        $localCookie.element = true;
        DocumentUtil.writeInRunUndoTransparentAction(() -> TextControlWithLanguageViewControl.bind$lambda$3$0($textField, it));
        $localCookie.element = false;
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$4(JComponent $result, boolean it) {
        ((EditorTextField)$result).setEnabled(it);
        return Unit.INSTANCE;
    }
}

