/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.customControls;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeAlignment;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeEditorComboBox;
import com.jetbrains.ide.model.uiautomation.ValidationResult;
import com.jetbrains.ide.model.uiautomation.ValidationStates;
import com.jetbrains.ide.model.uiautomation.ValidationStyle;
import com.jetbrains.ide.model.uiautomation.ValidationTrigger;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.bindable.views.customControls.ComboBoxEditorWithComponent;
import com.jetbrains.rd.ui.bindable.views.customControls.EditorComboBoxModel;
import com.jetbrains.rd.ui.bindable.views.listControl.renderers.RdCellRenderer;
import com.jetbrains.rd.ui.bindable.views.utils.BeComponentsKt;
import com.jetbrains.rd.ui.bindable.views.utils.BeMagicMargin;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/customControls/EditorComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "init", "", "beEditorComboBox", "Lcom/jetbrains/ide/model/uiautomation/BeEditorComboBox;", "updateBackgroundColor", "bindValidation", "editorComponent", "Ljava/awt/Component;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nEditorComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorComboBox.kt\ncom/jetbrains/rd/ui/bindable/views/customControls/EditorComboBox\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class EditorComboBox
extends ComboBox<Object> {
    @NotNull
    private final Lifetime lifetime;

    public EditorComboBox(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
    }

    public final void init(@NotNull BeEditorComboBox beEditorComboBox) {
        Intrinsics.checkNotNullParameter((Object)beEditorComboBox, (String)"beEditorComboBox");
        JComponent editorComponent = ViewRegistryKt.getView(beEditorComboBox.getEditorComponent(), this.lifetime);
        this.setEditable(true);
        this.setModel(new EditorComboBoxModel(this.lifetime, beEditorComboBox));
        this.setEditor(new ComboBoxEditorWithComponent(editorComponent));
        Object[] objectArray = new BeAlignment[]{BeAlignment.Left};
        this.setRenderer(new RdCellRenderer(CollectionsKt.arrayListOf((Object[])objectArray), false, 2, null));
        this.setUsePreferredSizeAsMinimum(false);
        this.setMinimumAndPreferredWidth(BeMagicMargin.Companion.getMinimumComboboxWidth());
        BeComponentsKt.bindDefaultProperties((BeControl)beEditorComboBox, this.lifetime, (JComponent)((Object)this));
        beEditorComboBox.getEnabled().advise(this.lifetime, arg_0 -> EditorComboBox.init$lambda$0(this, beEditorComboBox, arg_0));
        this.bindValidation(beEditorComboBox, editorComponent);
    }

    private final void updateBackgroundColor() {
        Component component = this.editor.getEditorComponent();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        EditorTextField etf = (EditorTextField)UIUtil.findComponentOfType((JComponent)((JComponent)component), EditorTextField.class);
        if (etf != null) {
            this.editor.getEditorComponent().setBackground(etf.getBackground());
        }
        this.repaint();
    }

    private final void bindValidation(BeEditorComboBox beEditorComboBox, Component editorComponent) {
        Color color = editorComponent.getForeground();
        JBColor error = JBColor.RED;
        JBColor warning = JBColor.ORANGE;
        beEditorComboBox.getValidationResult().view(this.lifetime, (arg_0, arg_1) -> EditorComboBox.bindValidation$lambda$0(beEditorComboBox, editorComponent, error, warning, color, this, arg_0, arg_1));
    }

    private static final Unit init$lambda$0(EditorComboBox this$0, BeEditorComboBox $beEditorComboBox, boolean it) {
        this$0.updateBackgroundColor();
        $beEditorComboBox.getRevalidate().fire((Object)ValidationTrigger.ValueChanged);
        return Unit.INSTANCE;
    }

    private static final Unit bindValidation$lambda$0(BeEditorComboBox $beEditorComboBox, Component $editorComponent, JBColor $error, JBColor $warning, Color $default, EditorComboBox this$0, Lifetime lifetime, ValidationResult it) {
        Component component;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if ($beEditorComboBox.getValidationStyle().getValueOrNull() != ValidationStyle.Text) break block10;
                switch (WhenMappings.$EnumSwitchMapping$0[it.getState().ordinal()]) {
                    case 1: {
                        $editorComponent.setForeground((Color)$error);
                        break block11;
                    }
                    case 2: {
                        $editorComponent.setForeground((Color)$warning);
                        break block11;
                    }
                    case 3: {
                        $editorComponent.setForeground($default);
                        break block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[it.getState().ordinal()]) {
                case 1: {
                    this$0.putClientProperty("JComponent.outline", "error");
                    break;
                }
                case 2: {
                    this$0.putClientProperty("JComponent.outline", "warning");
                    break;
                }
                case 3: {
                    this$0.putClientProperty("JComponent.outline", null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        $beEditorComboBox.getTooltip().set((Object)it.getResultMessage());
        Component $this$bindValidation_u24lambda_u240_u240 = component = $editorComponent;
        boolean bl = false;
        this$0.setToolTipText(it.getResultMessage());
        this$0.repaint();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationStates.values().length];
            try {
                nArray[ValidationStates.validationError.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationStates.validationWarning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationStates.validationPassed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

