/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.customControls;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.ui.EditorTextField;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J\b\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u000e\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/customControls/SynchronizedEditorTextField;", "Lcom/intellij/ui/EditorTextField;", "shouldHaveBorder", "", "<init>", "(Z)V", "myEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "isEnabled", "setEnabled", "", "enabled", "setEditor", "editorEx", "createEditor", "intellij.rd.ui"})
public final class SynchronizedEditorTextField
extends EditorTextField {
    private final boolean shouldHaveBorder;
    @Nullable
    private EditorEx myEditor;
    private boolean isEnabled;

    public SynchronizedEditorTextField(boolean shouldHaveBorder) {
        this.shouldHaveBorder = shouldHaveBorder;
        this.isEnabled = true;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        block0: {
            this.isEnabled = enabled;
            this.setFocusTraversalPolicyProvider(enabled);
            this.setViewerEnabled(enabled);
            Object object = this.myEditor;
            if (object == null || (object = object.getContentComponent()) == null) break block0;
            ((JComponent)object).setEnabled(enabled);
        }
    }

    public final void setEditor(@NotNull EditorEx editorEx) {
        Intrinsics.checkNotNullParameter((Object)editorEx, (String)"editorEx");
        this.myEditor = editorEx;
        this.setDocument((Document)editorEx.getDocument());
    }

    protected boolean shouldHaveBorder() {
        return this.shouldHaveBorder;
    }

    @NotNull
    protected EditorEx createEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            EditorEx editorEx2 = super.createEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"createEditor(...)");
            return editorEx2;
        }
        EditorEx editor = editorEx;
        editor.setCaretEnabled(!this.isViewer());
        editor.getCaretModel().moveToOffset(this.getDocument().getTextLength());
        if (!this.shouldHaveBorder()) {
            editor.setBorder(null);
        }
        if (this.isViewer()) {
            editor.getSelectionModel().removeSelection();
        }
        editor.getContentComponent().setFocusCycleRoot(false);
        editor.getContentComponent().addFocusListener((FocusListener)((Object)this));
        editor.getContentComponent().addMouseListener((MouseListener)((Object)this));
        editor.setBackgroundColor(this.getBackground());
        editor.getContentComponent().setEnabled(this.isEnabled);
        return editor;
    }
}

