/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenGAVIndex;
import org.jetbrains.idea.maven.indices.MavenIndex;

public class MavenIndexHolder {
    @Nullable
    private final MavenIndex myLocalClassIndex;
    @NotNull
    private final List<MavenIndex> myRemoteIndices;
    @NotNull
    private final List<MavenIndex> myIndices;

    MavenIndexHolder(@NotNull List<MavenIndex> remoteIndices, @Nullable MavenIndex localIndex) {
        if (remoteIndices == null) {
            MavenIndexHolder.$$$reportNull$$$0(0);
        }
        this.myLocalClassIndex = localIndex;
        this.myRemoteIndices = List.copyOf((Collection)Objects.requireNonNull(remoteIndices));
        ArrayList<MavenIndex> indices = new ArrayList<MavenIndex>(remoteIndices);
        if (this.myLocalClassIndex != null) {
            indices.add(this.myLocalClassIndex);
        }
        this.myIndices = List.copyOf(indices);
    }

    @Nullable
    public MavenIndex getLocalIndex() {
        return this.myLocalClassIndex;
    }

    @NotNull
    public List<MavenIndex> getRemoteIndices() {
        List<MavenIndex> list = this.myRemoteIndices;
        if (list == null) {
            MavenIndexHolder.$$$reportNull$$$0(1);
        }
        return list;
    }

    public List<MavenGAVIndex> getGAVIndices() {
        if (this.myLocalClassIndex == null) {
            return ContainerUtil.filter(this.myRemoteIndices, idx -> idx != null);
        }
        ArrayList<MavenGAVIndex> result = new ArrayList<MavenGAVIndex>(this.getRemoteIndices());
        result.add(this.myLocalClassIndex);
        return result;
    }

    @NotNull
    public List<MavenIndex> getIndices() {
        List<MavenIndex> list = this.myIndices;
        if (list == null) {
            MavenIndexHolder.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isEquals(@NotNull Set<String> remoteUrls, @Nullable String localPath) {
        if (remoteUrls == null) {
            MavenIndexHolder.$$$reportNull$$$0(3);
        }
        if (!FileUtilRt.pathsEqual(this.myLocalClassIndex != null ? this.myLocalClassIndex.getRepository().getUrl() : null, (String)localPath)) {
            return false;
        }
        if (remoteUrls.size() != this.myRemoteIndices.size()) {
            return false;
        }
        for (MavenIndex index : this.myRemoteIndices) {
            if (remoteUrls.contains(index.getRepository().getUrl())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MavenIndexHolder{" + String.valueOf(this.myIndices) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteIndices";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndexHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndexHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteIndices";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEquals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

