/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ssl.Idle;
import org.jetbrains.idea.maven.server.ssl.ReadNextCertificate;
import org.jetbrains.idea.maven.server.ssl.SslDelegateHandlerStateMachine;
import org.jetbrains.idea.maven.server.ssl.State;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/server/ssl/ReadForCertificates;", "Lorg/jetbrains/idea/maven/server/ssl/State;", "machine", "Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "key", "", "len", "toRead", "authType", "", "certificates", "Ljava/util/ArrayList;", "Ljava/security/cert/X509Certificate;", "<init>", "(Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;IIILjava/lang/String;Ljava/util/ArrayList;)V", "getMachine", "()Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "getKey", "()I", "getLen", "getToRead", "getAuthType", "()Ljava/lang/String;", "getCertificates", "()Ljava/util/ArrayList;", "addLine", "text", "intellij.maven"})
public final class ReadForCertificates
extends State {
    @NotNull
    private final SslDelegateHandlerStateMachine machine;
    private final int key;
    private final int len;
    private final int toRead;
    @NotNull
    private final String authType;
    @NotNull
    private final ArrayList<X509Certificate> certificates;

    public ReadForCertificates(@NotNull SslDelegateHandlerStateMachine machine, int key, int len, int toRead, @NotNull String authType, @NotNull ArrayList<X509Certificate> certificates) {
        Intrinsics.checkNotNullParameter((Object)machine, (String)"machine");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        super(null);
        this.machine = machine;
        this.key = key;
        this.len = len;
        this.toRead = toRead;
        this.authType = authType;
        this.certificates = certificates;
    }

    @NotNull
    public final SslDelegateHandlerStateMachine getMachine() {
        return this.machine;
    }

    public final int getKey() {
        return this.key;
    }

    public final int getLen() {
        return this.len;
    }

    public final int getToRead() {
        return this.toRead;
    }

    @NotNull
    public final String getAuthType() {
        return this.authType;
    }

    @NotNull
    public final ArrayList<X509Certificate> getCertificates() {
        return this.certificates;
    }

    @Override
    @NotNull
    public State addLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String begin = text;
        if (Intrinsics.areEqual((Object)begin, (Object)"-----BEGIN CERTIFICATE-----")) {
            return new ReadNextCertificate(this.machine, this.key, this.len, this.toRead, this.authType, this.certificates, new StringBuilder());
        }
        return new Idle(this.machine);
    }
}

