/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.analyser.checkers;

import com.intellij.charts.analyser.checkers.SeriesChecker;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.aggregation.Var;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.ColumnId;
import com.intellij.charts.settings.data.BarSeriesSettings;
import com.intellij.charts.settings.data.ColumnModifier;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/charts/analyser/checkers/BarSeriesChecker;", "Lcom/intellij/charts/analyser/checkers/SeriesChecker;", "<init>", "()V", "check", "", "Lcom/intellij/charts/settings/data/SeriesSettings;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nBarSeriesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarSeriesChecker.kt\ncom/intellij/charts/analyser/checkers/BarSeriesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1080#2:35\n*S KotlinDebug\n*F\n+ 1 BarSeriesChecker.kt\ncom/intellij/charts/analyser/checkers/BarSeriesChecker\n*L\n28#1:35\n*E\n"})
public final class BarSeriesChecker
implements SeriesChecker {
    @Override
    @NotNull
    public List<SeriesSettings> check(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        List<Column<Number>> numericalColumns = SeriesChecker.Companion.getNumericalColumns(dataFrame);
        List<Column<String>> stringColumns = SeriesChecker.Companion.getStringColumns(dataFrame);
        if (numericalColumns.isEmpty() || stringColumns.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (dataFrame.getRowsCount() > 30) {
            return CollectionsKt.emptyList();
        }
        ColumnId columnId = dataFrame.getColumnId((Column)CollectionsKt.first(stringColumns));
        if (columnId == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId xColumnId = columnId;
        Iterable $this$sortedByDescending$iv = numericalColumns;
        boolean $i$f$sortedByDescending = false;
        List numericalColumnsByVariance = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Column it = (Column)b2;
                boolean bl = false;
                Comparable comparable = Var.Companion.columnVariance(it);
                it = (Column)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Var.Companion.columnVariance(it));
            }
        });
        ColumnId columnId2 = dataFrame.getColumnId((Column)CollectionsKt.first((List)numericalColumnsByVariance));
        if (columnId2 == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId yColumnId = columnId2;
        return CollectionsKt.listOf((Object)new BarSeriesSettings(false, false, CollectionsKt.listOf((Object)new ColumnSettings(xColumnId, ColumnModifier.Group)), null, CollectionsKt.listOf((Object)new ColumnSettings(yColumnId, ColumnModifier.Mean)), false, 43, null));
    }
}

