/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.columns;

import com.intellij.charts.dataframe.columns.ArrayColumn;
import com.intellij.charts.dataframe.columns.ArrayColumnType;
import com.intellij.charts.dataframe.columns.DoubleArrayType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00060\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/charts/dataframe/columns/DoubleArrayColumn;", "Lcom/intellij/charts/dataframe/columns/ArrayColumn;", "", "name", "", "data", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "type", "Lcom/intellij/charts/dataframe/columns/ArrayColumnType;", "getType", "()Lcom/intellij/charts/dataframe/columns/ArrayColumnType;", "getDoubleValue", "rowIndex", "", "columnIndex", "(II)Ljava/lang/Double;", "hasDoubleValue", "", "intellij.charts"})
public final class DoubleArrayColumn
extends ArrayColumn<Double> {
    @NotNull
    private final ArrayColumnType<Double> type;

    public DoubleArrayColumn(@NotNull String name, @NotNull List<List<Double>> data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        super(name, data);
        this.type = DoubleArrayType.INSTANCE;
    }

    @Override
    @NotNull
    public ArrayColumnType<Double> getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Double getDoubleValue(int rowIndex, int columnIndex) {
        List list2 = (List)this.getData().get(rowIndex);
        return list2 != null ? (Double)list2.get(columnIndex) : null;
    }

    @Override
    public boolean hasDoubleValue(int rowIndex, int columnIndex) {
        List list2 = (List)this.getData().get(rowIndex);
        if (list2 == null) {
            return false;
        }
        List column = list2;
        return column.get(columnIndex) != null;
    }
}

