/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.style;

import com.intellij.charts.style.ChartsJBColor;
import com.intellij.charts.style.PaletteDialogKt;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\nJ\u0014\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/charts/style/ColorTableModel;", "Ljavax/swing/table/AbstractTableModel;", "palette", "", "Lcom/intellij/charts/style/ChartsJBColor;", "<init>", "(Ljava/util/List;)V", "getPalette", "()Ljava/util/List;", "getRowCount", "", "getColumnCount", "getValueAt", "", "rowIndex", "columnIndex", "getLight", "getDark", "addRow", "", "color", "removeRow", "index", "setRows", "newPalette", "", "isCellEditable", "", "setValueAt", "aValue", "intellij.charts"})
public final class ColorTableModel
extends AbstractTableModel {
    @NotNull
    private final List<ChartsJBColor> palette;

    public ColorTableModel(@NotNull List<ChartsJBColor> palette) {
        Intrinsics.checkNotNullParameter(palette, (String)"palette");
        this.palette = palette;
    }

    @NotNull
    public final List<ChartsJBColor> getPalette() {
        return this.palette;
    }

    @Override
    public int getRowCount() {
        return this.palette.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    @NotNull
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0, 1 -> this.palette.get(rowIndex).getLight();
            default -> this.palette.get(rowIndex).getDark();
        };
    }

    public final int getLight(int rowIndex) {
        return this.palette.get(rowIndex).getLight();
    }

    public final int getDark(int rowIndex) {
        return this.palette.get(rowIndex).getDark();
    }

    public final void addRow(@NotNull ChartsJBColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.palette.add(color);
        this.fireTableRowsInserted(this.palette.size() - 1, this.palette.size() - 1);
    }

    public final void removeRow(int index) {
        this.palette.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public final void setRows(@NotNull List<ChartsJBColor> newPalette) {
        Intrinsics.checkNotNullParameter(newPalette, (String)"newPalette");
        this.palette.clear();
        this.palette.addAll((Collection<ChartsJBColor>)newPalette);
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(@NotNull Object aValue, int rowIndex, int columnIndex) {
        Integer colorInt;
        Intrinsics.checkNotNullParameter((Object)aValue, (String)"aValue");
        Integer n = colorInt = aValue instanceof Color ? Integer.valueOf(((Color)aValue).getRGB()) : (aValue instanceof String ? PaletteDialogKt.fromHexStringToColorInt((String)aValue) : null);
        if (n == null) {
            return;
        }
        n.intValue();
        switch (columnIndex) {
            case 0: 
            case 1: {
                this.palette.get(rowIndex).setLight(colorInt);
                break;
            }
            default: {
                this.palette.get(rowIndex).setDark(colorInt);
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }
}

