/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.AttributeFontSpec;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.FontSize;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.FontStretch;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.FontStyle;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.FontWeight;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.LengthFontSize;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.NumberFontWeight;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.PredefinedFontSize;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.font.PredefinedFontWeight;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.SeparatorMode;

public final class FontParser {
    private FontParser() {
    }

    @NotNull
    public static AttributeFontSpec parseFontSpec(@NotNull AttributeNode node) {
        String[] fontFamilies = node.getStringList("font-family", SeparatorMode.COMMA_ONLY);
        @Nullable FontWeight weight = FontParser.parseWeight(node);
        @Nullable FontSize size2 = FontParser.parseFontSize(node);
        @Nullable Length sizeAdjust = FontParser.parseSizeAdjust(node);
        @Nullable FontStyle style = FontParser.parseFontStyle(node);
        float stretch = FontParser.parseStretch(node);
        return new AttributeFontSpec(fontFamilies, style, sizeAdjust, stretch, size2, weight);
    }

    @Nullable
    public static FontWeight parseWeight(@NotNull AttributeNode node) {
        String fontWeightKey = "font-weight";
        FontWeight weight = node.getEnum("font-weight", PredefinedFontWeight.Number);
        if (weight == PredefinedFontWeight.Number) {
            weight = node.hasAttribute("font-weight") ? new NumberFontWeight(Math.max(1.0f, Math.min(1000.0f, node.getFloat("font-weight", 400.0f)))) : null;
        }
        return weight;
    }

    public static float parseStretch(@NotNull AttributeNode node) {
        FontStretch stretch = node.getEnum("font-stretch", FontStretch.Percentage);
        return stretch == FontStretch.Percentage ? node.parser().parsePercentage(node.getValue("font-stretch"), Float.NaN, 0.5f, 2.0f) : stretch.percentage();
    }

    @Nullable
    public static FontSize parseFontSize(@NotNull AttributeNode node) {
        FontSize fontSize = node.getEnum("font-size", PredefinedFontSize.Number);
        if (fontSize == PredefinedFontSize.Number) {
            Length size2 = node.getLength("font-size", Length.UNSPECIFIED);
            fontSize = size2.isSpecified() ? new LengthFontSize(size2) : null;
        }
        return fontSize;
    }

    @Nullable
    public static Length parseSizeAdjust(@NotNull AttributeNode node) {
        return node.getLength("font-size-adjust");
    }

    @Nullable
    public static FontStyle parseFontStyle(@NotNull AttributeNode node) {
        FontStyle style = null;
        String styleStr = node.getValue("font-style");
        if ("normal".equalsIgnoreCase(styleStr)) {
            style = FontStyle.normal();
        } else if ("italic".equalsIgnoreCase(styleStr)) {
            style = FontStyle.italic();
        } else if (styleStr != null && styleStr.startsWith("oblique")) {
            String[] comps = styleStr.split(" ", 2);
            style = comps.length == 2 ? new FontStyle.Oblique(node.parser().parseAngle(comps[1], FontStyle.Oblique.DEFAULT_ANGLE)) : FontStyle.oblique();
        }
        return style;
    }
}

