/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path;

import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.mesh.Bezier;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.path.BezierPathCommand;

final class LineToBezier
implements BezierPathCommand {
    private final boolean relative;
    private final float x;
    private final float y;

    public LineToBezier(boolean relative, float x2, float y2) {
        this.relative = relative;
        this.x = x2;
        this.y = y2;
    }

    @Override
    @NotNull
    public Bezier createBezier(@NotNull Point2D.Float start2) {
        if (this.relative) {
            return Bezier.straightLine(start2, new Point2D.Float(start2.x + this.x, start2.y + this.y));
        }
        return Bezier.straightLine(start2, new Point2D.Float(this.x, this.y));
    }
}

