/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes;

import java.awt.Rectangle;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.FillRule;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.AWTSVGShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.FillRuleAwareAWTSVGShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.MeasurableShape;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.ShapeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.HasFillRule;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;

public abstract class AbstractPolyShape
extends ShapeNode
implements HasFillRule {
    private FillRule fillRule;

    @Override
    @NotNull
    public FillRule fillRule() {
        return this.fillRule;
    }

    @Override
    @NotNull
    protected final MeasurableShape buildShape(@NotNull AttributeNode attributeNode) {
        this.fillRule = FillRule.parse(attributeNode);
        float[] points2 = attributeNode.getFloatList("points");
        if (points2.length > 0) {
            Path2D.Float path2 = new Path2D.Float(0, points2.length / 2);
            ((Path2D)path2).moveTo(points2[0], points2[1]);
            for (int i = 2; i < points2.length; i += 2) {
                ((Path2D)path2).lineTo(points2[i], points2[i + 1]);
            }
            if (this.doClose()) {
                path2.closePath();
            }
            return new FillRuleAwareAWTSVGShape(path2);
        }
        return new AWTSVGShape<Rectangle>(new Rectangle());
    }

    protected abstract boolean doClose();
}

