/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.container.ContainerNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.Channel;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.FeMergeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.FilterContext;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.FilterPrimitiveBase;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.Category;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.GraphicsUtil;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.RenderContext;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={FeMergeNode.class})
public final class FeMerge
extends ContainerNode
implements FilterPrimitive {
    public static final String TAG = "feMerge";
    private FilterPrimitiveBase filterPrimitiveBase;
    private FilterChannelKey[] inputChannels;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.filterPrimitiveBase = new FilterPrimitiveBase(attributeNode);
        List<FeMergeNode> nodes = this.childrenOfType(FeMergeNode.class);
        this.inputChannels = new FilterChannelKey[nodes.size()];
        for (int i = 0; i < this.inputChannels.length; ++i) {
            this.inputChannels[i] = nodes.get(i).inputChannel();
        }
    }

    @Override
    public boolean isValid() {
        return this.inputChannels.length > 0;
    }

    @Override
    @NotNull
    public Length x() {
        return this.filterPrimitiveBase.x;
    }

    @Override
    @NotNull
    public Length y() {
        return this.filterPrimitiveBase.y;
    }

    @Override
    @NotNull
    public Length width() {
        return this.filterPrimitiveBase.width;
    }

    @Override
    @NotNull
    public Length height() {
        return this.filterPrimitiveBase.height;
    }

    @Override
    public void layoutFilter(@NotNull RenderContext context, @NotNull FilterLayoutContext filterLayoutContext) {
        if (this.inputChannels.length == 0) {
            this.filterPrimitiveBase.saveLayoutResult(filterLayoutContext.resultChannels().get(DefaultFilterChannel.SourceGraphic), filterLayoutContext);
            return;
        }
        LayoutBounds result2 = filterLayoutContext.resultChannels().get(this.inputChannels[0]);
        for (int i = 1; i < this.inputChannels.length; ++i) {
            LayoutBounds channelBounds = filterLayoutContext.resultChannels().get(this.inputChannels[i]);
            result2 = result2.union(channelBounds);
        }
        this.filterPrimitiveBase.saveLayoutResult(result2, filterLayoutContext);
    }

    @Override
    public void applyFilter(@NotNull RenderContext context, @NotNull FilterContext filterContext) {
        Channel in;
        if (this.inputChannels.length == 0) {
            this.filterPrimitiveBase.saveResult(this.filterPrimitiveBase.channel(DefaultFilterChannel.SourceGraphic, filterContext), filterContext);
            return;
        }
        Channel result2 = in = this.filterPrimitiveBase.channel(this.inputChannels[0], filterContext);
        if (this.inputChannels.length > 1) {
            BufferedImage dst = in.toBufferedImageNonAliased(context);
            Graphics2D imgGraphics = GraphicsUtil.createGraphics(dst);
            for (int i = 1; i < this.inputChannels.length; ++i) {
                Channel channel = this.filterPrimitiveBase.channel(this.inputChannels[i], filterContext);
                imgGraphics.drawImage(context.platformSupport().createImage(channel.producer()), null, context.platformSupport().imageObserver());
            }
            result2 = new ImageProducerChannel(dst.getSource());
        }
        this.filterPrimitiveBase.saveResult(result2, filterContext);
    }
}

