/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.Channel;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.PixelProvider;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.RenderContext;

public final class ImageProducerChannel
implements Channel,
PixelProvider {
    @NotNull
    private final ImageProducer producer;
    private BufferedImage rasterBuffer;
    private WritableRaster raster;

    public ImageProducerChannel(@NotNull ImageProducer producer) {
        this.producer = producer;
    }

    @Override
    @NotNull
    public ImageProducer producer() {
        return this.producer;
    }

    @Override
    @NotNull
    public Channel applyFilter(@NotNull ImageFilter filter2) {
        return new ImageProducerChannel(new FilteredImageSource(this.producer, filter2));
    }

    @Override
    @NotNull
    public Image toImage(@NotNull RenderContext context) {
        return this.rasterBuffer(context);
    }

    @NotNull
    private BufferedImage rasterBuffer(@NotNull RenderContext context) {
        if (this.rasterBuffer == null) {
            this.rasterBuffer = Channel.makeNonAliased(context.platformSupport().createImage(this.producer()));
        }
        return this.rasterBuffer;
    }

    @Override
    @NotNull
    public PixelProvider pixels(@NotNull RenderContext context) {
        if (this.raster == null) {
            this.raster = this.rasterBuffer(context).getRaster();
        }
        return this;
    }

    @Override
    public int pixelAt(double x2, double y2) {
        int[] rgb = this.raster.getPixel((int)x2, (int)y2, (int[])null);
        return rgb[3] << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }
}

