/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.relocated.com.github.weisj.jsvg.geometry.util.GeometryUtil;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.GraphicsUtil;
import org.jetbrains.relocated.com.github.weisj.jsvg.renderer.RenderContext;

public final class ImageUtil {
    private ImageUtil() {
    }

    @NotNull
    public static BufferedImage createCompatibleTransparentImage(@NotNull Graphics2D g, double width2, double height) {
        return ImageUtil.createCompatibleTransparentImage(g.getTransform(), width2, height);
    }

    @NotNull
    public static BufferedImage createCompatibleTransparentImage(int width2, int height) {
        return new BufferedImage(width2, height, 3);
    }

    @NotNull
    public static BufferedImage createCompatibleTransparentImage(@Nullable AffineTransform at, double width2, double height) {
        return new BufferedImage((int)Math.ceil(GeometryUtil.scaleXOfTransform(at) * width2), (int)Math.ceil(GeometryUtil.scaleYOfTransform(at) * height), 3);
    }

    @NotNull
    public static BufferedImage createLuminosityBuffer(@Nullable AffineTransform at, double width2, double height) {
        return new BufferedImage((int)Math.ceil(GeometryUtil.scaleXOfTransform(at) * width2), (int)Math.ceil(GeometryUtil.scaleYOfTransform(at) * height), 10);
    }

    public static int[] getINT_RGBA_DataBank(@NotNull Raster raster2) {
        DataBufferInt dstDB = (DataBufferInt)raster2.getDataBuffer();
        return dstDB.getBankData()[0];
    }

    public static int getINT_RGBA_DataOffset(@NotNull Raster raster2) {
        DataBufferInt dstDB = (DataBufferInt)raster2.getDataBuffer();
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)raster2.getSampleModel();
        return dstDB.getOffset() + sppsm.getOffset(raster2.getMinX() - raster2.getSampleModelTranslateX(), raster2.getMinY() - raster2.getSampleModelTranslateY());
    }

    public static int getINT_RGBA_DataAdjust(@NotNull Raster raster2) {
        return ImageUtil.getINT_RGBA_ScanlineStride(raster2) - raster2.getWidth();
    }

    public static int getINT_RGBA_ScanlineStride(@NotNull Raster raster2) {
        return ((SinglePixelPackedSampleModel)raster2.getSampleModel()).getScanlineStride();
    }

    @NotNull
    public static BufferedImage copy(@NotNull RenderContext context, @NotNull ImageProducer producer) {
        Image img = context.platformSupport().createImage(producer);
        BufferedImage bufferedImage = ImageUtil.createCompatibleTransparentImage((AffineTransform)null, (double)img.getWidth(null), (double)img.getHeight(null));
        Graphics2D g = GraphicsUtil.createGraphics(bufferedImage);
        g.drawImage(img, null, null);
        g.dispose();
        return bufferedImage;
    }
}

