/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.relocated.com.github.weisj.jsvg.SVGDocument;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.SVGLoader;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.resources.ImageResource;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.resources.RenderableResource;
import org.jetbrains.relocated.com.github.weisj.jsvg.parser.resources.SVGResource;
import org.jetbrains.relocated.com.github.weisj.jsvg.util.DataUri;

public final class ResourceUtil {
    private static final Logger LOGGER = Logger.getLogger(ResourceUtil.class.getName());
    private static final Set<String> SUPPORTED_MIME_TYPES = Arrays.stream(ImageIO.getReaderFormatNames()).map(s -> "image/" + s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());

    private ResourceUtil() {
    }

    @Nullable
    public static RenderableResource loadImage(@NotNull URI uri) throws IOException {
        BufferedImage img;
        String path2 = uri.getPath();
        if (path2 != null && path2.endsWith(".svg")) {
            SVGLoader loader = new SVGLoader();
            try {
                SVGDocument document = loader.load(uri.toURL());
                if (document != null) {
                    return new SVGResource(document);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not load svg resource", e);
            }
        }
        if ((img = ResourceUtil.loadToBufferedImage(uri)) == null) {
            return null;
        }
        return new ImageResource(img);
    }

    @Nullable
    private static BufferedImage loadToBufferedImage(@NotNull URI uri) throws IOException {
        String scheme = uri.getScheme();
        if ("data".equals(scheme)) {
            DataUri dataUri = DataUri.parse(uri.toString(), StandardCharsets.UTF_8);
            if (!ResourceUtil.isSupportedMimeType(dataUri.mime())) {
                throw new IOException("Unsupported Mime type " + dataUri.mime());
            }
            try (ByteArrayInputStream in = new ByteArrayInputStream(dataUri.data());){
                BufferedImage bufferedImage = ResourceUtil.readPossiblyCorruptedFile(in);
                return bufferedImage;
            }
        }
        return ImageIO.read(uri.toURL());
    }

    private static boolean isSupportedMimeType(@NotNull String mimeType) {
        return SUPPORTED_MIME_TYPES.contains(mimeType.toLowerCase(Locale.ENGLISH));
    }

    @Nullable
    private static BufferedImage readPossiblyCorruptedFile(@NotNull InputStream inputStream) throws IOException {
        ImageInputStream input = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        reader.setInput(input);
        ImageReadParam param = reader.getDefaultReadParam();
        BufferedImage image = reader.getImageTypes(0).next().createBufferedImage(reader.getWidth(0), reader.getHeight(0));
        param.setDestination(image);
        try {
            image = reader.read(0, param);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return image;
    }
}

