/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerBase;
import com.jetbrains.rd.ide.editor.EditorVersionHolder;
import com.jetbrains.rd.ide.editor.EditorVersions;
import com.jetbrains.rd.ide.editor.EditorVersionsKt;
import com.jetbrains.rd.ide.editor.PatchEngineEditorSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.ChangeReason;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.string.IPrintableKt;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0002abBA\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020*H\u0016J\b\u0010.\u001a\u00020*H\u0016J\u0010\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00103\u001a\u00020*2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020*2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020\"H\u0002J\u0010\u00109\u001a\u00020*2\u0006\u00108\u001a\u00020\"H\u0002J\n\u0010:\u001a\u0004\u0018\u00010\u001bH\u0004J\b\u0010;\u001a\u00020\u001bH\u0014J\u0010\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020>H\u0014J\u0006\u0010?\u001a\u00020*J\u0010\u0010@\u001a\u00020*2\b\b\u0002\u0010A\u001a\u00020\"J\u0018\u0010B\u001a\u00020*2\u0006\u0010C\u001a\u00020D2\u0006\u0010A\u001a\u00020\"H\u0002J\u0018\u0010B\u001a\u00020*2\u0006\u0010E\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020*2\u0006\u0010G\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020*2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020*2\u0006\u0010E\u001a\u00020\u001bH\u0002J\u0010\u0010S\u001a\u00020*2\u0006\u0010T\u001a\u00020UH\u0016J0\u0010V\u001a\u00020*2\u0006\u0010G\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020P2\u0006\u0010[\u001a\u00020P2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\\\u001a\u00020*H\u0002J\u0016\u0010]\u001a\u00020*2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020\"R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\u00020P8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010R\u00a8\u0006c"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;Lcom/jetbrains/rd/ide/requests/PatchEngine;)V", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "getDocumentSynchronizer", "()Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "versionHolder", "Lcom/jetbrains/rd/ide/editor/EditorVersionHolder;", "idNumberCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "oldState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "postponedState", "documentVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "getDocumentVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "isInsideAllCaretsAction", "", "()Z", "allCaretsActionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "documentChangesLifetimes", "createNextId", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "caretAdded", "", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "beforeAllCaretsAction", "afterAllCaretsAction", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "bulkUpdateStarting", "document", "Lcom/intellij/openapi/editor/Document;", "bulkUpdateFinished", "beforeDocumentChangeOrBulkEvent", "documentChange", "afterDocumentChangeOrBulkFinished", "createModelCaretStateIfNotInBulkMode", "createModelCaretState", "sendCaretStateChange", "reason", "", "sendInitialCaretState", "sendCaretStateSnapshot", "force", "sendCaretState", "mode", "Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$SendingMode;", "newState", "receiveSelection", "change", "Lcom/jetbrains/rd/ide/model/RdCaretModelChange;", "receiveCaretStateChange", "Lcom/jetbrains/rd/ide/model/RdCaretStateChange;", "receiveCaretStateSnapshot", "snapshot", "Lcom/jetbrains/rd/ide/model/RdCaretStateSnapshotBase;", "receiveCaretState", "version", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/RdAbstractEditorVersion;", "sendChange", "Lcom/jetbrains/rd/ide/model/RdEditorChange;", "changeReason", "Lcom/jetbrains/rd/ide/model/ChangeReason;", "oldVersion", "newVersion", "scrollToCaretIfInitial", "softUpdate", "item", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "redo", "Companion", "SendingMode", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchEngineEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineEditorSynchronizer.kt\ncom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 4 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,363:1\n67#2,4:364\n67#2,4:368\n67#2,4:372\n67#2,4:379\n67#2,4:402\n11#3,3:376\n16#3,7:383\n11#3,12:390\n45#4,8:406\n*S KotlinDebug\n*F\n+ 1 PatchEngineEditorSynchronizer.kt\ncom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer\n*L\n72#1:364,4\n225#1:368,4\n249#1:372,4\n266#1:379,4\n286#1:402,4\n263#1:376,3\n263#1:383,7\n273#1:390,12\n308#1:406,8\n*E\n"})
public class PatchEngineEditorSynchronizer
extends EditorSynchronizerBase
implements DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PatchEngine engine;
    @NotNull
    private final PatchEngineDocumentSynchronizer documentSynchronizer;
    @NotNull
    private final EditorVersionHolder versionHolder;
    @NotNull
    private final AtomicLong idNumberCounter;
    @NotNull
    private RdCaretState oldState;
    @Nullable
    private RdCaretState postponedState;
    @NotNull
    private final SequentialLifetimes allCaretsActionLifetimes;
    @NotNull
    private final SequentialLifetimes documentChangesLifetimes;

    protected PatchEngineEditorSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull ClientAppSession session, @NotNull Editor editor, @NotNull TextControlId editorId, @NotNull TextControlModel editorModel, @NotNull DocumentSynchronizer documentSynchronizer, @NotNull PatchEngine engine) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        super(session, textControlLifetime, editorId, editorModel, editor);
        this.engine = engine;
        this.documentSynchronizer = (PatchEngineDocumentSynchronizer)documentSynchronizer;
        this.versionHolder = new EditorVersionHolder(EditorVersionsKt.getInitialEditorVersion());
        this.idNumberCounter = new AtomicLong();
        this.allCaretsActionLifetimes = new SequentialLifetimes(textControlLifetime);
        this.documentChangesLifetimes = new SequentialLifetimes(textControlLifetime);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            Intrinsics.checkNotNull((Object)caret);
            UtilKt.setId(caret, this.createNextId());
        }
        this.oldState = this.createModelCaretState();
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Initial caret state=" + UtilKt.toDebugString(this.oldState));
        }
    }

    @NotNull
    public final PatchEngineDocumentSynchronizer getDocumentSynchronizer() {
        return this.documentSynchronizer;
    }

    private final RdDocumentVersion getDocumentVersion() {
        return this.documentSynchronizer.getVersion();
    }

    private final boolean isInsideAllCaretsAction() {
        return !this.allCaretsActionLifetimes.isTerminated();
    }

    private final RdCaretId createNextId() {
        long number = this.idNumberCounter.incrementAndGet();
        return new RdCaretId(true, number);
    }

    @Override
    public void caretAdded(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Caret caret = e.getCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCaret(...)");
        Caret caret2 = caret;
        if (UtilKt.getId(caret2) == null) {
            UtilKt.setId(caret2, this.createNextId());
        }
        super.caretAdded(e);
    }

    public void beforeAllCaretsAction() {
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        this.allCaretsActionLifetimes.next().bracketIfAliveEx(() -> PatchEngineEditorSynchronizer.beforeAllCaretsAction$lambda$0(this), arg_0 -> PatchEngineEditorSynchronizer.beforeAllCaretsAction$lambda$1(this, arg_0));
    }

    public void afterAllCaretsAction() {
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        this.allCaretsActionLifetimes.terminateCurrent();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.beforeDocumentChangeOrBulkEvent(true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.afterDocumentChangeOrBulkFinished(true);
    }

    public void bulkUpdateStarting(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.beforeDocumentChangeOrBulkEvent(false);
    }

    public void bulkUpdateFinished(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.afterDocumentChangeOrBulkFinished(false);
    }

    private final void beforeDocumentChangeOrBulkEvent(boolean documentChange) {
        if (this.documentSynchronizer.isReceivingChange()) {
            return;
        }
        if (documentChange && this.getEditor().getDocument().isInBulkUpdate()) {
            return;
        }
        this.documentChangesLifetimes.next().bracketIfAliveEx(() -> PatchEngineEditorSynchronizer.beforeDocumentChangeOrBulkEvent$lambda$0(this), arg_0 -> PatchEngineEditorSynchronizer.beforeDocumentChangeOrBulkEvent$lambda$1(this, arg_0));
        this.sendCaretState(SendingMode.DOCUMENT_WRAP_SNAPSHOT, true);
    }

    private final void afterDocumentChangeOrBulkFinished(boolean documentChange) {
        if (documentChange && this.getEditor().getDocument().isInBulkUpdate()) {
            return;
        }
        this.documentChangesLifetimes.terminateCurrent();
    }

    @Nullable
    protected final RdCaretState createModelCaretStateIfNotInBulkMode() {
        if (this.getEditor().getDocument().isInBulkUpdate()) {
            return null;
        }
        return this.createModelCaretState();
    }

    @NotNull
    protected RdCaretState createModelCaretState() {
        if (this.getEditor().getDocument().isInBulkUpdate()) {
            this.getLogger().error("This operation can lead to an exception in bulk mode");
        }
        CaretModel caretModel = this.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        return UtilKt.createModelCaretState(caretModel, this.documentSynchronizer.getVersion());
    }

    @Override
    protected void sendCaretStateChange(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.sendCaretState(SendingMode.CHANGE, false);
    }

    public final void sendInitialCaretState() {
        RdCaretStateSnapshot snapshot = new RdCaretStateSnapshot(false, this.oldState, this.getTextControlId());
        EditorVersions editorVersions = this.versionHolder.incrementVersion(this.oldState);
        RdEditorVersion oldVersion = editorVersions.component1();
        RdEditorVersion newVersion = editorVersions.component2();
        this.sendChange((RdEditorChange)snapshot, ChangeReason.INIT, oldVersion, newVersion, this.getDocumentVersion());
    }

    public final void sendCaretStateSnapshot(boolean force) {
        this.sendCaretState(SendingMode.SNAPSHOT, force);
    }

    public static /* synthetic */ void sendCaretStateSnapshot$default(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendCaretStateSnapshot");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        patchEngineEditorSynchronizer.sendCaretStateSnapshot(bl);
    }

    private final void sendCaretState(SendingMode mode, boolean force) {
        if (this.getDontSendChange()) {
            return;
        }
        if (this.isInsideAllCaretsAction()) {
            if (this.postponedState != null && !this.documentSynchronizer.isReceivingChange()) {
                RdCaretState rdCaretState = this.postponedState;
                Intrinsics.checkNotNull((Object)rdCaretState);
                this.sendCaretState(rdCaretState, mode);
                this.postponedState = null;
            }
            return;
        }
        RdCaretState newState = this.createModelCaretStateIfNotInBulkMode();
        if (newState == null) {
            this.getLogger().error("Must not be called in bulk mode");
            return;
        }
        if (this.documentSynchronizer.isReceivingChange()) {
            RdCaretState oldOldState = this.oldState;
            this.oldState = newState;
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("sendCaretState(isReceivingChange=true): oldState " + UtilKt.toDebugString(oldOldState) + " updated to " + UtilKt.toDebugString(this.oldState));
            }
            return;
        }
        if (Intrinsics.areEqual((Object)newState, (Object)this.oldState) && !force) {
            return;
        }
        this.sendCaretState(newState, mode);
    }

    private final void sendCaretState(RdCaretState newState, SendingMode mode) {
        RdSelectionChangeBase change = switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> {
                if (!Intrinsics.areEqual((Object)this.oldState.getDocumentVersion(), (Object)newState.getDocumentVersion())) {
                    yield (RdSelectionChangeBase)new RdCaretStateSnapshot(true, newState, this.getTextControlId());
                }
                yield (RdSelectionChangeBase)new RdCaretStateChange(this.oldState, newState, this.getTextControlId());
            }
            case 2 -> (RdSelectionChangeBase)new RdCaretStateSnapshot(false, newState, this.getTextControlId());
            case 3 -> (RdSelectionChangeBase)new RdCaretStateSnapshot(true, newState, this.getTextControlId());
            default -> throw new NoWhenBranchMatchedException();
        };
        RdCaretState oldOldState = this.oldState;
        this.oldState = newState;
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("sendCaretState: oldState " + UtilKt.toDebugString(oldOldState) + " updated to " + UtilKt.toDebugString(this.oldState));
        }
        EditorVersions editorVersions = this.versionHolder.incrementVersion(newState);
        RdEditorVersion oldVersion = editorVersions.component1();
        RdEditorVersion newVersion = editorVersions.component2();
        this.sendChange((RdEditorChange)change, ChangeReason.CARET_CHANGE, oldVersion, newVersion, this.getDocumentVersion());
    }

    @Override
    public void receiveSelection(@NotNull RdCaretModelChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RdCaretModelChange rdCaretModelChange = change;
        if (rdCaretModelChange instanceof RdCaretStateChange) {
            this.receiveCaretStateChange((RdCaretStateChange)change);
        } else if (rdCaretModelChange instanceof RdCaretStateSnapshotBase) {
            this.receiveCaretStateSnapshot((RdCaretStateSnapshotBase)change);
        } else {
            throw new IllegalStateException(("Unexpected change type: " + Reflection.getOrCreateKotlinClass(change.getClass()).getSimpleName()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void receiveCaretStateChange(RdCaretStateChange change) {
        void $this$usingTrueFlag_u24default$iv;
        PatchEngineEditorSynchronizer patchEngineEditorSynchronizer = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)receiveCaretStateChange.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.oldState, (Object)change.getOldState())) {
                Logger $this$trace$iv = this.getLogger();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("expected old state: " + UtilKt.toDebugString(change.getOldState()) + ", actual: " + UtilKt.toDebugString(this.oldState));
                }
            }
            this.receiveCaretState(change.getNewState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void receiveCaretStateSnapshot(RdCaretStateSnapshotBase snapshot) {
        void $this$usingTrueFlag_u24default$iv;
        PatchEngineEditorSynchronizer patchEngineEditorSynchronizer = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)receiveCaretStateSnapshot.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            this.receiveCaretState(snapshot.getState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    private final void receiveCaretState(RdCaretState newState) {
        UtilKt.applyStateTo(newState, this.getEditor());
        this.scrollToCaretIfInitial();
        this.versionHolder.incrementVersion(newState);
        if (!Intrinsics.areEqual((Object)this.documentSynchronizer.getVersion(), (Object)newState.getDocumentVersion())) {
            this.getLogger().error("Received newState based on document version: " + IPrintableKt.printToString((Object)newState.getDocumentVersion()) + ", but actual document version is " + IPrintableKt.printToString((Object)this.documentSynchronizer.getVersion()) + ". NewState: " + IPrintableKt.printToString((Object)newState));
        }
        this.oldState = this.createModelCaretState();
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("receiveCaretState: oldState updated to " + UtilKt.toDebugString(this.oldState));
        }
        long appliedStateHash = EditorVersionsKt.computeHash(this.oldState);
        long receivedHash = EditorVersionsKt.computeHash(newState);
        if (appliedStateHash != receivedHash) {
            this.getLogger().error("current state hash: " + appliedStateHash + ", doesn't match to received state hash: " + receivedHash + ". current: " + IPrintableKt.printToString((Object)this.oldState) + ", received: " + IPrintableKt.printToString((Object)newState));
        }
    }

    @NotNull
    public RdEditorVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull RdAbstractEditorVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdEditorVersion cfr_ignored_0 = (RdEditorVersion)v;
        this.versionHolder.reset((RdEditorVersion)v);
    }

    private final void sendChange(RdEditorChange change, ChangeReason changeReason, RdEditorVersion oldVersion, RdEditorVersion newVersion, RdDocumentVersion documentVersion) {
        ClientId.Companion.withExplicitClientId(new ClientId(change.getEditorId().getClientId()), () -> PatchEngineEditorSynchronizer.sendChange$lambda$0(this, changeReason, oldVersion, change, newVersion, documentVersion));
    }

    private final void scrollToCaretIfInitial() {
        if (this.versionHolder.getVersion() == EditorVersionsKt.getInitialEditorVersion()) {
            Editor editor = this.getEditor();
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            EditorUtil.runWhenViewportReady((EditorEx)((EditorEx)editor), () -> PatchEngineEditorSynchronizer.scrollToCaretIfInitial$lambda$0(this));
        }
    }

    public final void softUpdate(@NotNull RdSelectionChangeBase item, boolean redo) {
        RdSelectionChangeBase rdSelectionChangeBase;
        RdSelectionChangeBase rdSelectionChangeBase2;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!redo) {
            RdCaretState state = UtilKt.getActualState(item);
            if (!Intrinsics.areEqual((Object)this.documentSynchronizer.getVersion(), (Object)state.getDocumentVersion())) {
                this.getLogger().error("Received newState based on document version: " + IPrintableKt.printToString((Object)state.getDocumentVersion()) + ", but actual document version is " + IPrintableKt.printToString((Object)this.documentSynchronizer.getVersion()) + ". NewState: " + IPrintableKt.printToString((Object)state));
            }
        }
        if ((rdSelectionChangeBase2 = item) instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdCaretStateSnapshot(((RdCaretStateSnapshot)item).getDocumentChangeWrapping(), RdCaretState.copy$default((RdCaretState)((RdCaretStateSnapshot)item).getState(), null, null, (RdDocumentVersion)this.getDocumentVersion(), (int)3, null), item.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdCaretStateChange) {
            rdSelectionChangeBase = (RdSelectionChangeBase)new RdCaretStateChange(RdCaretState.copy$default((RdCaretState)((RdCaretStateChange)item).getOldState(), null, null, (RdDocumentVersion)this.getDocumentVersion(), (int)3, null), RdCaretState.copy$default((RdCaretState)((RdCaretStateChange)item).getNewState(), null, null, (RdDocumentVersion)this.getDocumentVersion(), (int)3, null), item.getEditorId());
        } else {
            throw new IllegalStateException(("Unexpected change type: " + item).toString());
        }
        RdSelectionChangeBase change = rdSelectionChangeBase;
        RdCaretState state = UtilKt.getActualState(change);
        EditorVersions editorVersions = this.versionHolder.incrementVersion(state);
        RdEditorVersion oldVersion = editorVersions.component1();
        RdEditorVersion newVersion = editorVersions.component2();
        this.oldState = state;
        if (redo) {
            this.sendChange((RdEditorChange)change, ChangeReason.CARET_CHANGE, oldVersion, newVersion, this.getDocumentVersion());
        }
    }

    private static final Unit beforeAllCaretsAction$lambda$0(PatchEngineEditorSynchronizer this$0) {
        this$0.postponedState = this$0.createModelCaretState();
        return Unit.INSTANCE;
    }

    private static final Unit beforeAllCaretsAction$lambda$1(PatchEngineEditorSynchronizer this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.postponedState == null) {
            this$0.sendCaretStateSnapshot(true);
        }
        this$0.postponedState = null;
        return Unit.INSTANCE;
    }

    private static final RdPatchEngine.ChangeAccumulatingSessionToken beforeDocumentChangeOrBulkEvent$lambda$0(PatchEngineEditorSynchronizer this$0) {
        return PatchEngine.openAccumulatingSession$default(this$0.engine, true, "PatchEngineEditorSynchronizer::documentChange", null, null, null, 28, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit beforeDocumentChangeOrBulkEvent$lambda$1(PatchEngineEditorSynchronizer this$0, RdPatchEngine.ChangeAccumulatingSessionToken it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        AutoCloseable autoCloseable = (AutoCloseable)((Object)it);
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken it2 = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl = false;
            this$0.sendCaretState(SendingMode.DOCUMENT_WRAP_SNAPSHOT, true);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit sendChange$lambda$0(PatchEngineEditorSynchronizer this$0, ChangeReason $changeReason, RdEditorVersion $oldVersion, RdEditorChange $change, RdEditorVersion $newVersion, RdDocumentVersion $documentVersion) {
        void description$iv;
        void $this$sendAccumulated_u24default$iv;
        PatchEngine patchEngine = this$0.engine;
        String string = "PatchEngineEditorSynchronizer.sendChange";
        ChangeReason changeReason$iv = $changeReason;
        Class changeProducer$iv = null;
        boolean $i$f$sendAccumulated = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated_u24default$iv, true, (String)description$iv, changeReason$iv, changeProducer$iv, null, 16, null));
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl = false;
            ChangeScope $this$sendChange_u24lambda_u240_u240 = it$iv.getSession().getChangeScope();
            boolean bl2 = false;
            RdPatchEditorVersion oldRdVersion = new RdPatchEditorVersion($oldVersion, (RdPatchItemId)$change.getEditorId());
            RdPatchEditorVersion newRdVersion = new RdPatchEditorVersion($newVersion, (RdPatchItemId)$change.getEditorId());
            $this$sendChange_u24lambda_u240_u240.pushExpected((RdPatchItemVersion)oldRdVersion);
            if (RdPatchUtilsKt.updatingChange((RdPatchItem)$change, $oldVersion, $newVersion)) {
                $this$sendChange_u24lambda_u240_u240.pushUpdated((RdPatchItemVersion)newRdVersion);
            }
            $this$sendChange_u24lambda_u240_u240.pushExpected((RdPatchItemVersion)new RdPatchDocumentVersion($documentVersion, this$0.documentSynchronizer.getUniqueIdOrBlank(), (RdPatchItemId)$change.getEditorId().getDocumentId()));
            $this$sendChange_u24lambda_u240_u240.pushChange((RdPatchItem)$change);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void scrollToCaretIfInitial$lambda$0(PatchEngineEditorSynchronizer this$0) {
        ScrollingModelEx $this$scrollToCaretIfInitial_u24lambda_u240_u240 = ((EditorEx)this$0.getEditor()).getScrollingModel();
        boolean bl = false;
        $this$scrollToCaretIfInitial_u24lambda_u240_u240.disableAnimation();
        try {
            $this$scrollToCaretIfInitial_u24lambda_u240_u240.scrollToCaret(ScrollType.RELATIVE);
        }
        finally {
            $this$scrollToCaretIfInitial_u24lambda_u240_u240.enableAnimation();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PatchEngineEditorSynchronizer create(@NotNull ClientAppSession session, @NotNull Lifetime textControlLifetime, @NotNull TextControlId editorId, @NotNull TextControlModel editorModel, @NotNull Editor editor, @NotNull DocumentSynchronizer documentSynchronizer, @NotNull RdPatchEngine engine) {
            PatchEngineEditorSynchronizer patchEngineEditorSynchronizer;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
            Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            PatchEngineEditorSynchronizer $this$create_u24lambda_u240 = patchEngineEditorSynchronizer = new PatchEngineEditorSynchronizer(textControlLifetime, session, editor, editorId, editorModel, documentSynchronizer, engine);
            boolean bl = false;
            $this$create_u24lambda_u240.init();
            return patchEngineEditorSynchronizer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$SendingMode;", "", "<init>", "(Ljava/lang/String;I)V", "SNAPSHOT", "DOCUMENT_WRAP_SNAPSHOT", "CHANGE", "intellij.rd.platform"})
    private static final class SendingMode
    extends Enum<SendingMode> {
        public static final /* enum */ SendingMode SNAPSHOT = new SendingMode();
        public static final /* enum */ SendingMode DOCUMENT_WRAP_SNAPSHOT = new SendingMode();
        public static final /* enum */ SendingMode CHANGE = new SendingMode();
        private static final /* synthetic */ SendingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SendingMode[] values() {
            return (SendingMode[])$VALUES.clone();
        }

        public static SendingMode valueOf(String value) {
            return Enum.valueOf(SendingMode.class, value);
        }

        @NotNull
        public static EnumEntries<SendingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sendingModeArray = new SendingMode[]{SendingMode.SNAPSHOT, SendingMode.DOCUMENT_WRAP_SNAPSHOT, SendingMode.CHANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SendingMode.values().length];
            try {
                nArray[SendingMode.CHANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SendingMode.SNAPSHOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SendingMode.DOCUMENT_WRAP_SNAPSHOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

