/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.logs;

import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectDescription;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.platform.ml.logs.ConvertObjectList;
import com.intellij.platform.ml.logs.ConverterOfBoolean;
import com.intellij.platform.ml.logs.ConverterOfClass;
import com.intellij.platform.ml.logs.ConverterOfDouble;
import com.intellij.platform.ml.logs.ConverterOfEnum;
import com.intellij.platform.ml.logs.ConverterOfFloat;
import com.intellij.platform.ml.logs.ConverterOfFloatList;
import com.intellij.platform.ml.logs.ConverterOfInt32;
import com.intellij.platform.ml.logs.ConverterOfInt64;
import com.intellij.platform.ml.logs.ConverterOfIntList;
import com.intellij.platform.ml.logs.ConverterOfLongList;
import com.intellij.platform.ml.logs.ConverterOfObject;
import com.intellij.platform.ml.logs.ConverterOfString;
import com.intellij.platform.ml.logs.IJEventPairConverter;
import com.jetbrains.mlapi.feature.ClassFeatureDeclaration;
import com.jetbrains.mlapi.feature.EnumFeatureDeclaration;
import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.NullableFeatureDeclaration;
import com.jetbrains.mlapi.feature.PrimitiveFeatureDeclaration;
import com.jetbrains.mlapi.feature.PrimitiveType;
import com.jetbrains.mlapi.logs.ObjectArrayDeclaration;
import com.jetbrains.mlapi.logs.ObjectDeclaration;
import com.jetbrains.mlapi.logs.ObjectFeatureDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/ml/logs/ConverterObjectDescription;", "Lcom/intellij/internal/statistic/eventLog/events/ObjectDescription;", "signatures", "", "Lcom/jetbrains/mlapi/feature/FeatureSignature;", "<init>", "(Ljava/util/List;)V", "toIJConverters", "", "Lcom/intellij/platform/ml/logs/IJEventPairConverter;", "createConverter", "signature", "buildEventPairs", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "features", "Lcom/jetbrains/mlapi/feature/Feature;", "buildObjectEventData", "Lcom/intellij/internal/statistic/eventLog/events/ObjectEventData;", "intellij.platform.ml.logs"})
@SourceDebugExtension(value={"SMAP\nIJEventPairConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IJEventPairConverter.kt\ncom/intellij/platform/ml/logs/ConverterObjectDescription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1300#2,2:202\n1315#2,2:204\n1318#2:207\n1586#2:208\n1661#2,2:209\n1586#2:211\n1661#2,3:212\n1663#2:215\n1#3:206\n*S KotlinDebug\n*F\n+ 1 IJEventPairConverter.kt\ncom/intellij/platform/ml/logs/ConverterObjectDescription\n*L\n27#1:202,2\n27#1:204,2\n27#1:207\n64#1:208\n64#1:209,2\n68#1:211\n68#1:212,3\n64#1:215\n*E\n"})
public final class ConverterObjectDescription
extends ObjectDescription {
    @NotNull
    private final Map<FeatureSignature, IJEventPairConverter<?, ?>> toIJConverters;

    /*
     * WARNING - void declaration
     */
    public ConverterObjectDescription(@NotNull List<? extends FeatureSignature> signatures) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
        Iterable iterable = signatures;
        ConverterObjectDescription converterObjectDescription = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var5_6 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void signature;
            FeatureSignature featureSignature = (FeatureSignature)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            IJEventPairConverter<?, ?> converter = this.createConverter((FeatureSignature)signature);
            if (converter == null) {
                boolean bl2 = false;
                String string = "Please implement converter for " + (FeatureSignature)signature + " from ML to IJ event fields";
                throw new IllegalStateException(string.toString());
            }
            this.field(converter.getIjEventField());
            IJEventPairConverter<?, ?> iJEventPairConverter = converter;
            map.put(t, iJEventPairConverter);
        }
        converterObjectDescription.toIJConverters = destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IJEventPairConverter<?, ?> createConverter(FeatureSignature signature) {
        IJEventPairConverter iJEventPairConverter;
        FeatureSignature featureSignature = signature;
        if (featureSignature instanceof ObjectFeatureDeclaration) {
            iJEventPairConverter = new ConverterOfObject((ObjectDeclaration)signature);
            return iJEventPairConverter;
        }
        if (featureSignature instanceof ObjectArrayDeclaration) {
            iJEventPairConverter = new ConvertObjectList((ObjectArrayDeclaration)signature);
            return iJEventPairConverter;
        }
        if (featureSignature instanceof PrimitiveFeatureDeclaration) {
            PrimitiveType primitiveType = ((PrimitiveFeatureDeclaration)signature).getType();
            if (primitiveType instanceof PrimitiveType.Boolean) {
                iJEventPairConverter = new ConverterOfBoolean((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.Int32) {
                iJEventPairConverter = new ConverterOfInt32((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.Int64) {
                iJEventPairConverter = new ConverterOfInt64((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.Float) {
                iJEventPairConverter = new ConverterOfFloat((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.Double) {
                iJEventPairConverter = new ConverterOfDouble((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.String) {
                iJEventPairConverter = new ConverterOfString((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.EmbeddingInt32) {
                iJEventPairConverter = new ConverterOfIntList((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.EmbeddingInt64) {
                iJEventPairConverter = new ConverterOfLongList((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.EmbeddingFloat) {
                iJEventPairConverter = new ConverterOfFloatList((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (primitiveType instanceof PrimitiveType.EmbeddingDouble) {
                iJEventPairConverter = new ConverterOfFloatList((PrimitiveFeatureDeclaration)signature);
                return iJEventPairConverter;
            }
            if (!(primitiveType instanceof PrimitiveType.Null)) throw new NoWhenBranchMatchedException();
            return null;
        }
        if (featureSignature instanceof ClassFeatureDeclaration) {
            iJEventPairConverter = new ConverterOfClass((ClassFeatureDeclaration)signature);
            return iJEventPairConverter;
        }
        if (featureSignature instanceof EnumFeatureDeclaration) {
            iJEventPairConverter = new ConverterOfEnum((EnumFeatureDeclaration)signature);
            return iJEventPairConverter;
        }
        if (!(featureSignature instanceof NullableFeatureDeclaration)) throw new NotImplementedError("Please implement converter for " + signature + " from ML to IJ event fields");
        iJEventPairConverter = this.createConverter((FeatureSignature)((NullableFeatureDeclaration)signature).getAsNonNullable());
        return iJEventPairConverter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EventPair<?>> buildEventPairs(@NotNull List<? extends Feature> features) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Iterable $this$map$iv = features;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IJEventPairConverter<?, ?> converter;
            void feature;
            Feature feature2 = (Feature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!this.toIJConverters.containsKey(feature.getSignature())) {
                Collection<String> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                boolean bl2 = false;
                Iterable iterable2 = this.toIJConverters.keySet();
                String string = feature.getSignature().getName();
                FeatureSignature featureSignature = feature.getSignature();
                boolean $i$f$map2 = false;
                void var16_20 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    FeatureSignature featureSignature2 = (FeatureSignature)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(it.getName());
                }
                collection2 = (List)destination$iv$iv2;
                String string2 = StringsKt.trimIndent((String)("\n          Field " + featureSignature + " (name: " + string + ") was not found among\n          the registered ones: " + (List)collection2 + "\n        "));
                throw new IllegalArgumentException(string2.toString());
            }
            if (this.toIJConverters.get(feature.getSignature()) == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            collection.add(IJEventPairConverter.Companion.typedBuild(converter, (Feature)feature));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ObjectEventData buildObjectEventData(@NotNull List<? extends Feature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        return new ObjectEventData(this.buildEventPairs(features));
    }
}

