/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config;

import com.intellij.javaee.web.WebUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.config.SpringBootStaticWebFileReferenceHelperKt;
import com.intellij.uast.UastMetaLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/boot/mvc/config/SpringBootStaticWebFileReferenceHelper;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper;", "<init>", "()V", "getContexts", "", "Lcom/intellij/psi/PsiFileSystemItem;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoots", "module", "Lcom/intellij/openapi/module/Module;", "isMine", "", "getStaticLocationRoots", "", "intellij.spring.boot.mvc"})
@SourceDebugExtension(value={"SMAP\nSpringBootStaticWebFileReferenceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootStaticWebFileReferenceHelper.kt\ncom/intellij/spring/boot/mvc/config/SpringBootStaticWebFileReferenceHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1642#2,10:156\n1915#2:166\n1916#2:168\n1652#2:169\n1#3:167\n*S KotlinDebug\n*F\n+ 1 SpringBootStaticWebFileReferenceHelper.kt\ncom/intellij/spring/boot/mvc/config/SpringBootStaticWebFileReferenceHelper\n*L\n93#1:156,10\n93#1:166\n93#1:168\n93#1:169\n93#1:167\n*E\n"})
public final class SpringBootStaticWebFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        return this.getStaticLocationRoots(module2);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getStaticLocationRoots(module);
    }

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return false;
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return false;
        }
        if (WebUtil.isInsideWebRoots((VirtualFile)file, (Project)project)) {
            return true;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        UastMetaLanguage uastMetaLanguage = (UastMetaLanguage)Language.findInstance(UastMetaLanguage.class);
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (uastMetaLanguage.matchesLanguage(language)) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiFileSystemItem> getStaticLocationRoots(Module module) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = SpringBootStaticWebFileReferenceHelperKt.access$getLocationsFromConfig(module);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiFileSystemItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String path = (String)element$iv$iv;
            boolean bl2 = false;
            if ((PsiFileSystemItem)CollectionsKt.firstOrNull((Iterable)SpringBootStaticWebFileReferenceHelperKt.access$resolveToFSItem(path, module)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

