/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.mvc.config.viewresolver.TemplateAvailabilityProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

final class ThymeleafTemplateAvailabilityProvider
extends TemplateAvailabilityProvider {
    ThymeleafTemplateAvailabilityProvider() {
    }

    @Override
    public boolean isTemplateAvailable(ConditionalOnEvaluationContext context, String viewName) {
        String viewResolver = ThymeleafTemplateAvailabilityProvider.getViewResolverClass(context);
        if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)viewResolver) == null) {
            return false;
        }
        String prefix = ThymeleafTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.thymeleaf.prefix");
        String suffix = ThymeleafTemplateAvailabilityProvider.getConfigurationOrDefaultValue(context, "spring.thymeleaf.suffix");
        return ThymeleafTemplateAvailabilityProvider.isResourceAvailable(context, prefix + viewName + suffix);
    }

    @NotNull
    private static String getViewResolverClass(ConditionalOnEvaluationContext context) {
        if (SpringBootLibraryUtil.isBelowVersion((Module)context.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
            return "org.thymeleaf.spring4.view.ThymeleafViewResolver";
        }
        if (SpringBootLibraryUtil.isBelowVersion((Module)context.getModule(), (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_3_0_0)) {
            return "org.thymeleaf.spring5.view.ThymeleafViewResolver";
        }
        return "org.thymeleaf.spring6.view.ThymeleafViewResolver";
    }
}

