/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl;

import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveDispatcherServlet;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMappingsModel;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveDispatcherServletImpl;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingImpl;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingPredicate;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingPredicateParser;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingsModelImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveRequestMappingsParser {
    private static final String CONTEXTS_KEY = "contexts";
    private static final String MAPPINGS_KEY = "mappings";
    private static final String DISPATCHER_SERVLETS_KEY = "dispatcherServlets";
    private static final String DISPATCHER_HANDLERS_KEY = "dispatcherHandlers";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private static final String PREDICATE_ATTRIBUTE = "predicate";
    private static final String SERVLETS_KEY = "servlets";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DETAILS_ATTRIBUTE = "details";
    private static final String HANDLER_METHOD_ATTRIBUTE = "handlerMethod";
    private static final String CLASS_NAME_ATTRIBUTE = "className";
    private static final String DESCRIPTOR_ATTRIBUTE = "descriptor";
    private static final String BEAN_ATTRIBUTE = "bean";
    private static final String METHOD_ATTRIBUTE = "method";

    @NotNull
    public LiveRequestMappingsModel parse(Map<?, ?> mappings) {
        if (mappings == null) {
            return new LiveRequestMappingsModelImpl(Collections.emptyList());
        }
        Object contexts = mappings.get(CONTEXTS_KEY);
        if (contexts instanceof Map && mappings.size() == 1) {
            LiveRequestMappingsModel liveRequestMappingsModel = LiveRequestMappingsParser.parseSB20((Map)contexts);
            if (liveRequestMappingsModel == null) {
                LiveRequestMappingsParser.$$$reportNull$$$0(0);
            }
            return liveRequestMappingsModel;
        }
        ArrayList liveMappings = new ArrayList();
        mappings.forEach((key, details) -> {
            if (key instanceof String && details instanceof Map) {
                liveMappings.addAll(LiveRequestMappingsParser.parseEntry((String)key, (Map)details));
            }
        });
        return new LiveRequestMappingsModelImpl(liveMappings);
    }

    @NotNull
    private static List<LiveRequestMapping> parseEntry(@NotNull String mappingKey, @NotNull Map<?, ?> detailsMap) {
        Object beanValue;
        if (mappingKey == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(1);
        }
        if (detailsMap == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(2);
        }
        String bean = (beanValue = detailsMap.get(BEAN_ATTRIBUTE)) == null ? null : beanValue.toString();
        Object methodValue = detailsMap.get(METHOD_ATTRIBUTE);
        String method = methodValue == null ? null : methodValue.toString();
        return LiveRequestMappingsParser.getMappings(mappingKey, bean, method, LiveDispatcherServletImpl.DEFAULT);
    }

    @NotNull
    private static List<LiveRequestMapping> getMappings(@NotNull String mappingKey, @Nullable String bean, @Nullable String method, @NotNull LiveDispatcherServlet dispatcherServlet) {
        if (mappingKey == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(3);
        }
        if (dispatcherServlet == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(4);
        }
        List<LiveRequestMappingPredicate> predicates = LiveRequestMappingPredicateParser.parse(mappingKey);
        List list = ContainerUtil.map(predicates, predicate -> new LiveRequestMappingImpl(mappingKey, (LiveRequestMappingPredicate)predicate, bean, method, dispatcherServlet));
        if (list == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static LiveRequestMappingsModel parseSB20(@NotNull Map<?, ?> contexts) {
        if (contexts == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(6);
        }
        ArrayList liveMappings = new ArrayList();
        contexts.forEach((contextKey, contextDetails) -> {
            if (!(contextKey instanceof String) || !(contextDetails instanceof Map)) {
                return;
            }
            Object mappingsObject = ((Map)contextDetails).get(MAPPINGS_KEY);
            if (!(mappingsObject instanceof Map)) {
                return;
            }
            Map mappings = (Map)mappingsObject;
            HashMap<String, LiveDispatcherServlet> liveDispatcherServlets = new HashMap<String, LiveDispatcherServlet>();
            Object servlets = mappings.get(SERVLETS_KEY);
            if (servlets instanceof List) {
                ((List)servlets).forEach(servletObject -> {
                    if (!(servletObject instanceof Map)) {
                        return;
                    }
                    Map servlet = (Map)servletObject;
                    Object name = servlet.get(NAME_ATTRIBUTE);
                    if (name == null) {
                        return;
                    }
                    Object servletMappingsObject = servlet.get(MAPPINGS_KEY);
                    if (servletMappingsObject instanceof List) {
                        List servletMappings = (List)((List)servletMappingsObject).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toCollection(() -> new SmartList()));
                        liveDispatcherServlets.put(name.toString(), new LiveDispatcherServletImpl(name.toString(), servletMappings));
                    }
                });
            }
            LiveRequestMappingsParser.parseSB20Dispatchers(liveMappings, liveDispatcherServlets, mappings.get(DISPATCHER_SERVLETS_KEY));
            LiveRequestMappingsParser.parseSB20Dispatchers(liveMappings, new HashMap<String, LiveDispatcherServlet>(), mappings.get(DISPATCHER_HANDLERS_KEY));
        });
        return new LiveRequestMappingsModelImpl(liveMappings);
    }

    private static void parseSB20Dispatchers(List<LiveRequestMapping> liveMappings, Map<String, LiveDispatcherServlet> liveDispatcherServlets, Object dispatchers) {
        if (!(dispatchers instanceof Map)) {
            return;
        }
        ((Map)dispatchers).forEach((dispatcherKey, dispatcherDetails) -> {
            String name;
            block3: {
                block2: {
                    if (!(dispatcherKey instanceof String)) break block2;
                    name = (String)dispatcherKey;
                    if (dispatcherDetails instanceof List) break block3;
                }
                return;
            }
            LiveDispatcherServlet liveDispatcherServlet = liveDispatcherServlets.computeIfAbsent(name, key -> new LiveDispatcherServletImpl(name, Collections.emptyList()));
            ((List)dispatcherDetails).forEach(mapping -> {
                if (!(mapping instanceof Map)) {
                    return;
                }
                liveMappings.addAll(LiveRequestMappingsParser.parseSB20Entry((Map)mapping, liveDispatcherServlet));
            });
        });
    }

    @NotNull
    private static List<LiveRequestMapping> parseSB20Entry(@NotNull Map<?, ?> detailsMap, @NotNull LiveDispatcherServlet dispatcherServlet) {
        Object predicateValue;
        if (detailsMap == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(7);
        }
        if (dispatcherServlet == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(8);
        }
        if ((predicateValue = detailsMap.get(PREDICATE_ATTRIBUTE)) == null) {
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsParser.$$$reportNull$$$0(9);
            }
            return list;
        }
        String mappingKey = predicateValue.toString();
        String method = LiveRequestMappingsParser.getHandlerMethod(detailsMap);
        if (method == null) {
            Object handlerValue = detailsMap.get(HANDLER_ATTRIBUTE);
            String handler = handlerValue != null ? handlerValue.toString() : null;
            method = handler != null && !handler.contains("[") ? handler : null;
        }
        return LiveRequestMappingsParser.getMappings(mappingKey, null, method, dispatcherServlet);
    }

    private static String getHandlerMethod(@NotNull Map<?, ?> mapping) {
        Object details;
        if (mapping == null) {
            LiveRequestMappingsParser.$$$reportNull$$$0(10);
        }
        if (!((details = mapping.get(DETAILS_ATTRIBUTE)) instanceof Map)) {
            return null;
        }
        Object handlerMethod = ((Map)details).get(HANDLER_METHOD_ATTRIBUTE);
        if (!(handlerMethod instanceof Map)) {
            return null;
        }
        Map handlerMethodMap = (Map)handlerMethod;
        Object className = handlerMethodMap.get(CLASS_NAME_ATTRIBUTE);
        if (className == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(className.toString());
        Object methodName = handlerMethodMap.get(NAME_ATTRIBUTE);
        if (methodName == null) {
            return null;
        }
        result.append('.').append(methodName.toString()).append('(');
        Object descriptor = handlerMethodMap.get(DESCRIPTOR_ATTRIBUTE);
        if (!(descriptor instanceof String)) {
            return null;
        }
        String parameters = LiveRequestMappingsParser.convertParametersDescriptor((String)descriptor);
        if (parameters == null) {
            return null;
        }
        result.append(parameters).append(')');
        return result.toString();
    }

    private static String convertParametersDescriptor(String descriptor) {
        if (!descriptor.startsWith("(")) {
            return null;
        }
        int end = descriptor.indexOf(41);
        if (end < 0) {
            return null;
        }
        descriptor = descriptor.substring(1, end);
        StringBuilder result = new StringBuilder();
        for (int start = 0; start < descriptor.length(); ++start) {
            if (start != 0) {
                result.append(", ");
            }
            char parameter = descriptor.charAt(start);
            int arrayDimension = 0;
            while (parameter == '[') {
                ++arrayDimension;
                parameter = descriptor.charAt(++start);
            }
            if (parameter == 'L') {
                int typeEnd = descriptor.indexOf(59, start);
                if (typeEnd < 0) {
                    return null;
                }
                String type = descriptor.substring(start + 1, typeEnd);
                start = typeEnd;
                type = type.replaceAll("/", ".");
                result.append(type);
            } else {
                String primitive = LiveRequestMappingsParser.mapPrimitive(parameter);
                if (primitive == null) {
                    return null;
                }
                result.append(primitive);
            }
            result.append("[]".repeat(arrayDimension));
        }
        return result.toString();
    }

    private static String mapPrimitive(char primitive) {
        return switch (primitive) {
            case 'B' -> "byte";
            case 'C' -> "char";
            case 'D' -> "double";
            case 'F' -> "float";
            case 'I' -> "int";
            case 'J' -> "long";
            case 'S' -> "short";
            case 'Z' -> "boolean";
            default -> null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingsParser";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingKey";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsMap";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcherServlet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = CONTEXTS_KEY;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingsParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSB20Entry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseEntry";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseSB20";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSB20Entry";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 10 -> new IllegalArgumentException(string);
        };
    }
}

