/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.model.feign;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamBooleanAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.mvc.model.feign.FeignClientUrlJamConverter;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.jam.SpringRequestBaseUrlElement;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

public abstract class FeignClientBase
extends SpringRequestBaseUrlElement {
    public static final SemKey<JamAnnotationMeta> BASE_JAM_ANNOTATION_KEY = JamService.ANNO_META_KEY.subKey("FeignClientBase", new SemKey[0]);
    public static final SemKey<FeignClientBase> BASE_JAM_KEY = SpringRequestBaseUrlElement.Companion.getJAM_ELEMENT_KEY().subKey("FeignClientBase", new SemKey[0]);
    public static final SemKey<JamMemberMeta> BASE_META_KEY = JamService.getMetaKey(BASE_JAM_KEY);
    protected static final String QUALIFIER_ATTR = "qualifier";
    protected static final String QUALIFIERS_ATTR = "qualifiers";
    protected static final String URL_ATTR = "url";
    protected static final String PRIMARY_ATTR = "primary";
    protected static final JamAttributeMeta<JamStringAttributeElement<String>> QUALIFIER_META = JamAttributeMeta.singleString((String)"qualifier");
    protected static final JamStringAttributeMeta.Collection<String> QUALIFIERS_META = JamAttributeMeta.collectionString((String)"qualifiers");
    protected static final JamAttributeMeta<JamStringAttributeElement<String>> URL_META = JamAttributeMeta.singleString((String)"url", (JamConverter)new FeignClientUrlJamConverter());
    protected static final JamBooleanAttributeMeta PRIMARY_META = JamAttributeMeta.singleBoolean((String)"primary", (boolean)true);
    protected static final JamAnnotationArchetype ARCHETYPE = new JamAnnotationArchetype().addAttribute(QUALIFIER_META).addAttribute(QUALIFIERS_META).addAttribute(URL_META).addAttribute((JamAttributeMeta)PRIMARY_META);

    protected FeignClientBase(@NotNull String anno, PsiElementRef<?> ref) {
        if (anno == null) {
            FeignClientBase.$$$reportNull$$$0(0);
        }
        super(anno, ref);
    }

    @NotNull
    protected abstract List<String> getClientQualifiers();

    protected abstract boolean isPrimaryAttribute();

    public String getBeanName() {
        String name = (String)ContainerUtil.getFirstItem(this.getClientQualifiers());
        return name == null ? this.getPsiElement().getQualifiedName() : name;
    }

    public String @NotNull [] getAliases() {
        List<String> qualifiers = this.getClientQualifiers();
        if (!qualifiers.isEmpty()) {
            String[] result = qualifiers.toArray(ArrayUtilRt.EMPTY_STRING_ARRAY);
            result[0] = this.getPsiElement().getQualifiedName();
            if (result == null) {
                FeignClientBase.$$$reportNull$$$0(1);
            }
            return result;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            FeignClientBase.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public boolean isPrimary() {
        return this.isPrimaryAttribute() || super.isPrimary();
    }

    @Nullable
    protected static PartiallyKnownString asPartiallyKnownString(@Nullable PsiAnnotationMemberValue attributeValue) {
        UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)attributeValue, UInjectionHost.class);
        if (uInjectionHost == null) {
            return null;
        }
        UStringConcatenationsFacade facade = UStringConcatenationsFacade.createFromUExpression((UExpression)uInjectionHost);
        return facade == null ? null : facade.asPartiallyKnownString();
    }

    protected static List<FeignClientBase> findClients(@NotNull Module module, @NotNull String anno, boolean includeTests) {
        if (module == null) {
            FeignClientBase.$$$reportNull$$$0(3);
        }
        if (anno == null) {
            FeignClientBase.$$$reportNull$$$0(4);
        }
        GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)includeTests);
        ArrayList<FeignClientBase> clients = new ArrayList<FeignClientBase>();
        JamService jamService = JamService.getJamService((Project)module.getProject());
        Collection fqns = (Collection)SpringSemContributorUtil.getCustomMetaAnnotations((String)anno).apply(module);
        for (String fqn : fqns) {
            clients.addAll(jamService.getJamClassElements(BASE_JAM_KEY, fqn, scope));
        }
        clients.addAll(ContainerUtil.filter((Collection)jamService.getJamClassElements(BASE_JAM_KEY, anno, scope), client -> !client.getPsiElement().isAnnotationType()));
        return clients;
    }

    public static boolean hasSpringFeignClient(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.cloud.netflix.feign.FeignClient") != null || SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.cloud.openfeign.FeignClient") != null;
    }

    public static boolean hasSpringFeignClient(@Nullable Project project) {
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.cloud.netflix.feign.FeignClient") || JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.cloud.openfeign.FeignClient");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/model/feign/FeignClientBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/model/feign/FeignClientBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClients";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

