/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.debug.breakpoint;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005H\u0014J\u001a\u0010\u0016\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/kotlin/jupyter/debug/breakpoint/KernelSyntheticMethodBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/SyntheticLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "className", "", "methodName", "methodLineNumber", "", "eventHandler", "Lkotlin/Function2;", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "Lcom/sun/jdi/event/LocatableEvent;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;ILkotlin/jvm/functions/Function2;)V", "getLineIndex", "createRequest", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "createOrWaitPrepare", "classToBeLoaded", "processClassPrepare", "Lcom/intellij/debugger/engine/DebugProcess;", "classType", "Lcom/sun/jdi/ReferenceType;", "createRequestForPreparedClass", "createMethodRequest", "method", "Lcom/sun/jdi/Method;", "processLocatableEvent", "", "action", "event", "Companion", "intellij.kotlin.jupyter.debug"})
@SourceDebugExtension(value={"SMAP\nKernelSyntheticMethodBreakpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelSyntheticMethodBreakpoint.kt\ncom/intellij/kotlin/jupyter/debug/breakpoint/KernelSyntheticMethodBreakpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,84:1\n777#2:85\n873#2,2:86\n1915#2,2:88\n1915#2,2:90\n13#3:92\n*S KotlinDebug\n*F\n+ 1 KernelSyntheticMethodBreakpoint.kt\ncom/intellij/kotlin/jupyter/debug/breakpoint/KernelSyntheticMethodBreakpoint\n*L\n49#1:85\n49#1:86,2\n49#1:88,2\n61#1:90,2\n25#1:92\n*E\n"})
public final class KernelSyntheticMethodBreakpoint
extends SyntheticLineBreakpoint {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String className;
    @NotNull
    private final String methodName;
    private final int methodLineNumber;
    @NotNull
    private final Function2<SuspendContextCommandImpl, LocatableEvent, Unit> eventHandler;
    @NotNull
    private static final Logger LOG;

    public KernelSyntheticMethodBreakpoint(@NotNull Project project, @NotNull String className, @NotNull String methodName, int methodLineNumber, @NotNull Function2<? super SuspendContextCommandImpl, ? super LocatableEvent, Unit> eventHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        super(project);
        this.className = className;
        this.methodName = methodName;
        this.methodLineNumber = methodLineNumber;
        this.eventHandler = eventHandler;
        this.setSuspendPolicy("SuspendThread");
    }

    public int getLineIndex() {
        return this.methodLineNumber;
    }

    public void createRequest(@NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        List list = debugProcess.getVirtualMachineProxy().getClassesByNameProvider().get(this.className);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
        ReferenceType targetClass = (ReferenceType)CollectionsKt.singleOrNull((List)list);
        if (targetClass == null) {
            LOG.warn("Main class is not yet loaded :" + this.className + "!");
        }
        this.createOrWaitPrepare(debugProcess, this.className);
    }

    /*
     * WARNING - void declaration
     */
    protected void createOrWaitPrepare(@NotNull DebugProcessImpl debugProcess, @NotNull String classToBeLoaded) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)classToBeLoaded, (String)"classToBeLoaded");
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classToBeLoaded);
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"getVirtualMachineProxy(...)");
        VirtualMachineProxyImpl virtualMachineProxy = virtualMachineProxyImpl;
        if (virtualMachineProxy.canBeModified()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            List list = virtualMachineProxy.classesByName(classToBeLoaded);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classesByName(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ReferenceType it = (ReferenceType)element$iv$iv;
                boolean bl = false;
                if (!it.isPrepared()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReferenceType it = (ReferenceType)element$iv;
                boolean bl = false;
                DebugProcess debugProcess2 = (DebugProcess)debugProcess;
                Intrinsics.checkNotNull((Object)it);
                this.processClassPrepare(debugProcess2, it);
            }
        }
    }

    public void processClassPrepare(@Nullable DebugProcess debugProcess, @NotNull ReferenceType classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        if (!Intrinsics.areEqual((Object)classType.name(), (Object)this.className)) {
            return;
        }
        super.processClassPrepare(debugProcess, classType);
    }

    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        List list = DebuggerUtilsEx.declaredMethodsByName((ReferenceType)classType, (String)this.methodName);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"declaredMethodsByName(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.createMethodRequest(debugProcess, it);
        }
    }

    private final void createMethodRequest(DebugProcessImpl debugProcess, Method method) {
        try {
            Location location = method.locationOfCodeIndex(this.methodLineNumber);
            if (location == null) {
                LOG.warn("Can't find location in method to set up a breakpoint in :" + this.methodName);
                return;
            }
            BreakpointRequest request = debugProcess.getRequestsManager().createBreakpointRequest((FilteredRequestor)this, location);
            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
        }
        catch (AbsentInformationException ex) {
            LOG.warn("Failure during setting up method request", (Throwable)ex);
        }
    }

    public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, @Nullable LocatableEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.eventHandler.invoke((Object)action, (Object)event);
        return super.processLocatableEvent(action, event);
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/debug/breakpoint/KernelSyntheticMethodBreakpoint$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

