/*
 * Decompiled with CFR 0.152.
 */
package org.angular2;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.lang.expr.psi.Angular2EmbeddedExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J/\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J/\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011H\u0007\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/angular2/Angular2InjectionUtils;", "", "<init>", "()V", "getFirstInjectedFile", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiElement;", "getElementAtCaretFromContext", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "findInjectedAngularExpression", "T", "Lorg/angular2/lang/expr/psi/Angular2EmbeddedExpression;", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "expressionClass", "Ljava/lang/Class;", "(Lcom/intellij/psi/xml/XmlAttribute;Ljava/lang/Class;)Lorg/angular2/lang/expr/psi/Angular2EmbeddedExpression;", "literal", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "(Lcom/intellij/lang/javascript/psi/JSLiteralExpression;Ljava/lang/Class;)Lorg/angular2/lang/expr/psi/Angular2EmbeddedExpression;", "intellij.angular.backend"})
public final class Angular2InjectionUtils {
    @NotNull
    public static final Angular2InjectionUtils INSTANCE = new Angular2InjectionUtils();

    private Angular2InjectionUtils() {
    }

    @JvmStatic
    @Nullable
    public static final PsiFile getFirstInjectedFile(@Nullable PsiElement element) {
        List injections;
        if (element != null && (injections = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(element)) != null) {
            for (Pair injection : injections) {
                if (!(injection.getFirst() instanceof PsiFile)) continue;
                Object object = injection.getFirst();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
                return (PsiFile)object;
            }
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getElementAtCaretFromContext(@NotNull DataContext context) {
        PsiElement injected;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Editor editor = (Editor)context.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)context.getData(CommonDataKeys.PSI_FILE);
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (editor == null || project == null || file == null || DumbService.Companion.isDumb(project)) {
            return null;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (!(editor instanceof EditorWindow) && (injected = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(file, caretOffset)) != null && injected.isValid()) {
            return injected;
        }
        Object object = file.findElementAt(caretOffset);
        if (object == null) {
            object = caretOffset == file.getTextLength() ? file.findElementAt(caretOffset - 1) : null;
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final <T extends Angular2EmbeddedExpression> T findInjectedAngularExpression(@NotNull XmlAttribute attribute, @NotNull Class<T> expressionClass) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter(expressionClass, (String)"expressionClass");
        XmlAttributeValue value = attribute.getValueElement();
        if (value != null && value.getTextLength() >= 2) {
            PsiElement injection = InjectedLanguageManager.getInstance((Project)attribute.getProject()).findInjectedElementAt(value.getContainingFile(), value.getTextOffset() + 1);
            return (T)((Angular2EmbeddedExpression)PsiTreeUtil.getParentOfType((PsiElement)injection, expressionClass));
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final <T extends Angular2EmbeddedExpression> T findInjectedAngularExpression(@NotNull JSLiteralExpression literal, @NotNull Class<T> expressionClass) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        Intrinsics.checkNotNullParameter(expressionClass, (String)"expressionClass");
        PsiElement injection = InjectedLanguageManager.getInstance((Project)literal.getProject()).findInjectedElementAt(literal.getContainingFile(), literal.getTextOffset() + 1);
        return (T)((Angular2EmbeddedExpression)PsiTreeUtil.getParentOfType((PsiElement)injection, expressionClass));
    }
}

