/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/angular2/inspections/quickfixes/RemoveJSProperty;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myPropertyName", "", "<init>", "(Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.angular.backend"})
public final class RemoveJSProperty
implements LocalQuickFix {
    @NotNull
    private final String myPropertyName;

    public RemoveJSProperty(@NotNull String myPropertyName) {
        Intrinsics.checkNotNullParameter((Object)myPropertyName, (String)"myPropertyName");
        this.myPropertyName = myPropertyName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.myPropertyName};
        return Angular2Bundle.Companion.message("angular.quickfix.decorator.remove-property.name", objectArray);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.decorator.remove-property.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        JSProperty property;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement().getParent();
        JSProperty jSProperty = property = psiElement instanceof JSProperty ? (JSProperty)psiElement : null;
        if (property != null) {
            PsiElement parent = property.getParent();
            property.delete();
            FormatFixer.create((PsiElement)parent, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
    }
}

