/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementBasis;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J*\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0010H\u0014J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001f0\u0019H\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/database/dataSource/connection/statements/ReusableParameterizedStatement;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "basis", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementBasis;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "<init>", "(Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementBasis;Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "addBatch", "", "input", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "statement", "executeBatch", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "close", "extract", "", "escapeIndexes", "Ljava/util/BitSet;", "decoration", "intellij.database.core.impl"})
public final class ReusableParameterizedStatement
extends JdbcBasedSmartStatement.Parameterized<ParameterizedStatementDecoration>
implements ReusableSmartStatement<ParameterizedStatementDecoration> {
    @NotNull
    private final ParameterizedStatementBasis basis;
    @NotNull
    private final StatementHolder.Reusable<RemotePreparedStatement> statementHolder;
    @NotNull
    private final BatchesContainer batches;

    public ReusableParameterizedStatement(@NotNull ParameterizedStatementBasis basis, @NotNull DatabaseConnectionCore connection, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)basis, (String)"basis");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(connection, auditService, configuration);
        this.basis = basis;
        this.statementHolder = new StatementHolder.Reusable();
        this.batches = new BatchesContainer();
    }

    @Override
    @NotNull
    protected StatementHolder.Reusable<RemotePreparedStatement> getStatementHolder() {
        return this.statementHolder;
    }

    @Override
    public void addBatch(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        RemotePreparedStatement statement = (RemotePreparedStatement)EitherKt.tryGet(this.getCurrentStatement(input)).getValue();
        this.completeStatement(statement, input);
        statement.addBatch();
        this.batches.add(this.basis.getSql());
    }

    @Override
    @NotNull
    protected Either<StagedException, List<RemoteCloseable>> before(@NotNull ParameterizedStatementDecoration input, @NotNull RemotePreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.getAuditService().beforeParameterizedStatement(new ParameterizedStatementData(this.basis, input), this);
        return super.before(input, statement);
    }

    @Override
    @NotNull
    public Either<StagedException, ClosableResultsProducer> executeBatch() {
        Object s = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
        Intrinsics.checkNotNull(s);
        return SmartStatementsUtil.executeBatch(s, this.getConnection(), this, this.batches);
    }

    @Override
    public void close() {
        RemotePreparedStatement statement = (RemotePreparedStatement)((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
        if (statement != null) {
            this.getAuditService().beforeStatementClosing((RemoteStatement)statement, this);
            JdbcNativeUtil.performSafe(() -> ((RemotePreparedStatement)statement).close());
        }
        this.batches.clear();
    }

    @Override
    @NotNull
    public String extract(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.basis.getSql();
    }

    @Override
    @NotNull
    public BitSet escapeIndexes(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.basis.getEscapingIndexes();
    }

    @Override
    @NotNull
    public ParameterizedStatementDecoration decoration(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input;
    }
}

