/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_51;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "SEQUENCE_IDENTITY_PROPERTY_NAME", "", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "checkDbms", "", "dbms", "Lcom/intellij/database/Dbms;", "convertSequences", "convertSequence", "elementMem", "Lcom/intellij/database/model/serialization/ModelElementMem;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_51.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_51.kt\ncom/intellij/database/model/serialization/converters/Converter_4_51\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1342#2,2:44\n1#3:46\n*S KotlinDebug\n*F\n+ 1 Converter_4_51.kt\ncom/intellij/database/model/serialization/converters/Converter_4_51\n*L\n29#1:44,2\n*E\n"})
public final class Converter_4_51
extends Converter {
    @NotNull
    public static final Converter_4_51 INSTANCE = new Converter_4_51();
    @NotNull
    private static final String SEQUENCE_IDENTITY_PROPERTY_NAME = "SequenceIdentity";

    private Converter_4_51() {
        int[] nArray = new int[]{4, 51};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (!this.checkDbms(modelMem.getDbms())) {
            return;
        }
        this.convertSequences(modelMem);
    }

    private final boolean checkDbms(Dbms dbms) {
        return dbms.isPostgres();
    }

    private final void convertSequences(ModelMem modelMem) {
        String sequenceCode = ObjectKind.SEQUENCE.code();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)modelMem.getNodes()), arg_0 -> Converter_4_51.convertSequences$lambda$0(sequenceCode, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelElementMem it = (ModelElementMem)element$iv;
            boolean bl = false;
            INSTANCE.convertSequence(it);
        }
    }

    private final void convertSequence(ModelElementMem elementMem) {
        MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(elementMem.getProperties(), SEQUENCE_IDENTITY_PROPERTY_NAME);
        if (mutableNameAndValue == null) {
            return;
        }
        MutableNameAndValue sequenceIdentityProperty = mutableNameAndValue;
        Object it = sequenceIdentityProperty;
        boolean bl = false;
        SequenceIdentity sequenceIdentity = PropertyConverter.importSequenceIdentity(sequenceIdentityProperty.getValue());
        if (sequenceIdentity == null) {
            return;
        }
        SequenceIdentity sequenceIdentity2 = sequenceIdentity;
        if (sequenceIdentity2.next != null) {
            it = sequenceIdentity2;
            boolean bl2 = false;
            String newSequenceIdentityValue = PropertyConverter.export(SequenceIdentity.of(((SequenceIdentity)it).min, null, ((SequenceIdentity)it).increment, ((SequenceIdentity)it).max));
            Intrinsics.checkNotNull((Object)newSequenceIdentityValue);
            sequenceIdentityProperty.setValue(newSequenceIdentityValue);
        }
    }

    private static final boolean convertSequences$lambda$0(String $sequenceCode, ModelElementMem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getKind(), (Object)$sequenceCode);
    }
}

