/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.LoadingDetailsImpl;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0015\u001a\u00020\u00022\n\u0010\u0016\u001a\u00060\u000fj\u0002`\u0011J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00022\n\u0010\u0016\u001a\u00060\u000fj\u0002`\u0011H\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00110\u001aH\u0014J\u001c\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u000fj\u0002`\u00112\u0006\u0010\u001e\u001a\u00020\u0002H\u0014J6\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001a2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020%H\u0014J\b\u0010&\u001a\u00020\u001cH\u0016R(\u0010\r\u001a\u001c\u0012\r\u0012\u000b0\u000fj\u0002`\u0011\u00a2\u0006\u0002\b\u0010\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u001c\u0012\r\u0012\u000b0\u000fj\u0002`\u0011\u00a2\u0006\u0002\b\u0010\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00100\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/vcs/log/data/CommitDetailsGetter;", "Lcom/intellij/vcs/log/data/AbstractDataGetter;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;Lcom/intellij/openapi/Disposable;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "placeholdersCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/vcs/log/data/LoadingDetailsImpl;", "getCachedDataOrPlaceholder", "commitId", "getCachedData", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "commits", "", "saveInCache", "", "commit", "details", "doLoadCommitsDataFromProvider", "logProvider", "root", "hashes", "", "consumer", "Lcom/intellij/util/Consumer;", "dispose", "intellij.platform.vcs.log.impl"})
public final class CommitDetailsGetter
extends AbstractDataGetter<VcsFullCommitDetails> {
    @NotNull
    private final Cache<Integer, VcsFullCommitDetails> cache;
    @NotNull
    private final LoadingCache<Integer, LoadingDetailsImpl> placeholdersCache;

    public CommitDetailsGetter(@NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(storage, logProviders, parentDisposable);
        Cache cache = Caffeine.newBuilder().maximumSize(10000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(1000L).weakValues().build(new CacheLoader(storage){
            final /* synthetic */ VcsLogStorage $storage;
            {
                this.$storage = $storage;
            }

            public final LoadingDetailsImpl load(Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new LoadingDetailsImpl(this.$storage, it, 0L);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.placeholdersCache = loadingCache;
        LowMemoryWatcher.register(() -> CommitDetailsGetter._init_$lambda$0(this), (Disposable)this);
    }

    @NotNull
    public final VcsFullCommitDetails getCachedDataOrPlaceholder(int commitId) {
        VcsFullCommitDetails vcsFullCommitDetails = this.getCachedData(commitId);
        if (vcsFullCommitDetails == null) {
            Object object = this.placeholdersCache.get((Object)commitId);
            Intrinsics.checkNotNull((Object)object);
            vcsFullCommitDetails = (VcsFullCommitDetails)object;
        }
        return vcsFullCommitDetails;
    }

    @Nullable
    public VcsFullCommitDetails getCachedData(int commitId) {
        return (VcsFullCommitDetails)this.cache.getIfPresent((Object)commitId);
    }

    @Override
    @NotNull
    protected Int2ObjectMap<VcsFullCommitDetails> getCachedData(@NotNull List<Integer> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        return (Int2ObjectMap)new Int2ObjectOpenHashMap(this.cache.getAllPresent((Iterable)commits));
    }

    @Override
    protected void saveInCache(int commit, @NotNull VcsFullCommitDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.cache.put((Object)commit, (Object)details);
    }

    @Override
    protected void doLoadCommitsDataFromProvider(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsFullCommitDetails> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)logProvider, (String)"logProvider");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        logProvider.readFullDetails(root, hashes, consumer);
    }

    public void dispose() {
        this.cache.invalidateAll();
        this.placeholdersCache.invalidateAll();
    }

    private static final void _init_$lambda$0(CommitDetailsGetter this$0) {
        this$0.cache.invalidateAll();
    }
}

