/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vcs.telemetry.VcsBackendTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRefsKt;
import com.intellij.vcs.log.VcsLogRefsOfSingleRoot;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogGraphData;
import com.intellij.vcs.log.data.VcsLogGraphDataImpl;
import com.intellij.vcs.log.data.VcsLogGraphOverlayData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.HeadCommitsComparator;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetterFactory;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.print.GraphColorGetterByHeadFactory;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007JP\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007JN\u0010\u001c\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\u00182\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u00072\u0006\u0010\u0015\u001a\u00020\u001d2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u001e\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\u001f2\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tj\u0002`\n0\b0\u0007H\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/log/data/VcsLogGraphDataFactory;", "", "<init>", "()V", "buildData", "Lcom/intellij/vcs/log/data/VcsLogGraphData;", "commits", "", "Lcom/intellij/vcs/log/graph/GraphCommit;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "refs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogRefsOfSingleRoot;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "full", "", "refsModel", "Lcom/intellij/vcs/log/VcsLogRefs;", "permanentGraph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "logProviders", "buildOverlayData", "Lcom/intellij/vcs/log/data/VcsLogGraphData$OverlayData;", "buildPermanentGraph", "Lcom/intellij/vcs/log/data/RefsModel;", "getHeads", "", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogGraphDataFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogGraphDataFactory.kt\ncom/intellij/vcs/log/data/VcsLogGraphDataFactory\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,110:1\n466#2:111\n415#2:112\n1266#3,4:113\n1661#3,3:117\n1480#3,5:133\n27#4:120\n87#4,2:121\n28#4,3:123\n98#4:126\n90#4,6:127\n*S KotlinDebug\n*F\n+ 1 VcsLogGraphDataFactory.kt\ncom/intellij/vcs/log/data/VcsLogGraphDataFactory\n*L\n64#1:111\n64#1:112\n64#1:113,4\n67#1:117,3\n79#1:133,5\n70#1:120\n70#1:121,2\n70#1:123,3\n70#1:126\n70#1:127,6\n*E\n"})
public final class VcsLogGraphDataFactory {
    @NotNull
    public static final VcsLogGraphDataFactory INSTANCE = new VcsLogGraphDataFactory();

    private VcsLogGraphDataFactory() {
    }

    @JvmStatic
    @NotNull
    public static final VcsLogGraphData buildData(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, ? extends VcsLogRefsOfSingleRoot> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage, boolean full) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        RefsModel refsModel = RefsModel.Companion.create(refs, INSTANCE.getHeads(commits), storage, providers);
        PermanentGraph<Integer> permanentGraph = INSTANCE.buildPermanentGraph(commits, refsModel, providers, storage);
        return VcsLogGraphDataFactory.buildData(refsModel, permanentGraph, providers, full);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogGraphData buildData(@NotNull VcsLogRefs refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, boolean full) {
        Intrinsics.checkNotNullParameter((Object)refsModel, (String)"refsModel");
        Intrinsics.checkNotNullParameter(permanentGraph, (String)"permanentGraph");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        return new VcsLogGraphDataImpl(refsModel, permanentGraph, logProviders, full);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogGraphData.OverlayData buildOverlayData(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, ? extends VcsLogRefsOfSingleRoot> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        RefsModel refsModel = RefsModel.Companion.create(refs, INSTANCE.getHeads(commits), storage, providers);
        PermanentGraph<Integer> permanentGraph = INSTANCE.buildPermanentGraph(commits, refsModel, providers, storage);
        return new VcsLogGraphOverlayData(refsModel, permanentGraph, providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final PermanentGraph<Integer> buildPermanentGraph(List<? extends GraphCommit<Integer>> commits, RefsModel refsModel, Map<VirtualFile, ? extends VcsLogProvider> providers, VcsLogStorage storage) {
        Map.Entry entry;
        void $this$mapTo$iv;
        Map.Entry entry2;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        if (commits.isEmpty()) {
            PermanentGraph<Integer> permanentGraph = EmptyPermanentGraph.getInstance();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getInstance(...)");
            return permanentGraph;
        }
        Map<VirtualFile, ? extends VcsLogProvider> map = providers;
        VcsLogRefs vcsLogRefs = refsModel;
        boolean $i$f$mapValues22 = false;
        void var8_9 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            VcsLogRefManager vcsLogRefManager = ((VcsLogProvider)it.getValue()).getReferenceManager();
            map3.put(k, vcsLogRefManager);
        }
        Function<Object, Hash> function = arg_0 -> VcsLogGraphDataFactory.buildPermanentGraph$lambda$2(arg_0 -> VcsLogGraphDataFactory.buildPermanentGraph$lambda$1(storage, arg_0), arg_0);
        Map map4 = destination$iv$iv$iv;
        VcsLogRefs vcsLogRefs2 = vcsLogRefs;
        HeadCommitsComparator headCommitsComparator = new HeadCommitsComparator(vcsLogRefs2, map4, function);
        Iterable $i$f$mapValues22 = VcsLogRefsKt.getBranches((VcsLogRefs)refsModel);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            destination$iv$iv$iv = (VcsRef)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Hash hash = it.getCommitHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
            VirtualFile virtualFile = it.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            collection.add(storage.getCommitIndex(hash, virtualFile));
        }
        HashSet branches = (HashSet)destination$iv;
        IJTracer tracer = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope);
        SpanBuilder spanBuilder = tracer.spanBuilder(VcsBackendTelemetrySpan.LogData.BuildingGraph.getName());
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl3 = false;
                Span span2 = span$iv;
                boolean bl4 = false;
                entry2 = PermanentGraphImpl.Companion.newInstance(commits, (GraphColorGetterFactory)new GraphColorGetterByHeadFactory((GraphColorManager)new GraphColorManagerImpl(refsModel)), (Comparator)headCommitsComparator, (Set)branches);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            entry = entry2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            $this$useWithoutActiveScope$iv$iv.end();
        }
        return (PermanentGraph)entry;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Integer> getHeads(List<? extends GraphCommit<Integer>> commits) {
        void $this$flatMapTo$iv;
        Iterable iterable = commits;
        Collection destination$iv = (Collection)new IntOpenHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv) {
            GraphCommit it = (GraphCommit)t;
            boolean bl = false;
            List list = it.getParents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
            Iterable list$iv = list;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        IntOpenHashSet parents = (IntOpenHashSet)destination$iv;
        Iterable $this$getHeads_u24lambda_u241 = iterable = SetsKt.createSetBuilder();
        boolean bl = false;
        for (GraphCommit graphCommit : commits) {
            Object object = graphCommit.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
            if (parents.contains(((Number)object).intValue())) continue;
            Object object2 = graphCommit.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getId(...)");
            $this$getHeads_u24lambda_u241.add(object2);
        }
        return SetsKt.build((Set)iterable);
    }

    private static final Hash buildPermanentGraph$lambda$1(VcsLogStorage $storage, Integer commitIndex) {
        Intrinsics.checkNotNull((Object)commitIndex);
        CommitId commitId = $storage.getCommitId(commitIndex);
        return commitId != null ? commitId.getHash() : null;
    }

    private static final Hash buildPermanentGraph$lambda$2(Function1 $tmp0, Object p0) {
        return (Hash)$tmp0.invoke(p0);
    }
}

