/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerFactory;
import com.intellij.vcsUtil.VcsFileUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryColorManager;", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "baseColorManager", "getPathColor", "Ljava/awt/Color;", "colorSpace", "", "update", "", "pack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "getPaths", "", "getLongName", "intellij.platform.vcs.log.impl"})
public final class FileHistoryColorManager
implements VcsLogColorManager {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final FilePath path;
    @NotNull
    private VcsLogColorManager baseColorManager;

    public FileHistoryColorManager(@NotNull VirtualFile root, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.root = root;
        this.path = path;
        this.baseColorManager = VcsLogColorManagerFactory.create(SetsKt.setOf((Object)this.path));
    }

    @Override
    @NotNull
    public Color getPathColor(@NotNull FilePath path, @NotNull String colorSpace) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Color color = this.baseColorManager.getPathColor(path, colorSpace);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getPathColor(...)");
        return color;
    }

    public final void update(@NotNull VcsLogDataPack pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        Set<FilePath> pathsFromPack = FileHistoryPaths.filePaths(pack);
        if (pathsFromPack.isEmpty()) {
            this.baseColorManager = VcsLogColorManagerFactory.create(SetsKt.setOf((Object)this.path));
        } else {
            Set set;
            Set it = set = CollectionFactory.createLinkedCustomHashingStrategySet(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
            boolean bl = false;
            Collection<FilePath> collection = this.baseColorManager.getPaths();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getPaths(...)");
            it.addAll(collection);
            Set set2 = set;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"also(...)");
            Set newPaths = set2;
            newPaths.retainAll((Collection)pathsFromPack);
            newPaths.addAll((Collection)pathsFromPack);
            this.baseColorManager = VcsLogColorManagerFactory.create(newPaths);
        }
    }

    @Override
    @NotNull
    public Collection<FilePath> getPaths() {
        Collection<FilePath> collection = this.baseColorManager.getPaths();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getPaths(...)");
        return collection;
    }

    @Override
    @NotNull
    public String getLongName(@NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = VcsFileUtil.relativePath((VirtualFile)this.root, (FilePath)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"relativePath(...)");
        return string;
    }
}

