/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.history.VcsLogFileHistoryFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.filter.BranchFilterModel;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogPopupComponentAction;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002%&BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\u0006\u0010\u001f\u001a\u00020\u001eJ\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020!H\u0007J\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterUi;", "Lcom/intellij/vcs/log/VcsLogFilterUi;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "properties", "Lcom/intellij/vcs/log/history/FileHistoryUiProperties;", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "initialFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "filterConsumer", "Ljava/util/function/Consumer;", "<init>", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/history/FileHistoryUiProperties;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogFilterCollection;Ljava/util/function/Consumer;)V", "propertiesWrapper", "Lcom/intellij/vcs/log/history/FileHistoryFilterUi$PropertiesWrapper;", "branchFilterModel", "Lcom/intellij/vcs/log/ui/filter/BranchFilterModel;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "getVisiblePack", "()Lcom/intellij/vcs/log/visible/VisiblePack;", "setVisiblePack", "(Lcom/intellij/vcs/log/visible/VisiblePack;)V", "getFilters", "hasBranchFilter", "", "isBranchFilterEnabled", "resetFiltersToDefault", "", "clearFilters", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "BranchFilterComponent", "PropertiesWrapper", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFileHistoryFilterUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterUi.kt\ncom/intellij/vcs/log/history/FileHistoryFilterUi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1807#2,3:107\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterUi.kt\ncom/intellij/vcs/log/history/FileHistoryFilterUi\n*L\n56#1:107,3\n*E\n"})
public final class FileHistoryFilterUi
implements VcsLogFilterUi {
    @NotNull
    private final FilePath path;
    @Nullable
    private final Hash hash;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final VcsLogData data;
    @NotNull
    private final VcsLogFilterCollection initialFilters;
    @NotNull
    private final PropertiesWrapper propertiesWrapper;
    @NotNull
    private final BranchFilterModel branchFilterModel;
    @NotNull
    private VisiblePack visiblePack;

    public FileHistoryFilterUi(@NotNull FilePath path, @Nullable Hash hash, @NotNull VirtualFile root, @NotNull FileHistoryUiProperties properties, @NotNull VcsLogData data, @NotNull VcsLogFilterCollection initialFilters, @NotNull Consumer<VcsLogFilterCollection> filterConsumer) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)initialFilters, (String)"initialFilters");
        Intrinsics.checkNotNullParameter(filterConsumer, (String)"filterConsumer");
        this.path = path;
        this.hash = hash;
        this.root = root;
        this.data = data;
        this.initialFilters = initialFilters;
        this.propertiesWrapper = new PropertiesWrapper(properties);
        this.visiblePack = VisiblePack.EMPTY;
        this.branchFilterModel = new BranchFilterModel((Function0<? extends VcsLogDataPack>)((Function0)new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((FileHistoryFilterUi)this.receiver).getVisiblePack();
            }

            public void set(Object value) {
                ((FileHistoryFilterUi)this.receiver).setVisiblePack((VisiblePack)value);
            }
        }), this.data.getStorage(), CollectionsKt.listOf((Object)this.root), (Function0<? extends Collection<? extends VirtualFile>>)((Function0)() -> FileHistoryFilterUi._init_$lambda$0(this)), this.propertiesWrapper, this.initialFilters);
        this.branchFilterModel.addSetFilterListener(() -> FileHistoryFilterUi._init_$lambda$1(filterConsumer, this));
    }

    @NotNull
    public final VisiblePack getVisiblePack() {
        return this.visiblePack;
    }

    public final void setVisiblePack(@NotNull VisiblePack visiblePack) {
        Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"<set-?>");
        this.visiblePack = visiblePack;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFileHistoryFilter fileFilter = new VcsLogFileHistoryFilter(this.path, this.hash);
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{fileFilter, this.branchFilterModel.getBranchFilter(), this.branchFilterModel.getRevisionFilter(), this.branchFilterModel.getRangeFilter()};
        return VcsLogFilterObject.collection(vcsLogFilterArray);
    }

    @RequiresEdt
    public final boolean hasBranchFilter() {
        VcsLogFilterCollection vcsLogFilterCollection = (VcsLogFilterCollection)this.branchFilterModel.getFilter();
        return vcsLogFilterCollection != null ? !vcsLogFilterCollection.isEmpty() : false;
    }

    public final boolean isBranchFilterEnabled() {
        boolean bl;
        block5: {
            if (FileHistoryFilterer.Companion.canFilterWithIndex$intellij_platform_vcs_log_impl(this.data.getIndex(), this.root, this.visiblePack.getDataPack())) {
                return true;
            }
            VcsLogProvider vcsLogProvider = this.data.getLogProviders().get(this.root);
            if (vcsLogProvider == null || (vcsLogProvider = vcsLogProvider.getFileHistoryHandler(this.data.getProject())) == null) {
                return false;
            }
            VcsLogProvider handler = vcsLogProvider;
            Set supportedFilters = handler.getSupportedFilters(this.root, this.path, this.hash);
            Iterable $this$any$iv = BranchFilterModel.Companion.getBranchFilterKeys$intellij_platform_vcs_log_impl();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VcsLogFilterCollection.FilterKey it = (VcsLogFilterCollection.FilterKey)element$iv;
                    boolean bl2 = false;
                    if (!supportedFilters.contains(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @RequiresEdt
    public final void resetFiltersToDefault() {
        this.branchFilterModel.setFilter(this.initialFilters);
    }

    @RequiresEdt
    public final void clearFilters() {
        this.branchFilterModel.setFilter(null);
    }

    @NotNull
    public final ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new BranchFilterComponent());
        return (ActionGroup)actionGroup;
    }

    private static final Collection _init_$lambda$0(FileHistoryFilterUi this$0) {
        return CollectionsKt.listOf((Object)this$0.root);
    }

    private static final void _init_$lambda$1(Consumer $filterConsumer, FileHistoryFilterUi this$0) {
        $filterConsumer.accept(this$0.getFilters());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterUi$BranchFilterComponent;", "Lcom/intellij/vcs/log/ui/filter/VcsLogPopupComponentAction;", "<init>", "(Lcom/intellij/vcs/log/history/FileHistoryFilterUi;)V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getTargetComponent", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    private final class BranchFilterComponent
    extends VcsLogPopupComponentAction {
        public BranchFilterComponent() {
            Supplier<String> supplier = VcsLogBundle.messagePointer("vcs.log.branch.filter.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            super(supplier);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            JComponent it = jComponent = new BranchFilterPopupComponent(FileHistoryFilterUi.this.propertiesWrapper, FileHistoryFilterUi.this.branchFilterModel).initUi();
            boolean bl = false;
            it.setEnabled(presentation.isEnabled());
            JComponent jComponent2 = jComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"also(...)");
            return jComponent2;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(FileHistoryFilterUi.this.isBranchFilterEnabled());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @Override
        @Nullable
        protected JComponent getTargetComponent(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FileHistoryUi fileHistoryUi = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
            return fileHistoryUi != null ? fileHistoryUi.getToolbar() : null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\tH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\t2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\nH\u0016J\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\n2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0011\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0097\u0001J\u0019\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0097\u0001J#\u0010\u0018\u001a\u00020\u0019\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001dH\u0096\u0001J(\u0010\u001e\u001a\u0002H\u001a\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001dH\u0097\u0003\u00a2\u0006\u0002\u0010\u001fJ\u0011\u0010 \u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0097\u0001J0\u0010!\u001a\u00020\u000e\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d2\u0006\u0010\"\u001a\u0002H\u001aH\u0097\u0003\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterUi$PropertiesWrapper;", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "properties", "Lcom/intellij/vcs/log/history/FileHistoryUiProperties;", "<init>", "(Lcom/intellij/vcs/log/history/FileHistoryUiProperties;)V", "filters", "", "", "", "getFilterValues", "filterName", "saveFilterValues", "", "values", "addRecentlyFilteredGroup", "", "getRecentlyFilteredGroups", "addChangeListener", "listener", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$PropertiesChangeListener;", "parent", "Lcom/intellij/openapi/Disposable;", "exists", "", "T", "", "property", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;", "get", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;)Ljava/lang/Object;", "removeChangeListener", "set", "value", "(Lcom/intellij/vcs/log/impl/VcsLogUiProperties$VcsLogUiProperty;Ljava/lang/Object;)V", "intellij.platform.vcs.log.impl"})
    private static final class PropertiesWrapper
    implements MainVcsLogUiProperties,
    VcsLogUiProperties {
        @NotNull
        private final FileHistoryUiProperties properties;
        @NotNull
        private final Map<String, List<String>> filters;

        public PropertiesWrapper(@NotNull FileHistoryUiProperties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            this.properties = properties;
            this.filters = new LinkedHashMap();
        }

        @Override
        @Nullable
        public List<String> getFilterValues(@NotNull String filterName) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            return this.filters.get(filterName);
        }

        @Override
        public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            if (values != null) {
                this.filters.put(filterName, values);
            } else {
                this.filters.remove(filterName);
            }
        }

        @Override
        public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.properties.addRecentlyFilteredGroup$intellij_platform_vcs_log_impl(filterName, values);
        }

        @Override
        @NotNull
        public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
            Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
            return this.properties.getRecentlyFilteredGroups$intellij_platform_vcs_log_impl(filterName);
        }

        @Override
        @RequiresEdt
        public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return this.properties.get(property);
        }

        @Override
        @RequiresEdt
        public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, T value) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            this.properties.set(property, value);
        }

        @Override
        public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return this.properties.exists(property);
        }

        @Override
        @RequiresEdt
        public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.properties.addChangeListener(listener2);
        }

        @Override
        @RequiresEdt
        public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2, @NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.properties.addChangeListener(listener2, parent);
        }

        @Override
        @RequiresEdt
        public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.properties.removeChangeListener(listener2);
        }
    }
}

