/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.vcs.log.data.index.ChangeKind;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.impl.facade.GraphModificationUtilKt;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.history.FileHistoryData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u001c\u0010\n\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\f\u0012\u0004\u0012\u00020\r0\u000bH\u0007\u001a*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u000bH\u0000\u001a(\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\u001aN\u0010\u0017\u001a\u00020\r2\u001e\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001b0\u00192$\u0010\u001d\u001a \u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\u0004\u0012\u00020\r0\u001eH\u0000\u001a\u001e\u0010\u001f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0000\u001a9\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010$\"\u0004\b\u0001\u0010#*\b\u0012\u0004\u0012\u0002H$0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u0002H#0\u000bH\u0002\u00a2\u0006\u0002\u0010'\"\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0)8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"removeTrivialMerges", "", "controller", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "fileHistoryData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "report", "Lkotlin/Function1;", "", "", "hideTrivialMerges", "collapsedGraph", "Lcom/intellij/vcs/log/graph/collapsing/CollapsedGraph;", "isCandidateNodeId", "hideTrivialMerge", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "node", "singleParent", "forEach", "map", "", "Lcom/intellij/openapi/vcs/FilePath;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/data/index/ChangeKind;", "action", "Lkotlin/Function3;", "removeAll", "keys", "", "firstNotNull", "R", "E", "", "mapping", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "FILE_PATH_HASHING_STRATEGY", "Lcom/intellij/util/containers/HashingStrategy;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,506:1\n1915#2,2:507\n1915#2,2:509\n1586#2:511\n1661#2,3:512\n*S KotlinDebug\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryKt\n*L\n481#1:507,2\n490#1:509,2\n177#1:511\n177#1:512,3\n*E\n"})
public final class FileHistoryKt {
    @JvmField
    @NotNull
    public static final HashingStrategy<FilePath> FILE_PATH_HASHING_STRATEGY;

    @ApiStatus.Internal
    public static final boolean removeTrivialMerges(@NotNull LinearGraphController controller, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo, @NotNull FileHistoryData fileHistoryData, @NotNull Function1<? super Set<Integer>, Unit> report) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        Intrinsics.checkNotNullParameter((Object)fileHistoryData, (String)"fileHistoryData");
        Intrinsics.checkNotNullParameter(report, (String)"report");
        IntOpenHashSet trivialCandidates = new IntOpenHashSet();
        IntOpenHashSet nonTrivialMerges = new IntOpenHashSet();
        fileHistoryData.forEach((Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FileHistoryKt.removeTrivialMerges$lambda$0(trivialCandidates, nonTrivialMerges, arg_0, arg_1, arg_2)));
        boolean needToRepeat2 = trivialCandidates.removeAll((IntCollection)nonTrivialMerges);
        if (!trivialCandidates.isEmpty()) {
            GraphModificationUtilKt.modifyGraph((LinearGraphController)controller, arg_0 -> FileHistoryKt.removeTrivialMerges$lambda$1(report, fileHistoryData, trivialCandidates, permanentGraphInfo, arg_0));
        }
        return needToRepeat2;
    }

    @NotNull
    public static final Set<Integer> hideTrivialMerges(@NotNull CollapsedGraph collapsedGraph, @NotNull Function1<? super Integer, Boolean> isCandidateNodeId) {
        Intrinsics.checkNotNullParameter((Object)collapsedGraph, (String)"collapsedGraph");
        Intrinsics.checkNotNullParameter(isCandidateNodeId, (String)"isCandidateNodeId");
        Set result = new LinkedHashSet();
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)collapsedGraph.getCompiledGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        LiteLinearGraph graph = liteLinearGraph;
        block0: for (int v = graph.nodesCount() - 1; -1 < v; --v) {
            List downNodes;
            int nodeId = collapsedGraph.getCompiledGraph().getNodeId(v);
            if (!((Boolean)isCandidateNodeId.invoke((Object)nodeId)).booleanValue()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)graph.getNodes(v, LiteLinearGraph.NodeFilter.DOWN), (String)"getNodes(...)");
            if (downNodes.size() == 1) {
                result.add(nodeId);
                Object object = CollectionsKt.single((List)downNodes);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
                FileHistoryKt.hideTrivialMerge(collapsedGraph, graph, v, ((Number)object).intValue());
                continue;
            }
            if (downNodes.size() < 2) continue;
            Iterator sortedParentsIt = CollectionsKt.sortedDescending((Iterable)downNodes).iterator();
            Integer currentParent = (Integer)sortedParentsIt.next();
            while (sortedParentsIt.hasNext()) {
                Integer nextParent = (Integer)sortedParentsIt.next();
                Integer n = currentParent;
                Intrinsics.checkNotNull((Object)n);
                int n2 = ((Number)n).intValue();
                Intrinsics.checkNotNull((Object)nextParent);
                if (!GraphUtilKt.isAncestor((LiteLinearGraph)graph, (int)n2, (int)nextParent)) continue block0;
                currentParent = nextParent;
            }
            result.add(nodeId);
            Integer n = currentParent;
            Intrinsics.checkNotNull((Object)n);
            FileHistoryKt.hideTrivialMerge(collapsedGraph, graph, v, ((Number)n).intValue());
        }
        return result;
    }

    private static final void hideTrivialMerge(CollapsedGraph collapsedGraph, LiteLinearGraph graph, int node, int singleParent) {
        GraphModificationUtilKt.modify((CollapsedGraph)collapsedGraph, arg_0 -> FileHistoryKt.hideTrivialMerge$lambda$0(node, graph, singleParent, arg_0));
    }

    public static final void forEach(@NotNull Map<FilePath, ? extends Int2ObjectMap<Int2ObjectMap<ChangeKind>>> map, @NotNull Function3<? super FilePath, ? super Integer, ? super Int2ObjectMap<ChangeKind>, Unit> action) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        for (Map.Entry<FilePath, ? extends Int2ObjectMap<Int2ObjectMap<ChangeKind>>> entry : map.entrySet()) {
            FilePath filePath = entry.getKey();
            Int2ObjectMap<Int2ObjectMap<ChangeKind>> affectedCommits = entry.getValue();
            ObjectSet objectSet = affectedCommits.int2ObjectEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"int2ObjectEntrySet(...)");
            Iterable $this$forEach$iv = (Iterable)objectSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Int2ObjectMap.Entry entry2 = (Int2ObjectMap.Entry)element$iv;
                boolean bl = false;
                int commit = entry2.getIntKey();
                Int2ObjectMap changesMap = (Int2ObjectMap)entry2.getValue();
                Integer n = commit;
                Intrinsics.checkNotNull((Object)changesMap);
                action.invoke((Object)filePath, (Object)n, (Object)changesMap);
            }
        }
    }

    public static final void removeAll(@NotNull Int2ObjectMap<?> $this$removeAll, @NotNull List<Integer> keys) {
        Intrinsics.checkNotNullParameter($this$removeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int p0 = ((Number)element$iv).intValue();
            boolean bl = false;
            $this$removeAll.remove(p0);
        }
    }

    private static final <E, R> R firstNotNull(Collection<? extends E> $this$firstNotNull, Function1<? super E, ? extends R> mapping) {
        for (E e : $this$firstNotNull) {
            Object value = mapping.invoke(e);
            if (value == null) continue;
            return (R)value;
        }
        return null;
    }

    private static final boolean removeTrivialMerges$lambda$1$0(IntOpenHashSet $trivialCandidates, PermanentGraphInfo $permanentGraphInfo, int nodeId) {
        Object object = $permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommitId(...)");
        return $trivialCandidates.contains(((Number)object).intValue());
    }

    private static final Unit removeTrivialMerges$lambda$0(IntOpenHashSet $trivialCandidates, IntOpenHashSet $nonTrivialMerges, FilePath filePath, int commit, Int2ObjectMap changes) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        if (changes.size() > 1) {
            boolean bl = changes.containsValue((Object)ChangeKind.NOT_CHANGED) ? $trivialCandidates.add(commit) : $nonTrivialMerges.add(commit);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit removeTrivialMerges$lambda$1(Function1 $report, FileHistoryData $fileHistoryData, IntOpenHashSet $trivialCandidates, PermanentGraphInfo $permanentGraphInfo, CollapsedGraph collapsedGraph) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)collapsedGraph, (String)"collapsedGraph");
        Set<Integer> trivialMerges = FileHistoryKt.hideTrivialMerges(collapsedGraph, (Function1<? super Integer, Boolean>)((Function1)arg_0 -> FileHistoryKt.removeTrivialMerges$lambda$1$0($trivialCandidates, $permanentGraphInfo, arg_0)));
        if (!((Collection)trivialMerges).isEmpty()) {
            $report.invoke(trivialMerges);
        }
        Iterable iterable = trivialMerges;
        FileHistoryData fileHistoryData = $fileHistoryData;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Integer)$permanentGraphInfo.getPermanentCommitsInfo().getCommitId((int)it));
        }
        fileHistoryData.removeAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final Unit hideTrivialMerge$lambda$0(int $node, LiteLinearGraph $graph, int $singleParent, CollapsedGraph.Modification $this$modify) {
        Intrinsics.checkNotNullParameter((Object)$this$modify, (String)"$this$modify");
        GraphModificationUtilKt.hideRow((CollapsedGraph.Modification)$this$modify, (int)$node);
        for (Integer upNode : $graph.getNodes($node, LiteLinearGraph.NodeFilter.UP)) {
            Intrinsics.checkNotNull((Object)upNode);
            GraphModificationUtilKt.connectRows((CollapsedGraph.Modification)$this$modify, (int)upNode, (int)$singleParent);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$firstNotNull(Collection $receiver, Function1 mapping) {
        return FileHistoryKt.firstNotNull($receiver, mapping);
    }

    static {
        HashingStrategy hashingStrategy = ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY;
        Intrinsics.checkNotNullExpressionValue((Object)hashingStrategy, (String)"CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY");
        FILE_PATH_HASHING_STRATEGY = hashingStrategy;
    }
}

