/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesKt;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.editor.DefaultVcsLogFile;
import com.intellij.vcs.log.ui.editor.VcsLogVirtualFileSystem;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ-\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0012H\u0002J*\u0010$\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\fH\u0002J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020 0'2\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;Lcom/intellij/vcs/log/impl/VcsLogManager;)V", "futureToolWindow", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/wm/ToolWindow;", "filesListenerInstalled", "", "toolWindowListenerInstalled", "isDisposed", "createTabs", "", "dispose", "toolWindowShown", "toolWindow", "openAnotherLogTab", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "location", "Lcom/intellij/vcs/log/impl/VcsLogTabLocation;", "openEditorLogTab", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "tabId", "", "focus", "(Ljava/lang/String;ZLcom/intellij/vcs/log/VcsLogFilterCollection;)[Lcom/intellij/openapi/fileEditor/FileEditor;", "installFilesListener", "openToolWindowLogTab", "installContentListener", "getTabs", "", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n507#2,7:174\n507#2,7:181\n507#2,7:192\n193#3,3:188\n1#4:191\n1915#5,2:199\n1915#5,2:201\n*S KotlinDebug\n*F\n+ 1 VcsLogTabsManager.kt\ncom/intellij/vcs/log/impl/VcsLogTabsManager\n*L\n43#1:174,7\n44#1:181,7\n160#1:192,7\n46#1:188,3\n54#1:199,2\n62#1:201,2\n*E\n"})
public final class VcsLogTabsManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogProjectTabsProperties uiProperties;
    @NotNull
    private final VcsLogManager logManager;
    @NotNull
    private final CompletableFuture<ToolWindow> futureToolWindow;
    private boolean filesListenerInstalled;
    private boolean toolWindowListenerInstalled;
    private boolean isDisposed;
    @NotNull
    private static final Logger LOG;

    public VcsLogTabsManager(@NotNull Project project, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull VcsLogManager logManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter((Object)logManager, (String)"logManager");
        this.project = project;
        this.uiProperties = uiProperties;
        this.logManager = logManager;
        this.futureToolWindow = new CompletableFuture();
    }

    public final void createTabs() {
        boolean bl;
        Set toolWindowTabs;
        Set editorTabs;
        block9: {
            Map<String, VcsLogTabLocation> savedTabs = this.uiProperties.getTabs();
            if (savedTabs.isEmpty()) {
                return;
            }
            Map<String, VcsLogTabLocation> $this$filterValues$iv = savedTabs;
            boolean $i$f$filterValues = false;
            LinkedHashMap<String, VcsLogTabLocation> result$iv = new LinkedHashMap<String, VcsLogTabLocation>();
            for (Map.Entry<String, VcsLogTabLocation> entry : $this$filterValues$iv.entrySet()) {
                VcsLogTabLocation vcsLogTabLocation = entry.getValue();
                boolean bl2 = false;
                if (!(vcsLogTabLocation == VcsLogTabLocation.EDITOR)) continue;
                result$iv.put(entry.getKey(), entry.getValue());
            }
            editorTabs = ((Map)result$iv).keySet();
            Map<String, VcsLogTabLocation> $this$filterValues$iv2 = savedTabs;
            boolean $i$f$filterValues2 = false;
            LinkedHashMap<String, VcsLogTabLocation> result$iv2 = new LinkedHashMap<String, VcsLogTabLocation>();
            for (Map.Entry<String, VcsLogTabLocation> entry : $this$filterValues$iv2.entrySet()) {
                VcsLogTabLocation it2 = entry.getValue();
                boolean bl3 = false;
                if (!(it2 == VcsLogTabLocation.TOOL_WINDOW)) continue;
                result$iv2.put(entry.getKey(), entry.getValue());
            }
            toolWindowTabs = ((Map)result$iv2).keySet();
            Map<String, VcsLogTabLocation> $this$any$iv = savedTabs;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, VcsLogTabLocation>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, VcsLogTabLocation> entry;
                    Map.Entry<String, VcsLogTabLocation> entry2 = entry = iterator.next();
                    boolean bl4 = false;
                    if (!(entry2.getValue() == VcsLogTabLocation.STANDALONE)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            LOG.warn("Reopening standalone tabs is not supported");
        }
        if (!((Collection)editorTabs).isEmpty()) {
            ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), () -> VcsLogTabsManager.createTabs$lambda$3(this, editorTabs));
        }
        if (!((Collection)toolWindowTabs).isEmpty()) {
            this.futureToolWindow.thenAccept(arg_0 -> VcsLogTabsManager.createTabs$lambda$5(arg_0 -> VcsLogTabsManager.createTabs$lambda$4(this, toolWindowTabs, arg_0), arg_0));
        }
        ToolWindowManager.Companion.getInstance(this.project).invokeLater(() -> VcsLogTabsManager.createTabs$lambda$6(this));
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public final void toolWindowShown(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.futureToolWindow.complete(toolWindow);
    }

    @NotNull
    public final MainVcsLogUi openAnotherLogTab(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogTabLocation location) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        if (!(!this.isDisposed)) {
            boolean $i$a$-require-VcsLogTabsManager$openAnotherLogTab$22 = false;
            String $i$a$-require-VcsLogTabsManager$openAnotherLogTab$22 = "Already disposed";
            throw new IllegalArgumentException($i$a$-require-VcsLogTabsManager$openAnotherLogTab$22.toString());
        }
        String tabId = this.logManager.generateNewLogId();
        this.uiProperties.resetState(tabId);
        if (location == VcsLogTabLocation.EDITOR) {
            FileEditor[] editors = this.openEditorLogTab(tabId, true, filters);
            MainVcsLogUi mainVcsLogUi = VcsLogEditorUtil.findVcsLogUi(editors, MainVcsLogUi.class);
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            return mainVcsLogUi;
        }
        if (location == VcsLogTabLocation.TOOL_WINDOW) {
            ToolWindow toolWindow = VcsLogContentUtil.INSTANCE.getToolWindowOrThrow$intellij_platform_vcs_log_impl(this.project);
            this.futureToolWindow.complete(toolWindow);
            return this.openToolWindowLogTab(toolWindow, tabId, true, filters);
        }
        throw new UnsupportedOperationException("Only log in editor or tool window is supported");
    }

    private final FileEditor[] openEditorLogTab(String tabId, boolean focus, VcsLogFilterCollection filters) {
        VirtualFile file = VcsLogVirtualFileSystem.Holder.getInstance().createVcsLogFile(this.project, tabId, filters);
        this.installFilesListener();
        this.uiProperties.addTab(tabId, VcsLogTabLocation.EDITOR);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).openFile(file, focus, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        return fileEditorArray;
    }

    private final void installFilesListener() {
        if (this.filesListenerInstalled) {
            return;
        }
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ VcsLogTabsManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileClosed(FileEditorManager source, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!(file instanceof DefaultVcsLogFile)) {
                    return;
                }
                if (VcsLogTabsManager.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                VcsLogTabsManager.access$getUiProperties$p(this.this$0).removeTab(((DefaultVcsLogFile)file).getTabId$intellij_platform_vcs_log_impl());
            }
        });
        this.filesListenerInstalled = true;
    }

    private final MainVcsLogUi openToolWindowLogTab(ToolWindow toolWindow, String tabId, boolean focus, VcsLogFilterCollection filters) {
        MainVcsLogUi ui = this.logManager.createLogUi(tabId, filters);
        VcsLogContentUtil.INSTANCE.openLogTab$intellij_platform_vcs_log_impl(this.logManager, toolWindow, VcsLogContentUtil.INSTANCE.getDEFAULT_TAB_GROUP_ID(), (VcsLogUiEx)ui, VcsLogTabsManager::openToolWindowLogTab$lambda$0, focus);
        Companion.onDisplayNameChange(ui, (Function0<Unit>)((Function0)() -> VcsLogTabsManager.openToolWindowLogTab$lambda$1(this, ui)));
        this.installContentListener(toolWindow);
        this.uiProperties.addTab(tabId, VcsLogTabLocation.TOOL_WINDOW);
        return ui;
    }

    private final void installContentListener(ToolWindow toolWindow) {
        if (this.toolWindowListenerInstalled) {
            return;
        }
        ContentManagerListener listener2 = new ContentManagerListener(this){
            final /* synthetic */ VcsLogTabsManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (VcsLogTabsManager.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                String id = VcsLogContentUtil.INSTANCE.getId$intellij_platform_vcs_log_impl(content);
                if (id != null) {
                    VcsLogTabsManager.access$getUiProperties$p(this.this$0).removeTab(id);
                }
            }
        };
        toolWindow.addContentManagerListener(listener2);
        Disposer.register((Disposable)this, () -> VcsLogTabsManager.installContentListener$lambda$0(toolWindow, listener2));
        this.toolWindowListenerInstalled = true;
    }

    @NotNull
    public final Set<String> getTabs() {
        return this.uiProperties.getTabs().keySet();
    }

    @NotNull
    public final Set<String> getTabs(@NotNull VcsLogTabLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        Map<String, VcsLogTabLocation> $this$filterValues$iv = this.uiProperties.getTabs();
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, VcsLogTabLocation> result$iv = new LinkedHashMap<String, VcsLogTabLocation>();
        for (Map.Entry<String, VcsLogTabLocation> entry$iv : $this$filterValues$iv.entrySet()) {
            VcsLogTabLocation it = entry$iv.getValue();
            boolean bl = false;
            if (!(it == location)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    private static final Unit createTabs$lambda$3(VcsLogTabsManager this$0, Set $editorTabs) {
        if (this$0.logManager.isDisposed()) {
            return Unit.INSTANCE;
        }
        LOG.debug("Reopening editor tabs with ids: " + $editorTabs);
        Iterable $this$forEach$iv = $editorTabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this$0.openEditorLogTab(it, false, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTabs$lambda$4(VcsLogTabsManager this$0, Set $toolWindowTabs, ToolWindow toolWindow) {
        if (!LOG.assertTrue(!this$0.logManager.isDisposed(), (Object)"Attempting to open tabs on disposed VcsLogManager")) {
            return Unit.INSTANCE;
        }
        LOG.debug("Reopening toolwindow tabs with ids: " + $toolWindowTabs);
        Iterable $this$forEach$iv = $toolWindowTabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)toolWindow);
            this$0.openToolWindowLogTab(toolWindow, it, false, null);
        }
        return Unit.INSTANCE;
    }

    private static final void createTabs$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void createTabs$lambda$6(VcsLogTabsManager this$0) {
        if (this$0.logManager.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = VcsLogContentUtil.INSTANCE.getToolWindow$intellij_platform_vcs_log_impl(this$0.project);
        if (toolWindow == null) {
            VcsLogTabsManager $this$createTabs_u24lambda_u246_u240 = this$0;
            boolean bl = false;
            LOG.error("Could not find tool window by id Version Control");
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2.isVisible()) {
            this$0.futureToolWindow.complete(toolWindow2);
        }
    }

    private static final String openToolWindowLogTab$lambda$0(MainVcsLogUi it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VcsLogTabsUtil.INSTANCE.generateShortDisplayName(it);
    }

    private static final Unit openToolWindowLogTab$lambda$1(VcsLogTabsManager this$0, MainVcsLogUi $ui) {
        VcsLogContentUtil.updateLogUiName(this$0.project, $ui);
        return Unit.INSTANCE;
    }

    private static final void installContentListener$lambda$0(ToolWindow $toolWindow, installContentListener.listener.1 $listener) {
        block1: {
            if ($toolWindow.isDisposed()) break block1;
            ContentManager contentManager = $toolWindow.getContentManagerIfCreated();
            if (contentManager != null) {
                contentManager.removeContentManagerListener((ContentManagerListener)$listener);
            }
        }
    }

    public static final /* synthetic */ Project access$getProject$p(VcsLogTabsManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ VcsLogProjectTabsProperties access$getUiProperties$p(VcsLogTabsManager $this) {
        return $this.uiProperties;
    }

    static {
        Logger logger = Logger.getInstance(VcsLogTabsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "onDisplayNameChange", "", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "block", "Lkotlin/Function0;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void onDisplayNameChange(@NotNull MainVcsLogUi $this$onDisplayNameChange, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)$this$onDisplayNameChange, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            $this$onDisplayNameChange.getFilterUi().addFilterListener(() -> Companion.onDisplayNameChange$lambda$0(block));
            MainVcsLogUiProperties mainVcsLogUiProperties = $this$onDisplayNameChange.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUiProperties, (String)"getProperties(...)");
            VcsLogUiPropertiesKt.onPropertyChange(mainVcsLogUiProperties, $this$onDisplayNameChange, arg_0 -> Companion.onDisplayNameChange$lambda$1(block, arg_0));
        }

        private static final void onDisplayNameChange$lambda$0(Function0 $block) {
            $block.invoke();
        }

        private static final Unit onDisplayNameChange$lambda$1(Function0 $block, VcsLogUiProperties.VcsLogUiProperty it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (Intrinsics.areEqual((Object)it, MainVcsLogUiProperties.GRAPH_OPTIONS)) {
                $block.invoke();
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

