/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/render/GraphCommitCellUtil;", "", "<init>", "()V", "MAX_GRAPH_WIDTH", "", "getGraphWidth", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "printElements", "", "Lcom/intellij/vcs/log/graph/PrintElement;", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class GraphCommitCellUtil {
    @NotNull
    public static final GraphCommitCellUtil INSTANCE = new GraphCommitCellUtil();
    private static final int MAX_GRAPH_WIDTH = 6;

    private GraphCommitCellUtil() {
    }

    @JvmStatic
    public static final int getGraphWidth(@NotNull VcsLogGraphTable table, @NotNull Collection<? extends PrintElement> printElements) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(printElements, (String)"printElements");
        if (printElements.isEmpty()) {
            return 0;
        }
        double maxIndex = 0.0;
        for (PrintElement printElement : printElements) {
            maxIndex = Math.max(maxIndex, (double)printElement.getPositionInCurrentRow());
            if (!(printElement instanceof EdgePrintElement)) continue;
            maxIndex = Math.max(maxIndex, (double)(printElement.getPositionInCurrentRow() + ((EdgePrintElement)printElement).getPositionInOtherRow()) / 2.0);
        }
        double d = maxIndex;
        maxIndex = d + 1.0;
        maxIndex = Math.max(maxIndex, Math.min(6.0, (double)table.getVisibleGraph().getRecommendedWidth()));
        return (int)(maxIndex * PaintParameters.getElementWidth(table.getRowHeight()));
    }
}

