/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.column;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesKt;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.VcsLogBookmarkReferenceProvider;
import com.intellij.vcs.log.ui.VcsLogBookmarksListener;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogGraphTableUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import com.intellij.vcs.log.ui.table.column.VcsLogMetadataColumn;
import com.intellij.vcs.log.ui.table.links.CommitLinksResolveListener;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\u0018\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/ui/table/column/Commit;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogDefaultColumn;", "Lcom/intellij/vcs/log/ui/render/GraphCommitCell;", "Lcom/intellij/vcs/log/ui/table/column/VcsLogMetadataColumn;", "<init>", "()V", "getValue", "model", "Lcom/intellij/vcs/log/ui/table/GraphTableModel;", "row", "", "Lcom/intellij/vcs/log/ui/table/VcsLogTableIndex;", "", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "createTableCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "getStubValue", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogDefaultColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogDefaultColumn.kt\ncom/intellij/vcs/log/ui/table/column/Commit\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,224:1\n42#2,3:225\n*S KotlinDebug\n*F\n+ 1 VcsLogDefaultColumn.kt\ncom/intellij/vcs/log/ui/table/column/Commit\n*L\n102#1:225,3\n*E\n"})
public final class Commit
extends VcsLogDefaultColumn<GraphCommitCell>
implements VcsLogMetadataColumn {
    @NotNull
    public static final Commit INSTANCE = new Commit();

    private Commit() {
        String string = VcsLogBundle.message("vcs.log.column.subject", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super("Default.Subject", string, false, null);
    }

    @Override
    @Nullable
    public GraphCommitCell getValue(@NotNull GraphTableModel model, int row) {
        List<VcsBookmarkRef> list;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Collection<PrintElement> printElements = model.getPrintElements(row);
        VcsCommitMetadata vcsCommitMetadata = model.getCommitMetadata(row, true);
        if (vcsCommitMetadata == null) {
            return null;
        }
        VcsCommitMetadata metadata = vcsCommitMetadata;
        CommitId commitId = VcsLogGraphTableUtilKt.getKnownCommitId(metadata);
        String string = this.getValue(model, metadata);
        Collection collection = model.getRefsAtRow(row);
        if (!(metadata instanceof LoadingDetails)) {
            Project project = model.getLogData().getProject();
            Object object = metadata.getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
            Hash hash = (Hash)object;
            VirtualFile virtualFile = metadata.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            list = VcsLogBookmarkReferenceProvider.Companion.getBookmarkRefs(project, hash, virtualFile);
        } else {
            list = CollectionsKt.emptyList();
        }
        return new GraphCommitCell.RealCommit(commitId, string, collection, (Collection<VcsBookmarkRef>)list, printElements, metadata instanceof LoadingDetails);
    }

    @Override
    @NotNull
    public String getValue(@NotNull GraphTableModel model, @NotNull VcsCommitMetadata commit) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        String string = commit.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
        return string;
    }

    @Override
    @NotNull
    public TableCellRenderer createTableCellRenderer(@NotNull VcsLogGraphTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        boolean $i$f$service = false;
        Class<DefaultColorGenerator> serviceClass$iv = DefaultColorGenerator.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        DefaultColorGenerator defaultColorGenerator = (DefaultColorGenerator)object;
        GraphCellPainter graphCellPainter2 = new SimpleGraphCellPainter(table, defaultColorGenerator){
            final /* synthetic */ VcsLogGraphTable $table;
            {
                this.$table = $table;
                super($super_call_param$1);
            }

            protected int getRowHeight() {
                return this.$table.getRowHeight();
            }
        };
        VcsLogData vcsLogData = table.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getLogData(...)");
        GraphCommitCellRenderer commitCellRenderer = new GraphCommitCellRenderer(vcsLogData, graphCellPainter2, table);
        VcsLogUiProperties vcsLogUiProperties = table.getProperties();
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.COMPACT_REFERENCES_VIEW;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"COMPACT_REFERENCES_VIEW");
        Boolean bl = vcsLogUiProperties.get(vcsLogUiProperty);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        commitCellRenderer.setCompactReferencesView(bl);
        VcsLogUiProperties vcsLogUiProperties2 = table.getProperties();
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = CommonUiProperties.SHOW_TAG_NAMES;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"SHOW_TAG_NAMES");
        Boolean bl2 = vcsLogUiProperties2.get(vcsLogUiProperty2);
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get(...)");
        commitCellRenderer.setShowTagsNames(bl2);
        VcsLogUiProperties vcsLogUiProperties3 = table.getProperties();
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty3 = CommonUiProperties.LABELS_LEFT_ALIGNED;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty3, (String)"LABELS_LEFT_ALIGNED");
        Boolean bl3 = vcsLogUiProperties3.get(vcsLogUiProperty3);
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"get(...)");
        commitCellRenderer.setLeftAligned(bl3);
        VcsLogUiProperties vcsLogUiProperties4 = table.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiProperties4, (String)"getProperties(...)");
        VcsLogUiPropertiesKt.onPropertyChange(vcsLogUiProperties4, table, arg_0 -> Commit.createTableCellRenderer$lambda$0(commitCellRenderer, table, arg_0));
        VcsLogDefaultColumnKt.access$updateTableOnCommitDetailsLoaded(this, table);
        table.getLogData().getProject().getMessageBus().connect((Disposable)table).subscribe(VcsLogBookmarksListener.TOPIC, (Object)new VcsLogBookmarksListener(table){
            final /* synthetic */ VcsLogGraphTable $table;
            {
                this.$table = $table;
            }

            public void logBookmarksChanged() {
                this.$table.repaint();
            }
        });
        table.getLogData().getProject().getMessageBus().connect((Disposable)table).subscribe(CommitLinksResolveListener.TOPIC, arg_0 -> Commit.createTableCellRenderer$lambda$1(table, arg_0));
        return commitCellRenderer;
    }

    @Override
    @NotNull
    public GraphCommitCell getStubValue(@NotNull GraphTableModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return new GraphCommitCell.RealCommit(null, "", CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), true);
    }

    private static final Unit createTableCellRenderer$lambda$0(GraphCommitCellRenderer $commitCellRenderer, VcsLogGraphTable $table, VcsLogUiProperties.VcsLogUiProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (Intrinsics.areEqual(CommonUiProperties.COMPACT_REFERENCES_VIEW, (Object)property)) {
            VcsLogUiProperties vcsLogUiProperties = $table.getProperties();
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.COMPACT_REFERENCES_VIEW;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"COMPACT_REFERENCES_VIEW");
            Boolean bl = vcsLogUiProperties.get(vcsLogUiProperty);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            $commitCellRenderer.setCompactReferencesView(bl);
            $table.repaint();
        } else if (Intrinsics.areEqual(CommonUiProperties.SHOW_TAG_NAMES, (Object)property)) {
            VcsLogUiProperties vcsLogUiProperties = $table.getProperties();
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.SHOW_TAG_NAMES;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_TAG_NAMES");
            Boolean bl = vcsLogUiProperties.get(vcsLogUiProperty);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            $commitCellRenderer.setShowTagsNames(bl);
            $table.repaint();
        } else if (Intrinsics.areEqual(CommonUiProperties.LABELS_LEFT_ALIGNED, (Object)property)) {
            VcsLogUiProperties vcsLogUiProperties = $table.getProperties();
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.LABELS_LEFT_ALIGNED;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"LABELS_LEFT_ALIGNED");
            Boolean bl = vcsLogUiProperties.get(vcsLogUiProperty);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            $commitCellRenderer.setLeftAligned(bl);
            $table.repaint();
        }
        return Unit.INSTANCE;
    }

    private static final void createTableCellRenderer$lambda$1(VcsLogGraphTable $table, String logId) {
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        if (Intrinsics.areEqual((Object)logId, (Object)$table.getId())) {
            $table.repaint();
        }
    }
}

