/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogParentFilter;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0012*\n\u0012\u0004\u0012\u0002H\u0012\u0018\u00010\u0013H\u0000\u001a\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0000\u001a\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "areFiltersAffectedByIndexing", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "matches", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "node", "", "filter", "Lcom/intellij/vcs/log/VcsLogParentFilter;", "matchesNothing", "T", "", "union", "Lit/unimi/dsi/fastutil/ints/IntSet;", "c1", "c2", "recordError", "", "Lio/opentelemetry/api/trace/Span;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.platform.vcs.log.impl"})
public final class VcsLogFiltererImplKt {
    @NotNull
    private static final Logger LOG;

    public static final boolean areFiltersAffectedByIndexing(@NotNull VcsLogFilterCollection filters, @NotNull List<? extends VirtualFile> roots) {
        boolean needsIndex;
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        List list = filters.getDetailsFilters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDetailsFilters(...)");
        List detailsFilters = list;
        if (detailsFilters.isEmpty()) {
            return false;
        }
        Set<VirtualFile> set = VcsLogUtil.getAllVisibleRoots((Collection<VirtualFile>)roots, filters);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllVisibleRoots(...)");
        Set<VirtualFile> affectedRoots = set;
        boolean bl = needsIndex = !((Collection)affectedRoots).isEmpty();
        if (needsIndex) {
            LOG.debug(filters + " are affected by indexing of " + affectedRoots);
        }
        return needsIndex;
    }

    private static final boolean matches(LinearGraph linearGraph, int node, VcsLogParentFilter filter) {
        int parentsCount = linearGraph.getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN).size();
        int n = filter.getMinParents();
        return parentsCount <= filter.getMaxParents() ? n <= parentsCount : false;
    }

    public static final <T> boolean matchesNothing(@Nullable Collection<? extends T> $this$matchesNothing) {
        return $this$matchesNothing != null && $this$matchesNothing.isEmpty();
    }

    @Nullable
    public static final IntSet union(@Nullable IntSet c1, @Nullable IntSet c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        IntOpenHashSet result = new IntOpenHashSet((IntCollection)c1);
        result.addAll((IntCollection)c2);
        return (IntSet)result;
    }

    public static final void recordError(@NotNull Span $this$recordError, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)$this$recordError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $this$recordError.recordException((Throwable)e);
        $this$recordError.setStatus(StatusCode.ERROR);
    }

    public static final /* synthetic */ boolean access$matches(LinearGraph linearGraph, int node, VcsLogParentFilter filter) {
        return VcsLogFiltererImplKt.matches(linearGraph, node, filter);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(VcsLogFiltererImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

