/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.sql.backend.run;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.util.Out;
import com.intellij.dataspell.jupyter.customCells.sql.backend.run.Chunk;
import com.intellij.dataspell.jupyter.customCells.sql.backend.run.PandasDataFrame;
import com.intellij.dataspell.jupyter.customCells.sql.backend.run.PartNumber;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u0013\u001a\u00020\u00142\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0015\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u00020\u00142\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0015\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J,\u0010\u001f\u001a\u00020\u001e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u001eH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/sql/backend/run/JupyterDataFrameSplitter;", "", "minimalRowsCount", "", "thresholdByteSize", "extractor", "Lcom/intellij/database/extractors/FormatBasedExtractor;", "<init>", "(IILcom/intellij/database/extractors/FormatBasedExtractor;)V", "unprocessedRows", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/database/datagrid/GridRow;", "columns", "", "Lcom/intellij/database/datagrid/GridColumn;", "myPrevValidChunk", "Lcom/intellij/dataspell/jupyter/customCells/sql/backend/run/Chunk;", "partNumber", "Lcom/intellij/dataspell/jupyter/customCells/sql/backend/run/PartNumber;", "setColumns", "", "", "([Lcom/intellij/database/datagrid/GridColumn;)V", "updateColumns", "addRows", "rows", "", "makeChunk", "rowsCount", "makeEmptyDataFrame", "Lcom/intellij/dataspell/jupyter/customCells/sql/backend/run/PandasDataFrame;", "makeDataFrame", "consumePrevValidChunk", "tryConsumeChunk", "isLastCall", "", "makeChunks", "intellij.dataspell.jupyter.customCells.sql.backend"})
public final class JupyterDataFrameSplitter {
    private final int minimalRowsCount;
    private final int thresholdByteSize;
    @NotNull
    private final FormatBasedExtractor extractor;
    @NotNull
    private final ArrayDeque<GridRow> unprocessedRows;
    @NotNull
    private final List<GridColumn> columns;
    @Nullable
    private Chunk myPrevValidChunk;
    @NotNull
    private PartNumber partNumber;

    public JupyterDataFrameSplitter(int minimalRowsCount, int thresholdByteSize, @NotNull FormatBasedExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        this.minimalRowsCount = minimalRowsCount;
        this.thresholdByteSize = thresholdByteSize;
        this.extractor = extractor;
        this.unprocessedRows = new ArrayDeque();
        this.columns = new ArrayList();
        this.partNumber = new PartNumber(-1, 0);
    }

    public final void setColumns(@NotNull GridColumn[] columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        this.updateColumns(columns);
        this.partNumber = this.partNumber.forNewTable();
    }

    public final void updateColumns(@NotNull GridColumn[] columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        this.columns.clear();
        CollectionsKt.addAll((Collection)this.columns, (Object[])columns);
    }

    public final void addRows(@NotNull List<? extends GridRow> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this.unprocessedRows.addAll((Collection)rows);
    }

    private final Chunk makeChunk(int rowsCount) {
        if (!(rowsCount > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!((Collection)this.unprocessedRows).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int validRowCount = Math.min(rowsCount, this.unprocessedRows.size());
        PandasDataFrame dataFrame = this.makeDataFrame(this.columns, this.unprocessedRows.subList(0, validRowCount), this.partNumber);
        return new Chunk(dataFrame, validRowCount);
    }

    private final PandasDataFrame makeEmptyDataFrame() {
        return this.makeDataFrame(this.columns, CollectionsKt.emptyList(), this.partNumber);
    }

    private final PandasDataFrame makeDataFrame(List<? extends GridColumn> columns, List<? extends GridRow> rows, PartNumber partNumber) {
        Out.Readable out = new Out.Readable();
        GridExtractorsUtilCore.extract((Out)((Out)out), columns, (DataExtractor)((DataExtractor)this.extractor), rows, (int[])new int[0]);
        byte[] bytes = out.toBytes();
        Intrinsics.checkNotNull((Object)bytes);
        return PandasDataFrame.Companion.fromUtf8byteArray(bytes, partNumber);
    }

    private final PandasDataFrame consumePrevValidChunk() {
        Chunk attempt = this.myPrevValidChunk;
        this.myPrevValidChunk = null;
        if (attempt == null) {
            return null;
        }
        this.unprocessedRows.subList(0, attempt.getConsumedRows()).clear();
        this.partNumber = attempt.getDataFramePart().getPartNumber().forNewPart();
        return attempt.getDataFramePart();
    }

    private final PandasDataFrame tryConsumeChunk(boolean isLastCall) {
        Chunk chunk;
        block9: {
            block10: {
                if (!isLastCall ? this.unprocessedRows.size() < this.minimalRowsCount : this.unprocessedRows.isEmpty()) {
                    return null;
                }
                if (this.myPrevValidChunk != null) break block9;
                Chunk chunk2 = this.myPrevValidChunk = this.makeChunk(this.minimalRowsCount);
                Intrinsics.checkNotNull((Object)chunk2);
                if (chunk2.getDataFramePart().getEstimatedByteSize() >= this.thresholdByteSize) break block10;
                if (!isLastCall) break block9;
                Chunk chunk3 = this.myPrevValidChunk;
                Intrinsics.checkNotNull((Object)chunk3);
                if (chunk3.getConsumedRows() != this.unprocessedRows.size()) break block9;
            }
            return this.consumePrevValidChunk();
        }
        if (!isLastCall) {
            while (true) {
                Chunk chunk4 = this.myPrevValidChunk;
                Intrinsics.checkNotNull((Object)chunk4);
                if (chunk4.getConsumedRows() * 2 > this.unprocessedRows.size()) break;
                Chunk chunk5 = this.myPrevValidChunk;
                Intrinsics.checkNotNull((Object)chunk5);
                Chunk newAttempt = this.makeChunk(chunk5.getConsumedRows() * 2);
                if (newAttempt.getDataFramePart().getEstimatedByteSize() >= this.thresholdByteSize) {
                    return this.consumePrevValidChunk();
                }
                this.myPrevValidChunk = newAttempt;
            }
            return null;
        }
        do {
            Chunk chunk6 = this.myPrevValidChunk;
            Intrinsics.checkNotNull((Object)chunk6);
            Chunk newAttempt = this.makeChunk(chunk6.getConsumedRows() * 2);
            if (newAttempt.getDataFramePart().getEstimatedByteSize() >= this.thresholdByteSize) {
                return this.consumePrevValidChunk();
            }
            chunk = this.myPrevValidChunk = newAttempt;
            Intrinsics.checkNotNull((Object)chunk);
        } while (chunk.getConsumedRows() != this.unprocessedRows.size());
        return this.consumePrevValidChunk();
    }

    @NotNull
    public final List<PandasDataFrame> makeChunks(boolean isLastCall) {
        PandasDataFrame chunk;
        SmartList result = new SmartList();
        while ((chunk = this.tryConsumeChunk(isLastCall)) != null) {
            result.add((Object)chunk);
        }
        if (isLastCall && result.isEmpty() && this.partNumber.getPartNo() == 0) {
            result.add((Object)this.makeEmptyDataFrame());
            this.partNumber = this.partNumber.forNewPart();
        }
        return (List)result;
    }
}

