/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.actions;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivitySelection;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.ChangeSetSelectionKt;
import com.intellij.platform.lvcs.impl.ui.ActivityViewDataKeys;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J8\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/lvcs/impl/actions/ChangeSetSelectionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "changeSetSelection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "actionPerformed", "project", "Lcom/intellij/openapi/project/Project;", "facade", "Lcom/intellij/history/core/LocalHistoryFacade;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "activityScope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "selection", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public abstract class ChangeSetSelectionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getProject() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ActivitySelection activitySelection = (ActivitySelection)e.getData(ActivityViewDataKeys.INSTANCE.getSELECTION());
        ActivityScope activityScope = (ActivityScope)e.getData(ActivityViewDataKeys.INSTANCE.getSCOPE());
        if (activityScope == null || activitySelection == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        ChangeSetSelection changeSetSelection = ChangeSetSelectionKt.toChangeSetSelection(activitySelection);
        e.getPresentation().setEnabled(changeSetSelection != null && this.isEnabled(changeSetSelection));
    }

    protected boolean isEnabled(@NotNull ChangeSetSelection changeSetSelection) {
        Intrinsics.checkNotNullParameter((Object)changeSetSelection, (String)"changeSetSelection");
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ActivityScope activityScope = (ActivityScope)e.getData(ActivityViewDataKeys.INSTANCE.getSCOPE());
        if (activityScope == null) {
            return;
        }
        ActivityScope activityScope2 = activityScope;
        ActivitySelection activitySelection = (ActivitySelection)e.getData(ActivityViewDataKeys.INSTANCE.getSELECTION());
        if (activitySelection == null) {
            return;
        }
        ActivitySelection activitySelection2 = activitySelection;
        LocalHistoryImpl localHistoryImpl = LocalHistoryImpl.Companion.getInstanceImpl();
        LocalHistoryFacade localHistoryFacade = localHistoryImpl.getFacade();
        if (localHistoryFacade == null) {
            return;
        }
        LocalHistoryFacade facade = localHistoryFacade;
        IdeaGateway gateway = localHistoryImpl.getGateway();
        ChangeSetSelection changeSetSelection = ChangeSetSelectionKt.toChangeSetSelection(activitySelection2);
        if (changeSetSelection == null) {
            return;
        }
        ChangeSetSelection selection = changeSetSelection;
        this.actionPerformed(project2, facade, gateway, activityScope2, selection, e);
    }

    public abstract void actionPerformed(@NotNull Project var1, @NotNull LocalHistoryFacade var2, @NotNull IdeaGateway var3, @NotNull ActivityScope var4, @NotNull ChangeSetSelection var5, @NotNull AnActionEvent var6);
}

