/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TargetElementUtilBase {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    @ApiStatus.Internal
    public static final LanguageExtension<TargetElementEvaluator> TARGET_ELEMENT_EVALUATOR = new LanguageExtension("com.intellij.targetElementEvaluator");

    public static int adjustOffset(@Nullable PsiFile file, @NotNull Document document, int offset) {
        char charAt;
        if (document == null) {
            TargetElementUtilBase.$$$reportNull$$$0(0);
        }
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = text.length();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!TargetElementUtilBase.isIdentifierPart(file, text, offset)) {
            --correctedOffset;
        }
        if (correctedOffset >= 0 && ((charAt = text.charAt(correctedOffset)) == '\'' || charAt == '\"' || charAt == ')' || charAt == ']' || TargetElementUtilBase.isIdentifierPart(file, text, correctedOffset))) {
            return correctedOffset;
        }
        return offset;
    }

    private static boolean isIdentifierPart(@Nullable PsiFile file, @NotNull CharSequence text, int offset) {
        TargetElementEvaluatorEx evaluator;
        if (text == null) {
            TargetElementUtilBase.$$$reportNull$$$0(1);
        }
        if (file != null && (evaluator = TargetElementUtilBase.getElementEvaluatorsEx(file.getLanguage())) != null && evaluator.isIdentifierPart(file, text, offset)) {
            return true;
        }
        return Character.isJavaIdentifierPart(text.charAt(offset));
    }

    @Nullable
    private static TargetElementEvaluatorEx getElementEvaluatorsEx(@NotNull Language language) {
        TargetElementEvaluatorEx target;
        TargetElementEvaluator result;
        if (language == null) {
            TargetElementUtilBase.$$$reportNull$$$0(2);
        }
        return (result = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language)) instanceof TargetElementEvaluatorEx ? (target = (TargetElementEvaluatorEx)result) : null;
    }

    @Nullable
    public static TargetElementEvaluatorEx2 getElementEvaluatorsEx2(@NotNull Language language) {
        TargetElementEvaluatorEx2 target;
        TargetElementEvaluator result;
        if (language == null) {
            TargetElementUtilBase.$$$reportNull$$$0(3);
        }
        return (result = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language)) instanceof TargetElementEvaluatorEx2 ? (target = (TargetElementEvaluatorEx2)result) : null;
    }

    @ApiStatus.Internal
    public static PsiElement getNamedElement(@Nullable PsiElement element) {
        PsiElement result;
        if (element == null) {
            return null;
        }
        TargetElementEvaluatorEx2 evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(element.getLanguage());
        if (evaluator != null && (result = evaluator.getNamedElement(element)) != null) {
            return result;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class, (boolean)false);
        if (parent != null && !(parent instanceof PsiFile) && parent.getTextOffset() == element.getTextRange().getStartOffset() && (evaluator == null || evaluator.isAcceptableNamedParent(parent))) {
            return parent;
        }
        return null;
    }

    public static PsiElement getNamedElement(@Nullable PsiElement element, int offsetInElement) {
        if (element == null) {
            return null;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        ArrayList targets = new ArrayList();
        Consumer consumer = target -> {
            if (target instanceof PsiDeclaredTarget) {
                PsiDeclaredTarget declaredTarget = (PsiDeclaredTarget)target;
                PsiElement navigationElement = declaredTarget.getNavigationElement();
                TextRange range = declaredTarget.getNameIdentifierRange();
                if (range != null && !range.shiftRight(navigationElement.getTextRange().getStartOffset()).contains(element.getTextRange().getStartOffset() + offsetInElement)) {
                    return;
                }
            }
            targets.add(target);
        };
        int offset = offsetInElement;
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
                searcher.findDeclarationsAt(parent, offset, consumer);
                if (targets.isEmpty()) continue;
                PomTarget target2 = (PomTarget)targets.get(0);
                return target2 == null ? null : PomService.convertToPsi((Project)element.getProject(), (PomTarget)target2);
            }
            offset += parent.getStartOffsetInParent();
        }
        return TargetElementUtilBase.getNamedElement(element);
    }

    @Nullable
    private static PsiElement doGetReferenceOrReferencedElement(@NotNull Editor editor, int flags, int offset) {
        PsiReference ref;
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(4);
        }
        if ((ref = TargetElementUtilBase.findReference(editor, offset)) == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        return TargetElementUtilBase.getReferencedElement(ref, flags);
    }

    @Nullable
    private static PsiElement getReferencedElement(@NotNull PsiReference ref, int flags) {
        PsiElement element;
        Language language;
        TargetElementEvaluator evaluator;
        if (ref == null) {
            TargetElementUtilBase.$$$reportNull$$$0(5);
        }
        if ((evaluator = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language = ref.getElement().getLanguage())) != null && (element = evaluator.getElementByReference(ref, flags)) != null) {
            return element;
        }
        return ref.resolve();
    }

    @Nullable
    public static PsiReference findReferenceWithoutExpectedCaret(@NotNull Editor editor) {
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(6);
        }
        int offset = editor.getCaretModel().getOffset();
        return TargetElementUtilBase.findReference(editor, offset);
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor, int offset) {
        Project project;
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(7);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        Document document = editor.getDocument();
        CodeInsightContext context = EditorContextManager.getEditorContext((Editor)editor, (Project)project);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document, context);
        if (file == null) {
            return null;
        }
        PsiReference ref = file.findReferenceAt(TargetElementUtilBase.adjustOffset(file, document, offset));
        if (ref == null) {
            return null;
        }
        int elementOffset = ref.getElement().getTextRange().getStartOffset();
        for (TextRange range : ReferenceRange.getRanges((PsiReference)ref)) {
            if (!range.shiftRight(elementOffset).containsOffset(offset)) continue;
            return ref;
        }
        return null;
    }

    @Nullable
    private static PsiElement getReferenceOrReferencedElement(@NotNull PsiFile file, @NotNull Editor editor, int flags, int offset) {
        if (file == null) {
            TargetElementUtilBase.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(9);
        }
        PsiElement result = TargetElementUtilBase.doGetReferenceOrReferencedElement(editor, flags, offset);
        PsiElement languageElement = file.findElementAt(offset);
        Language language = languageElement != null ? languageElement.getLanguage() : file.getLanguage();
        TargetElementEvaluatorEx2 evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(language);
        if (evaluator != null) {
            result = evaluator.adjustReferenceOrReferencedElement(file, editor, offset, flags, result);
        }
        return result;
    }

    @Nullable
    private static PsiElement doFindTargetElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement referencedElement;
        Project project;
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(10);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        Document document = editor.getDocument();
        CodeInsightContext context = EditorContextManager.getEditorContext((Editor)editor, (Project)project);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document, context);
        if (file == null) {
            return null;
        }
        int adjusted = TargetElementUtilBase.adjustOffset(file, document, offset);
        PsiElement element = file.findElementAt(adjusted);
        if (BitUtil.isSet((int)flags, (int)1) && (referencedElement = TargetElementUtilBase.getReferencedElement(file, offset, flags, editor, element)) != null) {
            return referencedElement;
        }
        if (element == null) {
            return null;
        }
        if (BitUtil.isSet((int)flags, (int)2)) {
            if (element instanceof PsiNamedElement) {
                return element;
            }
            return TargetElementUtilBase.getNamedElement(element, adjusted - element.getTextRange().getStartOffset());
        }
        return null;
    }

    @Nullable
    private static PsiElement getReferencedElement(@NotNull PsiFile file, int offset, int flags, @NotNull Editor editor, @Nullable PsiElement leafElement) {
        PsiElement referenceOrReferencedElement;
        if (file == null) {
            TargetElementUtilBase.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(12);
        }
        if (TargetElementUtilBase.isAcceptableReferencedElement(leafElement, referenceOrReferencedElement = TargetElementUtilBase.getReferenceOrReferencedElement(file, editor, flags, offset))) {
            return referenceOrReferencedElement;
        }
        return null;
    }

    private static boolean isAcceptableReferencedElement(@Nullable PsiElement element, @Nullable PsiElement referenceOrReferencedElement) {
        TargetElementEvaluatorEx2 evaluator;
        if (referenceOrReferencedElement == null || !referenceOrReferencedElement.isValid()) {
            return false;
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = element == null ? null : TargetElementUtilBase.getElementEvaluatorsEx2(element.getLanguage());
        if (evaluator != null) {
            ThreeState answer = evaluator.isAcceptableReferencedElement(element, referenceOrReferencedElement);
            if (answer == ThreeState.YES) {
                return true;
            }
            if (answer == ThreeState.NO) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiElement findTargetElement(@NotNull Editor editor, int flags) {
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(13);
        }
        int offset = editor.getCaretModel().getOffset();
        return TargetElementUtilBase.findTargetElement(editor, flags, offset);
    }

    @Nullable
    public static PsiElement findTargetElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement result;
        TargetElementEvaluatorEx2 evaluator;
        if (editor == null) {
            TargetElementUtilBase.$$$reportNull$$$0(14);
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = (result = TargetElementUtilBase.doFindTargetElement(editor, flags, offset)) != null ? TargetElementUtilBase.getElementEvaluatorsEx2(result.getLanguage()) : null;
        if (evaluator != null) {
            result = evaluator.adjustTargetElement(editor, offset, flags, result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/TargetElementUtilBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifierPart";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementEvaluatorsEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementEvaluatorsEx2";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetReferenceOrReferencedElement";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencedElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferenceWithoutExpectedCaret";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findReference";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceOrReferencedElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doFindTargetElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

