/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.StatisticsComparable;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class StatisticsWeigher
extends CompletionWeigher {
    private static final Key<StatisticsInfo> BASE_STATISTICS_INFO = Key.create((String)"Base statistics info");

    public Comparable<?> weigh(@NotNull LookupElement item, @NotNull CompletionLocation location) {
        if (item == null) {
            StatisticsWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            StatisticsWeigher.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    public static void clearBaseStatisticsInfo(@NotNull LookupElement item) {
        if (item == null) {
            StatisticsWeigher.$$$reportNull$$$0(2);
        }
        item.putUserData(BASE_STATISTICS_INFO, null);
    }

    @NotNull
    public static StatisticsInfo getBaseStatisticsInfo(@NotNull LookupElement item, @Nullable CompletionLocation location) {
        StatisticsInfo info;
        if (item == null) {
            StatisticsWeigher.$$$reportNull$$$0(3);
        }
        if ((info = (StatisticsInfo)BASE_STATISTICS_INFO.get((UserDataHolder)item)) == null) {
            if (location == null) {
                StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
                if (statisticsInfo == null) {
                    StatisticsWeigher.$$$reportNull$$$0(4);
                }
                return statisticsInfo;
            }
            info = StatisticsWeigher.calcBaseInfo(item, location);
            BASE_STATISTICS_INFO.set((UserDataHolder)item, (Object)info);
        }
        StatisticsInfo statisticsInfo = info;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(5);
        }
        return statisticsInfo;
    }

    @NotNull
    private static StatisticsInfo calcBaseInfo(@NotNull LookupElement item, @NotNull CompletionLocation location) {
        StatisticsInfo info;
        if (item == null) {
            StatisticsWeigher.$$$reportNull$$$0(6);
        }
        if (location == null) {
            StatisticsWeigher.$$$reportNull$$$0(7);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !location.getCompletionParameters().isTestingMode()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        StatisticsInfo statisticsInfo = (info = StatisticsManager.serialize((Key)CompletionService.STATISTICS_KEY, (Object)item, (Object)location)) == null ? StatisticsInfo.EMPTY : info;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(8);
        }
        return statisticsInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseStatisticsInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBaseInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearBaseStatisticsInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBaseStatisticsInfo";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcBaseInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8 -> new IllegalStateException(string);
        };
    }

    public static class LookupStatisticsWeigher
    extends Classifier<LookupElement> {
        @NotNull
        private final CompletionLocation myLocation;
        private final Map<LookupElement, StatisticsComparable> myWeights;
        private final Set<String> myStringsWithWeights;
        private final Set<LookupElement> myNoStats;
        private final List<Function<@NotNull LookupElement, @Nullable StatisticsInfo>> mySerializers;

        public LookupStatisticsWeigher(@NotNull CompletionLocation location, @Nullable Classifier<LookupElement> next) {
            if (location == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(0);
            }
            super(next, "stats");
            this.myWeights = new IdentityHashMap<LookupElement, StatisticsComparable>();
            this.myStringsWithWeights = CollectionFactory.createSmallMemoryFootprintSet();
            this.myNoStats = new ReferenceOpenHashSet();
            this.myLocation = location;
            this.mySerializers = ContainerUtil.map((Collection)StatisticsManager.COLLECTOR.forKey((Object)CompletionService.STATISTICS_KEY), stat -> ((CompletionStatistician)stat).forLocation(this.myLocation));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(1);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(2);
            }
            StatisticsInfo baseInfo = this.getBaseStatisticsInfo(element);
            int weight = LookupStatisticsWeigher.weigh(baseInfo);
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                if (weight != 0) {
                    this.myWeights.put(element, new StatisticsComparable(weight, baseInfo));
                    this.myStringsWithWeights.add(element.getLookupString());
                }
                if (baseInfo == StatisticsInfo.EMPTY) {
                    this.myNoStats.add(element);
                }
            }
            super.addElement(element, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
            Collection byWeight;
            List<LookupElement> initialList;
            if (source == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(3);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(4);
            }
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                initialList = this.getInitialNoStatElements(source, context);
                Iterable<LookupElement> rest = LookupStatisticsWeigher.withoutInitial(source, initialList);
                byWeight = this.buildMapByWeight(rest).descendingMap().values();
            }
            JBIterable jBIterable = JBIterable.from(initialList).append((Iterable)JBIterable.from(byWeight).flatten(group -> this.myNext.classify(group, context)));
            if (jBIterable == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @NotNull
        private static Iterable<LookupElement> withoutInitial(@NotNull Iterable<? extends LookupElement> allItems, @NotNull List<? extends LookupElement> initial) {
            if (allItems == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(6);
            }
            if (initial == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(7);
            }
            ReferenceOpenHashSet initialSet = new ReferenceOpenHashSet(initial);
            JBIterable jBIterable = JBIterable.from(allItems).filter(arg_0 -> LookupStatisticsWeigher.lambda$withoutInitial$2((Set)initialSet, arg_0));
            if (jBIterable == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }

        @NotNull
        private List<LookupElement> getInitialNoStatElements(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
            if (source == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(9);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(10);
            }
            ArrayList<LookupElement> initialList = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : this.myNext.classify(source, context)) {
                if (!this.myNoStats.contains(lookupElement)) break;
                initialList.add(lookupElement);
            }
            ArrayList<LookupElement> arrayList = initialList;
            if (arrayList == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        @NotNull
        private TreeMap<Integer, List<LookupElement>> buildMapByWeight(@NotNull Iterable<? extends LookupElement> source) {
            if (source == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(12);
            }
            MultiMap byName = MultiMap.create();
            ArrayList<LookupElement> noStats = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : source) {
                String string = lookupElement.getLookupString();
                if (this.myStringsWithWeights.contains(string)) {
                    byName.putValue((Object)string, (Object)lookupElement);
                    continue;
                }
                noStats.add(lookupElement);
            }
            TreeMap<Integer, List<LookupElement>> map = new TreeMap<Integer, List<LookupElement>>();
            map.put(0, noStats);
            for (String s : byName.keySet()) {
                List group = (List)byName.get((Object)s);
                group.sort(Comparator.comparing(this::getScalarWeight).reversed());
                map.computeIfAbsent(this.getMaxWeight(group), __ -> new ArrayList()).addAll(group);
            }
            TreeMap<Integer, List<LookupElement>> treeMap = map;
            if (treeMap == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(13);
            }
            return treeMap;
        }

        private int getMaxWeight(@NotNull List<? extends LookupElement> group) {
            if (group == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(14);
            }
            int max = 0;
            for (int i = 0; i < group.size(); ++i) {
                max = Math.max(max, this.getScalarWeight(group.get(i)));
            }
            return max;
        }

        private int getScalarWeight(@NotNull LookupElement e) {
            StatisticsComparable comparable;
            if (e == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(15);
            }
            return (comparable = this.myWeights.get(e)) == null ? 0 : comparable.getScalar();
        }

        @NotNull
        private StatisticsComparable getWeight(@NotNull LookupElement t) {
            StatisticsComparable w;
            if (t == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(16);
            }
            if ((w = this.myWeights.get(t)) == null) {
                StatisticsInfo info = this.getBaseStatisticsInfo(t);
                w = new StatisticsComparable(LookupStatisticsWeigher.weigh(info), info);
                this.myWeights.put(t, w);
            }
            StatisticsComparable statisticsComparable = w;
            if (statisticsComparable == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(17);
            }
            return statisticsComparable;
        }

        private static int weigh(@NotNull StatisticsInfo baseInfo) {
            if (baseInfo == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(18);
            }
            if (baseInfo == StatisticsInfo.EMPTY) {
                return 0;
            }
            int minRecency = StatisticsManager.getInstance().getLastUseRecency(baseInfo);
            return minRecency == Integer.MAX_VALUE ? 0 : 10000 - minRecency;
        }

        @Override
        public @Unmodifiable @NotNull List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
            if (items == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(19);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(20);
            }
            List list = ContainerUtil.map(items, lookupElement -> new Pair(lookupElement, (Object)this.getWeight((LookupElement)lookupElement)));
            if (list == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(21);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(22);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(23);
            }
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                this.myWeights.remove(element);
                this.myNoStats.remove(element);
            }
            super.removeElement(element, context);
        }

        @NotNull
        private StatisticsInfo getBaseStatisticsInfo(@NotNull LookupElement item) {
            StatisticsInfo info;
            if (item == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(24);
            }
            if ((info = (StatisticsInfo)BASE_STATISTICS_INFO.get((UserDataHolder)item)) == null) {
                info = this.calcBaseInfo(item);
                BASE_STATISTICS_INFO.set((UserDataHolder)item, (Object)info);
            }
            StatisticsInfo statisticsInfo = info;
            if (statisticsInfo == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(25);
            }
            return statisticsInfo;
        }

        @NotNull
        private StatisticsInfo calcBaseInfo(@NotNull LookupElement item) {
            if (item == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(26);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myLocation.getCompletionParameters().isTestingMode()) {
                ApplicationManager.getApplication().assertIsNonDispatchThread();
            }
            for (Function<LookupElement, StatisticsInfo> serializer2 : this.mySerializers) {
                StatisticsInfo info = serializer2.apply(item);
                if (info == null) continue;
                StatisticsInfo statisticsInfo = info;
                if (statisticsInfo == null) {
                    LookupStatisticsWeigher.$$$reportNull$$$0(27);
                }
                return statisticsInfo;
            }
            StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
            if (statisticsInfo == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(28);
            }
            return statisticsInfo;
        }

        private static /* synthetic */ boolean lambda$withoutInitial$2(Set initialSet, LookupElement element) {
            return !initialSet.contains(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 8, 11, 13, 17, 21, 25, 27, 28 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 4: 
                case 10: 
                case 20: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: 
                case 8: 
                case 11: 
                case 13: 
                case 17: 
                case 21: 
                case 25: 
                case 27: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allItems";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initial";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseInfo";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 24: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classify";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withoutInitial";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialNoStatElements";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildMapByWeight";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWeight";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortingWeights";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseStatisticsInfo";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcBaseInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "classify";
                    break;
                }
                case 5: 
                case 8: 
                case 11: 
                case 13: 
                case 17: 
                case 21: 
                case 25: 
                case 27: 
                case 28: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withoutInitial";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialNoStatElements";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "buildMapByWeight";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaxWeight";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getScalarWeight";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getWeight";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortingWeights";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElement";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "getBaseStatisticsInfo";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "calcBaseInfo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 8, 11, 13, 17, 21, 25, 27, 28 -> new IllegalStateException(string);
            };
        }
    }
}

