/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.InjectedLanguageFragmentSyntaxUtil;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChameleonSyntaxHighlightingPass
extends ProgressableTextEditorHighlightingPass {
    @NotNull
    private final ProperTextRange myPriorityRange;
    private volatile List<HighlightInfo> myHighlights;

    private ChameleonSyntaxHighlightingPass(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull ProperTextRange restrictRange, @NotNull ProperTextRange priorityRange, @Nullable Editor editor) {
        if (psiFile == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(1);
        }
        if (restrictRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(2);
        }
        if (priorityRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(3);
        }
        super(psiFile.getProject(), document, AnalysisBundle.message((String)"pass.chameleon", (Object[])new Object[0]), psiFile, editor, (TextRange)restrictRange, false, HighlightInfoProcessor.getEmpty());
        this.myHighlights = List.of();
        this.myPriorityRange = priorityRange;
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list = this.myHighlights;
        if (list == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(5);
        }
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)this.myFile).filter(o -> {
            IElementType type = PsiUtilCore.getElementType((PsiElement)o);
            return type instanceof ILazyParseableElementType && !(type instanceof IFileElementType);
        });
        ArrayList lazyOutside = new ArrayList(100);
        ArrayList<PsiElement> lazyInside = new ArrayList<PsiElement>(100);
        for (PsiElement e : s) {
            (e.getTextRange().intersects((TextRange)this.myPriorityRange) ? lazyInside : lazyOutside).add(e);
        }
        HighlightInfoHolder holderInside = new HighlightInfoHolder(this.myFile, new HighlightInfoFilter[0]);
        HighlightInfoHolder holderOutside = new HighlightInfoHolder(this.myFile, new HighlightInfoFilter[0]);
        for (PsiElement e : lazyInside) {
            this.collectHighlights(e, holderInside, holderOutside, this.myPriorityRange);
        }
        ArrayList<HighlightInfo> inside = new ArrayList<HighlightInfo>(100);
        ArrayList<HighlightInfo> outside = new ArrayList<HighlightInfo>(100);
        for (int i = 0; i < holderInside.size(); ++i) {
            inside.add(holderInside.get(i));
        }
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)this.getDocument(), (Project)this.myProject, (boolean)true);
        BackgroundUpdateHighlightersUtil.setHighlightersInRange((TextRange)this.myPriorityRange, inside, markupModel, this.getId(), this.getHighlightingSession());
        for (PsiElement e : lazyOutside) {
            this.collectHighlights(e, holderInside, holderOutside, this.myPriorityRange);
        }
        for (int i = 0; i < holderOutside.size(); ++i) {
            outside.add(holderOutside.get(i));
        }
        BackgroundUpdateHighlightersUtil.setHighlightersOutsideRange(outside, this.myRestrictRange, (TextRange)this.myPriorityRange, this.getId(), this.getHighlightingSession());
        this.myHighlights = ContainerUtil.concat(inside, outside);
        this.setProgressLimit(1L);
        this.advanceProgress(1L);
    }

    private void collectHighlights(@NotNull PsiElement element, @NotNull HighlightInfoHolder inside, @NotNull HighlightInfoHolder outside, @NotNull ProperTextRange priorityRange) {
        if (element == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(6);
        }
        if (inside == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(7);
        }
        if (outside == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(8);
        }
        if (priorityRange == null) {
            ChameleonSyntaxHighlightingPass.$$$reportNull$$$0(9);
        }
        EditorColorsScheme scheme = (EditorColorsScheme)ObjectUtils.notNull((Object)this.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme());
        Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element.getNode());
        if (language == null) {
            return;
        }
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, (VirtualFile)this.myFile.getVirtualFile());
        for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)element).traverse(TreeTraversal.LEAVES_DFS)) {
            TextRange tokenRange = token.getTextRange();
            if (tokenRange.isEmpty()) continue;
            IElementType type = PsiUtilCore.getElementType((PsiElement)token);
            HighlightInfoHolder holder = priorityRange.contains(tokenRange) ? inside : outside;
            TextAttributesKey[] keys = syntaxHighlighter.getTokenHighlights(type);
            List<HighlightInfo> infos = InjectedLanguageFragmentSyntaxUtil.addSyntaxInjectedFragmentInfo(scheme, tokenRange, keys, null);
            for (HighlightInfo info : infos) {
                holder.add(info);
            }
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    @Override
    @Nullable
    public String getPresentableName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    static final class Factory
    implements MainHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar {
        Factory() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            if (registrar == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
        }

        @Override
        @NotNull
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
            if (psiFile == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                Factory.$$$reportNull$$$0(3);
            }
            Project project = psiFile.getProject();
            TextRange restrict = FileStatusMap.getDirtyTextRange(editor.getDocument(), psiFile, 4);
            if (restrict == null) {
                return new ProgressableTextEditorHighlightingPass.EmptyPass(project, editor.getDocument());
            }
            ProperTextRange priority = HighlightingSessionImpl.getFromCurrentIndicator(psiFile).getVisibleRange();
            return new ChameleonSyntaxHighlightingPass(psiFile, editor.getDocument(), ProperTextRange.create((Segment)restrict), priority, editor);
        }

        @Override
        @NotNull
        public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            if (psiFile == null) {
                Factory.$$$reportNull$$$0(4);
            }
            if (document == null) {
                Factory.$$$reportNull$$$0(5);
            }
            if (highlightInfoProcessor == null) {
                Factory.$$$reportNull$$$0(6);
            }
            ProperTextRange range = ProperTextRange.from((int)0, (int)document.getTextLength());
            return new ChameleonSyntaxHighlightingPass(psiFile, document, range, range, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightInfoProcessor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerHighlightingPassFactory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlightingPass";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createMainHighlightingPass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

