/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class VisibleHighlightingPassFactory {
    public static void setVisibleRangeForHeadlessMode(@NotNull Editor editor, @NotNull ProperTextRange range) {
        if (editor == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (range == null) {
            VisibleHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        assert (ApplicationManager.getApplication().isHeadlessEnvironment()) : "Must be called in headless mode only";
        if (range.getEndOffset() > editor.getDocument().getTextLength()) {
            throw new IllegalArgumentException("Invalid range: " + String.valueOf(range) + "; document length: " + editor.getDocument().getTextLength());
        }
        Point viewPositionStart = editor.logicalPositionToXY(editor.offsetToLogicalPosition(range.getStartOffset()));
        Point viewPositionEnd = editor.logicalPositionToXY(editor.offsetToLogicalPosition(range.getEndOffset()));
        JScrollPane scrollPane = ComponentUtil.getScrollPane((Component)editor.getContentComponent());
        scrollPane.getViewport().setSize(editor.getContentComponent().getWidth(), Math.max(100, viewPositionEnd.y - viewPositionStart.y));
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        scrollPane.getViewport().setViewPosition(viewPositionStart);
        scrollPane.getViewport().setExtentSize(new Dimension(editor.getContentComponent().getWidth(), Math.max(100, viewPositionEnd.y - viewPositionStart.y)));
        UIUtil.markAsFocused((JComponent)editor.getContentComponent(), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/VisibleHighlightingPassFactory";
        objectArray[2] = "setVisibleRangeForHeadlessMode";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

