/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.lang.ir.LoopAnalyzer;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SpliceInstruction;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ControlFlow {
    @NotNull
    private final List<Instruction> myInstructions;
    @NotNull
    private final Object2IntMap<PsiElement> myElementToStartOffsetMap;
    @NotNull
    private final Object2IntMap<PsiElement> myElementToEndOffsetMap;
    @NotNull
    private final DfaValueFactory myFactory;
    @NotNull
    private final PsiElement myPsiAnchor;
    private int[] myLoopNumbers;

    public ControlFlow(@NotNull DfaValueFactory factory, @NotNull PsiElement psiAnchor) {
        if (factory == null) {
            ControlFlow.$$$reportNull$$$0(0);
        }
        if (psiAnchor == null) {
            ControlFlow.$$$reportNull$$$0(1);
        }
        this.myFactory = factory;
        this.myPsiAnchor = psiAnchor;
        this.myInstructions = new ArrayList<Instruction>();
        this.myElementToEndOffsetMap = new Object2IntOpenHashMap();
        this.myElementToStartOffsetMap = new Object2IntOpenHashMap();
    }

    public ControlFlow(@NotNull ControlFlow flow, @NotNull DfaValueFactory factory) {
        if (flow == null) {
            ControlFlow.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            ControlFlow.$$$reportNull$$$0(3);
        }
        this.myFactory = factory;
        this.myPsiAnchor = flow.myPsiAnchor;
        this.myElementToEndOffsetMap = flow.myElementToEndOffsetMap;
        this.myElementToStartOffsetMap = flow.myElementToStartOffsetMap;
        this.myLoopNumbers = flow.myLoopNumbers;
        this.myInstructions = StreamEx.of(flow.myInstructions).map(instruction -> {
            Instruction updated = instruction.bindToFactory(factory);
            if (updated.getIndex() == -1) {
                updated.setIndex(instruction.getIndex());
            }
            return updated;
        }).toImmutableList();
    }

    @NotNull
    public PsiElement getPsiAnchor() {
        PsiElement psiElement = this.myPsiAnchor;
        if (psiElement == null) {
            ControlFlow.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public Instruction[] getInstructions() {
        return this.myInstructions.toArray(new Instruction[0]);
    }

    public Instruction getInstruction(int index) {
        return this.myInstructions.get(index);
    }

    public int getInstructionCount() {
        return this.myInstructions.size();
    }

    public ControlFlowOffset getNextOffset() {
        return new FixedOffset(this.myInstructions.size());
    }

    public void startElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ControlFlow.$$$reportNull$$$0(5);
        }
        this.myElementToStartOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void finishElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ControlFlow.$$$reportNull$$$0(6);
        }
        this.myElementToEndOffsetMap.put((Object)psiElement, this.myInstructions.size());
    }

    public void addInstruction(Instruction instruction) {
        instruction.setIndex(this.myInstructions.size());
        this.myInstructions.add(instruction);
    }

    public int[] getLoopNumbers() {
        return this.myLoopNumbers;
    }

    public void finish() {
        try {
            this.addInstruction(new ReturnInstruction(this.myFactory, (FList<DfaControlTransferValue.Trap>)FList.emptyList(), null));
            this.myLoopNumbers = LoopAnalyzer.calcInLoop(this);
            new LiveVariablesAnalyzer(this).flushDeadVariablesOnStatementFinish();
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new RuntimeExceptionWithAttachments((Throwable)ex, new Attachment[]{new Attachment("flow.txt", this.toString())});
        }
    }

    public ControlFlowOffset getStartOffset(PsiElement element) {
        return new FromMapOffset(element, this.myElementToStartOffsetMap);
    }

    public ControlFlowOffset getEndOffset(PsiElement element) {
        return new FromMapOffset(element, this.myElementToEndOffsetMap);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        List<Instruction> instructions = this.myInstructions;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            result.append(i).append(": ").append(instruction.toString());
            result.append("\n");
        }
        return result.toString();
    }

    public void makeNop(int index) {
        SpliceInstruction instruction = new SpliceInstruction(0, new int[0]);
        instruction.setIndex(index);
        this.myInstructions.set(index, instruction);
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            ControlFlow.$$$reportNull$$$0(7);
        }
        return dfaValueFactory;
    }

    @NotNull
    public Set<PsiElement> computeUnreachable(@NotNull BitSet reached) {
        if (reached == null) {
            ControlFlow.$$$reportNull$$$0(8);
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        this.myElementToStartOffsetMap.forEach((element, start) -> {
            int end = this.myElementToEndOffsetMap.getOrDefault(element, -1);
            if (end == -1) {
                return;
            }
            int nextReached = reached.nextSetBit(start);
            if (nextReached == -1 || nextReached >= end) {
                result.add((PsiElement)element);
            }
        });
        HashSet<PsiElement> hashSet = result;
        if (hashSet == null) {
            ControlFlow.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @Contract(mutates="this")
    public void keepVariables(@NotNull @NotNull Predicate<@NotNull VariableDescriptor> predicate) {
        if (predicate == null) {
            ControlFlow.$$$reportNull$$$0(10);
        }
        for (Instruction inst : this.getInstructions()) {
            if (!(inst instanceof FinishElementInstruction)) continue;
            FinishElementInstruction finishInstruction = (FinishElementInstruction)inst;
            finishInstruction.removeFromFlushList(predicate);
        }
    }

    @NotNull
    public DfaVariableValue createTempVariable(@NotNull DfType dfType) {
        if (dfType == null) {
            ControlFlow.$$$reportNull$$$0(11);
        }
        DfaVariableValue dfaVariableValue = this.getFactory().createTempVariable(this.getInstructionCount(), dfType);
        if (dfaVariableValue == null) {
            ControlFlow.$$$reportNull$$$0(12);
        }
        return dfaVariableValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnchor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/lang/ir/ControlFlow";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reached";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/lang/ir/ControlFlow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiAnchor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUnreachable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "finishElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeUnreachable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "keepVariables";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTempVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 9, 12 -> new IllegalStateException(string);
        };
    }

    public static class FixedOffset
    extends ControlFlowOffset {
        private final int myOffset;

        public FixedOffset(int offset) {
            this.myOffset = offset;
        }

        @Override
        public int getInstructionOffset() {
            return this.myOffset;
        }
    }

    private static class FromMapOffset
    extends ControlFlowOffset {
        private final PsiElement myElement;
        private final Object2IntMap<PsiElement> myElementMap;

        private FromMapOffset(PsiElement element, Object2IntMap<PsiElement> map) {
            this.myElement = element;
            this.myElementMap = map;
        }

        @Override
        public int getInstructionOffset() {
            return this.myElementMap.getInt((Object)this.myElement);
        }
    }

    public static class DeferredOffset
    extends ControlFlowOffset {
        private int myOffset = -1;

        @Override
        public int getInstructionOffset() {
            if (this.myOffset == -1) {
                throw new IllegalStateException("Not set");
            }
            return this.myOffset;
        }

        public void setOffset(int offset) {
            if (this.myOffset != -1) {
                throw new IllegalStateException("Already set");
            }
            this.myOffset = offset;
        }

        @Override
        public String toString() {
            return this.myOffset == -1 ? "<not set>" : super.toString();
        }
    }

    public static abstract class ControlFlowOffset {
        public abstract int getInstructionOffset();

        public String toString() {
            return String.valueOf(this.getInstructionOffset());
        }
    }
}

