/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LiveVariablesAnalyzer {
    private final Instruction[] myInstructions;
    private final List<List<Instruction>> myForwardMap;
    private final List<List<Instruction>> myBackwardMap;
    private final DfaValueFactory myFactory;
    private final Object2IntMap<VariableDescriptor> myDescriptorNumbering = new Object2IntOpenHashMap();
    private final List<VariableDescriptor> myDescriptors = new ArrayList<VariableDescriptor>();

    LiveVariablesAnalyzer(ControlFlow flow) {
        this.myFactory = flow.getFactory();
        this.myInstructions = flow.getInstructions();
        this.myForwardMap = this.calcForwardMap();
        this.myBackwardMap = this.calcBackwardMap();
    }

    private boolean isInterestingInstruction(Instruction instruction) {
        if (instruction == this.myInstructions[0]) {
            return true;
        }
        if (!instruction.getRequiredDescriptors(this.myFactory).isEmpty()) {
            return true;
        }
        return !instruction.isLinear() || instruction instanceof FinishElementInstruction;
    }

    private int getDescriptorNumber(@NotNull VariableDescriptor descriptor) {
        int num;
        if (descriptor == null) {
            LiveVariablesAnalyzer.$$$reportNull$$$0(0);
        }
        if ((num = this.myDescriptorNumbering.getInt((Object)descriptor)) == 0) {
            this.myDescriptors.add(descriptor);
            num = this.myDescriptors.size();
            this.myDescriptorNumbering.put((Object)descriptor, num);
        }
        return num - 1;
    }

    @Nullable
    private Map<FinishElementInstruction, ProcessedState> findLiveVars() {
        HashMap<FinishElementInstruction, ProcessedState> result = new HashMap<FinishElementInstruction, ProcessedState>();
        boolean ok = this.runDfa(false, (instruction, liveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                FinishElementInstruction finishInstruction = (FinishElementInstruction)instruction;
                ProcessedState set = (ProcessedState)result.get(instruction);
                if (set != null) {
                    set.addAll((ProcessedState)liveVars);
                    return new ProcessedState(set);
                }
                if (!liveVars.isEmpty()) {
                    result.put(finishInstruction, (ProcessedState)liveVars);
                }
            }
            var processor = new Consumer<VariableDescriptor>(){
                boolean cloned = false;
                ProcessedState newVars = this.val$liveVars;
                final /* synthetic */ ProcessedState val$liveVars;
                {
                    this.val$liveVars = processedState;
                }

                @Override
                public void accept(VariableDescriptor value) {
                    ProcessedState newState = this.newVars.add(value, !this.cloned);
                    this.cloned |= newState != this.newVars;
                    this.newVars = newState;
                }
            };
            instruction.getRequiredDescriptors(this.myFactory).forEach(processor);
            return processor.newVars;
        });
        return ok ? result : null;
    }

    void flushDeadVariablesOnStatementFinish() {
        Map<FinishElementInstruction, ProcessedState> liveVars = this.findLiveVars();
        if (liveVars == null) {
            return;
        }
        IdentityHashMap<FinishElementInstruction, BitSet> toFlush = new IdentityHashMap<FinishElementInstruction, BitSet>();
        boolean ok = this.runDfa(true, (instruction, prevLiveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                FinishElementInstruction finishInstruction = (FinishElementInstruction)instruction;
                ProcessedState currentlyLive = (ProcessedState)liveVars.get(instruction);
                BitSet varsToFlush = (BitSet)prevLiveVars.processedVars.clone();
                if (currentlyLive != null) {
                    varsToFlush.andNot(currentlyLive.processedVars);
                }
                toFlush.compute(finishInstruction, (k, set) -> {
                    if (set == null) {
                        return varsToFlush;
                    }
                    set.or(varsToFlush);
                    return set;
                });
                return currentlyLive == null ? new ProcessedState() : currentlyLive;
            }
            return prevLiveVars;
        });
        if (ok) {
            toFlush.forEach((instruction, set) -> {
                List<VariableDescriptor> descriptors = set.stream().mapToObj(this.myDescriptors::get).filter(var -> !var.isImplicitReadPossible()).toList();
                instruction.flushVars(descriptors);
            });
        }
    }

    private List<List<Instruction>> calcBackwardMap() {
        List<List<Instruction>> result = Stream.generate(() -> new ArrayList()).limit(this.myInstructions.length).toList();
        for (Instruction instruction : this.myInstructions) {
            List<Instruction> list = this.myForwardMap.get(instruction.getIndex());
            for (Instruction next : list) {
                result.get(next.getIndex()).add(instruction);
            }
        }
        return result;
    }

    private List<List<Instruction>> calcForwardMap() {
        ArrayList<List<Instruction>> result = new ArrayList<List<Instruction>>();
        for (Instruction instruction : this.myInstructions) {
            if (this.isInterestingInstruction(instruction)) {
                ArrayList<Instruction> successors = new ArrayList<Instruction>();
                block1: for (int index : instruction.getSuccessorIndexes()) {
                    Instruction next = this.myInstructions[index];
                    while (true) {
                        if (this.isInterestingInstruction(next)) {
                            successors.add(next);
                            continue block1;
                        }
                        if (next.getIndex() + 1 >= this.myInstructions.length) continue block1;
                        next = this.myInstructions[next.getIndex() + 1];
                    }
                }
                result.add(successors);
                continue;
            }
            result.add(List.of());
        }
        return result;
    }

    private boolean runDfa(boolean forward, BiFunction<? super Instruction, ProcessedState, ProcessedState> handleState) {
        List entryPoints = forward ? List.of(this.myInstructions[0]) : (List)((StreamEx)StreamEx.of((Object[])this.myInstructions).select(ControlTransferInstruction.class).filter(cti -> cti.getTransfer().getTarget().getPossibleTargets().length == 0)).collect(Collectors.toList());
        ArrayDeque<InstructionState> queue = new ArrayDeque<InstructionState>(10);
        for (Instruction i : entryPoints) {
            queue.addLast(new InstructionState(i, new ProcessedState()));
        }
        int limit = this.myForwardMap.size() * 50;
        HashMap<ProcessedState, IntSet> processed = new HashMap<ProcessedState, IntSet>();
        int steps = 0;
        while (!queue.isEmpty()) {
            if (steps > limit) {
                return false;
            }
            if (steps % 8192 == 0) {
                ProgressManager.checkCanceled();
            }
            InstructionState state = (InstructionState)queue.removeFirst();
            Instruction instruction = state.instruction;
            Collection nextInstructions = forward ? (Collection)this.myForwardMap.get(instruction.getIndex()) : (Collection)this.myBackwardMap.get(instruction.getIndex());
            ProcessedState nextVars = handleState.apply(instruction, state.nextVars);
            if (nextInstructions == null) continue;
            for (Instruction next : nextInstructions) {
                int index;
                IntSet instructionSet = processed.computeIfAbsent(nextVars, k -> new IntOpenHashSet());
                if (instructionSet.contains(index = next.getIndex() + 1)) continue;
                instructionSet.add(index);
                queue.addLast(new InstructionState(next, nextVars));
                ++steps;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/lang/ir/LiveVariablesAnalyzer", "getDescriptorNumber"));
    }

    private record InstructionState(Instruction instruction, ProcessedState nextVars) {
    }

    private final class ProcessedState {
        @NotNull
        private final BitSet processedVars;

        ProcessedState() {
            this.processedVars = new BitSet();
        }

        ProcessedState(ProcessedState state) {
            this.processedVars = (BitSet)state.processedVars.clone();
        }

        boolean isEmpty() {
            return this.processedVars.isEmpty();
        }

        ProcessedState add(VariableDescriptor descriptor, boolean clone) {
            int number = LiveVariablesAnalyzer.this.getDescriptorNumber(descriptor);
            if (!this.processedVars.get(number)) {
                ProcessedState newState = clone ? new ProcessedState(this) : this;
                newState.processedVars.set(number);
                return newState;
            }
            return this;
        }

        void addAll(ProcessedState vars) {
            this.processedVars.or(vars.processedVars);
        }

        public void forEach(IntConsumer consumer) {
            BitSet vars = this.processedVars;
            int num = vars.nextSetBit(0);
            while (num >= 0) {
                consumer.accept(num);
                num = vars.nextSetBit(num + 1);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ProcessedState that = (ProcessedState)obj;
            return this.processedVars.equals(that.processedVars);
        }

        public int hashCode() {
            return this.processedVars.hashCode();
        }
    }
}

