/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaValueFactory {
    @NotNull
    private final List<DfaValue> myValues;
    @NotNull
    private final List<Synthetic> mySynthetics;
    @NotNull
    private final Project myProject;
    @Nullable
    private PsiElement myContext;
    private final Map<Pair<DfaControlTransferValue.TransferTarget, FList<DfaControlTransferValue.Trap>>, DfaControlTransferValue> myControlTransfers;
    private final DfaVariableValue.Factory myVarFactory;
    private final DfaWrappedValue.Factory myBoxedFactory;
    private final DfaBinOpValue.Factory myBinOpFactory;
    private final DfaTypeValue.Factory myTypeValueFactory;
    private final DfaValue mySentinelValue;

    public DfaValueFactory(@NotNull Project project) {
        if (project == null) {
            DfaValueFactory.$$$reportNull$$$0(0);
        }
        this.myValues = new ArrayList<DfaValue>();
        this.mySynthetics = new ArrayList<Synthetic>();
        this.myControlTransfers = FactoryMap.create(p -> new DfaControlTransferValue(this, (DfaControlTransferValue.TransferTarget)p.first, (FList<DfaControlTransferValue.Trap>)((FList)p.second)));
        this.mySentinelValue = new DfaValue(this, this){

            @Override
            public DfaValue bindToFactory(@NotNull DfaValueFactory factory) {
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                return factory.mySentinelValue;
            }

            public String toString() {
                return "SENTINEL";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInspection/dataFlow/value/DfaValueFactory$1", "bindToFactory"));
            }
        };
        this.myProject = project;
        this.myValues.add(null);
        this.myVarFactory = new DfaVariableValue.Factory(this);
        this.myBoxedFactory = new DfaWrappedValue.Factory(this);
        this.myBinOpFactory = new DfaBinOpValue.Factory(this);
        this.myTypeValueFactory = new DfaTypeValue.Factory(this);
    }

    @Nullable
    public PsiElement getContext() {
        return this.myContext;
    }

    public void setContext(@NotNull PsiElement context) {
        if (context == null) {
            DfaValueFactory.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        for (DfaValue value : this.myValues) {
            if (!(value instanceof DfaVariableValue)) continue;
            ((DfaVariableValue)value).resetInherentType();
        }
    }

    int registerValue(DfaValue value) {
        this.myValues.add(value);
        return this.myValues.size() - 1;
    }

    public DfaValue getValue(int id) {
        return this.myValues.get(id);
    }

    @NotNull
    public List<VariableDescriptor> getTempVariableDescriptorsFrom(int offset) {
        ArrayList<VariableDescriptor> result = new ArrayList<VariableDescriptor>();
        for (Synthetic synthetic : this.mySynthetics) {
            if (synthetic.myLocation < offset) continue;
            result.add(synthetic);
        }
        ArrayList<VariableDescriptor> arrayList = result;
        if (arrayList == null) {
            DfaValueFactory.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public DfaVariableValue createTempVariable(int offset, @NotNull DfType type) {
        if (type == null) {
            DfaValueFactory.$$$reportNull$$$0(3);
        }
        Synthetic descriptor = new Synthetic(offset, type);
        this.mySynthetics.add(descriptor);
        DfaVariableValue dfaVariableValue = this.myVarFactory.createVariableValue(descriptor);
        if (dfaVariableValue == null) {
            DfaValueFactory.$$$reportNull$$$0(4);
        }
        return dfaVariableValue;
    }

    public static boolean isTempVariable(DfaVariableValue var) {
        return var.getDescriptor() instanceof Synthetic;
    }

    @NotNull
    public DfaTypeValue getUnknown() {
        DfaTypeValue dfaTypeValue = this.fromDfType(DfType.TOP);
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(5);
        }
        return dfaTypeValue;
    }

    @NotNull
    public DfaValue getSentinel() {
        DfaValue dfaValue = this.mySentinelValue;
        if (dfaValue == null) {
            DfaValueFactory.$$$reportNull$$$0(6);
        }
        return dfaValue;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DfaValueFactory.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public DfaTypeValue fromDfType(@NotNull DfType dfType) {
        if (dfType == null) {
            DfaValueFactory.$$$reportNull$$$0(8);
        }
        DfaTypeValue dfaTypeValue = this.myTypeValueFactory.create(dfType);
        if (dfaTypeValue == null) {
            DfaValueFactory.$$$reportNull$$$0(9);
        }
        return dfaTypeValue;
    }

    public Collection<DfaValue> getValues() {
        return Collections.unmodifiableCollection(this.myValues);
    }

    @NotNull
    public DfaControlTransferValue controlTransfer(DfaControlTransferValue.TransferTarget kind, FList<DfaControlTransferValue.Trap> traps) {
        DfaControlTransferValue dfaControlTransferValue = this.myControlTransfers.get(Pair.create((Object)kind, traps));
        if (dfaControlTransferValue == null) {
            DfaValueFactory.$$$reportNull$$$0(10);
        }
        return dfaControlTransferValue;
    }

    @NotNull
    public DfaVariableValue.Factory getVarFactory() {
        DfaVariableValue.Factory factory = this.myVarFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(11);
        }
        return factory;
    }

    @NotNull
    public DfaWrappedValue.Factory getWrapperFactory() {
        DfaWrappedValue.Factory factory = this.myBoxedFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(12);
        }
        return factory;
    }

    @NotNull
    public DfaBinOpValue.Factory getBinOpFactory() {
        DfaBinOpValue.Factory factory = this.myBinOpFactory;
        if (factory == null) {
            DfaValueFactory.$$$reportNull$$$0(13);
        }
        return factory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempVariableDescriptorsFrom";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknown";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSentinel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDfType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "controlTransfer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarFactory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperFactory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinOpFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setContext";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTempVariable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromDfType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static final class Synthetic
    implements VariableDescriptor {
        private final int myLocation;
        private final DfType myType;

        private Synthetic(int location, DfType type) {
            this.myLocation = location;
            this.myType = type;
        }

        @NotNull
        public String toString() {
            String string = "tmp$" + this.myLocation;
            if (string == null) {
                Synthetic.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public DfType getDfType(@Nullable DfaVariableValue qualifier) {
            DfType dfType = this.myType;
            if (dfType == null) {
                Synthetic.$$$reportNull$$$0(1);
            }
            return dfType;
        }

        @Override
        public boolean isStable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/value/DfaValueFactory$Synthetic";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

