/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl.modcommand;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.options.LocMessage;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptControl;
import com.intellij.codeInspection.options.OptNumber;
import com.intellij.codeInspection.options.OptString;
import com.intellij.codeInspection.options.OptStringList;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.OptionControllerProvider;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.FutureVirtualFile;
import com.intellij.modcommand.ModChooseAction;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.modcommand.ModCompositeCommand;
import com.intellij.modcommand.ModCopyToClipboard;
import com.intellij.modcommand.ModCreateFile;
import com.intellij.modcommand.ModDeleteFile;
import com.intellij.modcommand.ModDisplayMessage;
import com.intellij.modcommand.ModEditOptions;
import com.intellij.modcommand.ModHighlight;
import com.intellij.modcommand.ModMoveFile;
import com.intellij.modcommand.ModNavigate;
import com.intellij.modcommand.ModOpenUrl;
import com.intellij.modcommand.ModRegisterTabOut;
import com.intellij.modcommand.ModShowConflicts;
import com.intellij.modcommand.ModStartRename;
import com.intellij.modcommand.ModStartTemplate;
import com.intellij.modcommand.ModUpdateFileText;
import com.intellij.modcommand.ModUpdateReferences;
import com.intellij.modcommand.ModUpdateSystemOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class ModCommandBatchExecutorImpl
implements ModCommandExecutor {
    public void executeInteractively(@NotNull ActionContext context, @NotNull ModCommand command, @Nullable Editor editor) {
        ModCommandExecutor.BatchExecutionResult result;
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(1);
        }
        if ((result = this.executeInBatch(context, command)) == ModCommandExecutor.Result.INTERACTIVE || result == ModCommandExecutor.Result.CONFLICTS) {
            throw new UnsupportedOperationException(result.getMessage());
        }
        if (result instanceof ModCommandExecutor.Error) {
            ModCommandExecutor.Error error = (ModCommandExecutor.Error)result;
            throw new RuntimeException(error.getMessage());
        }
    }

    @NotNull
    public ModCommandExecutor.BatchExecutionResult executeInBatch(@NotNull ActionContext context, @NotNull ModCommand command) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(2);
        }
        if (command == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(3);
        }
        if (!ModCommandBatchExecutorImpl.ensureWritable(context.project(), command)) {
            return new ModCommandExecutor.Error(AnalysisBundle.message((String)"modcommand.executor.error.files.are.marked.as.readonly", (Object[])new Object[0]));
        }
        ModCommandExecutor.BatchExecutionResult batchExecutionResult = this.doExecuteInBatch(context, command);
        if (batchExecutionResult == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(4);
        }
        return batchExecutionResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModCommandExecutor.BatchExecutionResult doExecuteInBatch(@NotNull ActionContext context, @NotNull ModCommand command) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(5);
        }
        if (command == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(6);
        }
        Project project = context.project();
        if (command.isEmpty()) {
            return ModCommandExecutor.Result.NOTHING;
        }
        if (command instanceof ModNavigate) return ModCommandExecutor.Result.INTERACTIVE;
        if (command instanceof ModHighlight) return ModCommandExecutor.Result.INTERACTIVE;
        if (command instanceof ModCopyToClipboard) return ModCommandExecutor.Result.INTERACTIVE;
        if (command instanceof ModStartRename) return ModCommandExecutor.Result.INTERACTIVE;
        if (command instanceof ModStartTemplate) return ModCommandExecutor.Result.INTERACTIVE;
        if (command instanceof ModUpdateSystemOptions) return ModCommandExecutor.Result.INTERACTIVE;
        if (command instanceof ModUpdateReferences) return ModCommandExecutor.Result.INTERACTIVE;
        if (command instanceof ModOpenUrl) {
            return ModCommandExecutor.Result.INTERACTIVE;
        }
        ModCommand modCommand = command;
        Objects.requireNonNull(modCommand);
        ModCommand modCommand2 = modCommand;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModRegisterTabOut.class, ModUpdateFileText.class, ModCreateFile.class, ModDeleteFile.class, ModMoveFile.class, ModCompositeCommand.class, ModChooseAction.class, ModShowConflicts.class, ModEditOptions.class, ModDisplayMessage.class}, (Object)modCommand2, n)) {
            case 0: {
                ModRegisterTabOut ignored = (ModRegisterTabOut)modCommand2;
                ModCommandExecutor.Result result2 = ModCommandExecutor.Result.NOTHING;
                return result2;
            }
            case 1: {
                ModCommandExecutor.Result result2;
                ModUpdateFileText upd = (ModUpdateFileText)modCommand2;
                if (this.executeUpdate(project, upd)) {
                    result2 = ModCommandExecutor.Result.SUCCESS;
                    return result2;
                }
                result2 = ModCommandExecutor.Result.ABORT;
                return result2;
            }
            case 2: {
                ModCommandExecutor.Result result2;
                ModCreateFile create = (ModCreateFile)modCommand2;
                String message = this.executeCreate(project, create);
                if (message == null) {
                    result2 = ModCommandExecutor.Result.SUCCESS;
                    return result2;
                }
                result2 = new ModCommandExecutor.Error(message);
                return result2;
            }
            case 3: {
                ModCommandExecutor.Result result2;
                ModDeleteFile deleteFile = (ModDeleteFile)modCommand2;
                String message = this.executeDelete(deleteFile);
                if (message == null) {
                    result2 = ModCommandExecutor.Result.SUCCESS;
                    return result2;
                }
                result2 = new ModCommandExecutor.Error(message);
                return result2;
            }
            case 4: {
                ModCommandExecutor.Result result2;
                ModMoveFile moveFile = (ModMoveFile)modCommand2;
                String message = this.executeMove(moveFile);
                if (message == null) {
                    result2 = ModCommandExecutor.Result.SUCCESS;
                    return result2;
                }
                result2 = new ModCommandExecutor.Error(message);
                return result2;
            }
            case 5: {
                ModCommand subCommand;
                Iterator iterator;
                ModCommandExecutor.Result result;
                ModCompositeCommand modCompositeCommand = (ModCompositeCommand)modCommand2;
                try {
                    List list;
                    List commands = list = modCompositeCommand.commands();
                    result = ModCommandExecutor.Result.NOTHING;
                    iterator = commands.iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (iterator.hasNext() && (result = result.compose(this.doExecuteInBatch(context, subCommand = (ModCommand)iterator.next()))) != ModCommandExecutor.Result.ABORT && !(result instanceof ModCommandExecutor.Error)) {
                }
                ModCommandExecutor.Result result2 = result;
                return result2;
            }
            case 6: {
                ModChooseAction chooser = (ModChooseAction)modCommand2;
                ModCommandExecutor.Result result2 = this.executeChooseInBatch(context, chooser);
                return result2;
            }
            case 7: {
                ModShowConflicts ignored = (ModShowConflicts)modCommand2;
                ModCommandExecutor.Result result2 = ModCommandExecutor.Result.CONFLICTS;
                return result2;
            }
            case 8: {
                ModEditOptions editOptions = (ModEditOptions)modCommand2;
                ModCommandExecutor.Result result2 = this.bypassEditOptions(editOptions, context);
                return result2;
            }
            case 9: {
                String kind;
                String text;
                ModCommandExecutor.Result result2;
                ModDisplayMessage modDisplayMessage = (ModDisplayMessage)modCommand2;
                {
                    String string;
                    text = string = modDisplayMessage.messageText();
                    kind = string = modDisplayMessage.kind();
                }
                switch (1.$SwitchMap$com$intellij$modcommand$ModDisplayMessage$MessageKind[kind.ordinal()]) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        result2 = new ModCommandExecutor.Error(text);
                        return result2;
                    }
                    case 2: 
                }
                result2 = ModCommandExecutor.Result.INTERACTIVE;
                return result2;
            }
        }
        throw new IllegalArgumentException("Unknown command: " + String.valueOf(command));
    }

    private <T extends OptionContainer> ModCommandExecutor.BatchExecutionResult bypassEditOptions(@NotNull ModEditOptions<T> options, @NotNull ActionContext context) {
        if (options == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(8);
        }
        if (!options.canUseDefaults()) {
            return ModCommandExecutor.Result.INTERACTIVE;
        }
        return this.doExecuteInBatch(context, (ModCommand)options.nextCommand().apply(options.containerSupplier().get()));
    }

    private ModCommandExecutor.BatchExecutionResult executeChooseInBatch(@NotNull ActionContext context, ModChooseAction chooser) {
        ModCommandAction action;
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(9);
        }
        if ((action = (ModCommandAction)((StreamEx)StreamEx.of((Collection)chooser.actions()).filter(act -> act.getPresentation(context) != null)).findFirst().orElse(null)) == null) {
            return ModCommandExecutor.Result.NOTHING;
        }
        String name = chooser.title();
        ModCommand next = (ModCommand)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (ModCommand)ReadAction.nonBlocking(() -> {
            if (action.getPresentation(context) == null) {
                return null;
            }
            return action.perform(context);
        }).executeSynchronously(), name, true, context.project());
        if (next == null) {
            return ModCommandExecutor.Result.ABORT;
        }
        return this.executeInBatch(context, next);
    }

    @Nls
    protected String executeDelete(@NotNull ModDeleteFile file) {
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(10);
        }
        try {
            WriteAction.run(() -> file.file().delete((Object)this));
            return null;
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    @Nls
    protected String executeMove(@NotNull ModMoveFile file) {
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(11);
        }
        VirtualFile source = ModCommandBatchExecutorImpl.actualize(file.file());
        FutureVirtualFile target = file.targetFile();
        VirtualFile parent = ModCommandBatchExecutorImpl.actualize(target.getParent());
        return (String)WriteAction.compute(() -> {
            VirtualFile origParent = source.getParent();
            if (parent != null && !parent.equals(origParent)) {
                try {
                    source.move((Object)this, parent);
                }
                catch (IOException e) {
                    return AnalysisBundle.message((String)"modcommand.executor.cannot.move.file", (Object[])new Object[]{source.getPath(), parent.getPath(), e.getLocalizedMessage()});
                }
            }
            if (!target.getName().equals(source.getName())) {
                try {
                    source.rename((Object)this, target.getName());
                }
                catch (IOException e) {
                    if (origParent != null && !origParent.equals(parent)) {
                        try {
                            source.move((Object)this, origParent);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return AnalysisBundle.message((String)"modcommand.executor.cannot.rename.file", (Object[])new Object[]{source.getPath(), target.getName(), e.getLocalizedMessage()});
                }
            }
            return null;
        });
    }

    @Nls
    protected String executeCreate(@NotNull Project project, @NotNull ModCreateFile create) {
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(12);
        }
        if (create == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(13);
        }
        FutureVirtualFile file = create.file();
        VirtualFile parent = ModCommandBatchExecutorImpl.actualize(file.getParent());
        try {
            return (String)WriteAction.compute(() -> {
                byte[] bytes;
                if (create.content() instanceof ModCreateFile.Directory) {
                    parent.createChildDirectory((Object)this, file.getName());
                    return null;
                }
                VirtualFile newFile = parent.createChildData((Object)this, file.getName());
                ModCreateFile.Content patt1$temp = create.content();
                if (patt1$temp instanceof ModCreateFile.Text) {
                    String text;
                    ModCreateFile.Text $b$0 = (ModCreateFile.Text)patt1$temp;
                    try {
                        String patt2$temp;
                        text = patt2$temp = $b$0.text();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(newFile);
                    if (psiFile == null) {
                        return AnalysisBundle.message((String)"modcommand.executor.unable.to.find.the.new.file", (Object[])new Object[]{file.getName()});
                    }
                    Document document = psiFile.getViewProvider().getDocument();
                    document.setText((CharSequence)text);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    return null;
                }
                ModCreateFile.Content patt4$temp = create.content();
                if (!(patt4$temp instanceof ModCreateFile.Binary)) return null;
                ModCreateFile.Binary $b$3 = (ModCreateFile.Binary)patt4$temp;
                {
                    byte[] patt5$temp;
                    bytes = patt5$temp = $b$3.bytes();
                }
                newFile.setBinaryContent(bytes);
                return null;
            });
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public void executeForFileCopy(@NotNull ModCommand command, @NotNull PsiFile file) {
        if (command == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(15);
        }
        for (ModCommand cmd : command.unpack()) {
            if (cmd instanceof ModUpdateFileText) {
                ModUpdateFileText updateFileText = (ModUpdateFileText)cmd;
                if (!updateFileText.file().equals(file.getOriginalFile().getVirtualFile())) {
                    throw new UnsupportedOperationException("The command updates non-current file");
                }
                this.updateText(file.getProject(), file.getViewProvider().getDocument(), updateFileText);
                continue;
            }
            if (cmd instanceof ModNavigate || cmd instanceof ModHighlight || cmd instanceof ModRegisterTabOut) continue;
            throw new UnsupportedOperationException("Unexpected command: " + String.valueOf(command));
        }
    }

    public void obtainAndExecuteInteractively(@NotNull ActionContext context, @Nls String title, @Nullable Editor editor, @NotNull @NotNull Supplier<? extends @NotNull ModCommand> commandSupplier) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(16);
        }
        if (commandSupplier == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(17);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            ModCommand command = commandSupplier.get();
            this.executeForFileCopy(command, context.file());
            return;
        }
        ModCommand command = (ModCommand)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (ModCommand)ReadAction.nonBlocking(((Supplier)commandSupplier)::get).expireWhen(() -> context.project().isDisposed() || editor != null && editor.isDisposed()).executeSynchronously(), title, true, context.project());
        if (!command.isEmpty()) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (!commandProcessor.isCommandInProgress()) {
                commandProcessor.executeCommand(context.project(), () -> this.executeInteractively(context, command, editor), title, null);
            } else {
                this.executeInteractively(context, command, editor);
            }
        }
    }

    protected static boolean ensureWritable(@NotNull Project project, @NotNull ModCommand command) {
        List files;
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(18);
        }
        if (command == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(19);
        }
        return (files = ContainerUtil.filter((Collection)command.modifiedFiles(), f -> !(f instanceof LightVirtualFile))).isEmpty() || ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])files.toArray(VirtualFile.EMPTY_ARRAY));
    }

    protected static VirtualFile actualize(@NotNull VirtualFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(20);
        }
        if (file instanceof FutureVirtualFile) {
            FutureVirtualFile future = (FutureVirtualFile)file;
            virtualFile = ModCommandBatchExecutorImpl.actualize(future.getParent()).findChild(future.getName());
        } else {
            virtualFile = file;
        }
        return virtualFile;
    }

    private void updateText(@NotNull Project project, @NotNull Document document, @NotNull ModUpdateFileText upd) throws IllegalStateException {
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(21);
        }
        if (document == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(22);
        }
        if (upd == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(23);
        }
        String oldText = upd.oldText();
        if (!document.getText().equals(oldText)) {
            throw new IllegalStateException("Old text doesn't match");
        }
        List<// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ModUpdateFileText.Fragment> ranges = this.calculateRanges(upd);
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        ModCommandBatchExecutorImpl.applyRanges(document, ranges, upd.newText());
        manager.commitDocument(document);
    }

    protected boolean executeUpdate(@NotNull Project project, @NotNull ModUpdateFileText upd) {
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(24);
        }
        if (upd == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(25);
        }
        VirtualFile file = upd.file();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        String oldText = upd.oldText();
        if (!document.getText().equals(oldText)) {
            return false;
        }
        List<// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ModUpdateFileText.Fragment> ranges = this.calculateRanges(upd);
        return (Boolean)WriteAction.compute(() -> {
            ModCommandBatchExecutorImpl.applyRanges(document, ranges, upd.newText());
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            return true;
        });
    }

    private static void applyRanges(@NotNull Document document, List<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModUpdateFileText.Fragment> ranges, String newText) {
        if (document == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(26);
        }
        for (ModUpdateFileText.Fragment range : ranges) {
            document.replaceString(range.offset(), range.offset() + range.oldLength(), (CharSequence)newText.substring(range.offset(), range.offset() + range.newLength()));
        }
    }

    @NotNull
    protected @Unmodifiable @NotNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModUpdateFileText.Fragment> calculateRanges(@NotNull ModUpdateFileText upd) {
        if (upd == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(27);
        }
        List<ModUpdateFileText.Fragment> list = List.of(new ModUpdateFileText.Fragment(0, upd.oldText().length(), upd.newText().length()));
        if (list == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public IntentionPreviewInfo getPreview(@NotNull ModCommand modCommand, @NotNull ActionContext context) {
        IntentionPreviewInfo.MultiFileDiff multiFileDiff;
        if (modCommand == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(29);
        }
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(30);
        }
        Project project = context.project();
        PsiFile file = context.file();
        ArrayList<IntentionPreviewInfo.CustomDiff> customDiffList = new ArrayList<IntentionPreviewInfo.CustomDiff>();
        IntentionPreviewInfo navigateInfo = IntentionPreviewInfo.EMPTY;
        ArrayList<@NlsSafe String> createdDirs = new ArrayList<String>();
        ArrayList<HtmlChunk> fsActions = new ArrayList<HtmlChunk>();
        for (ModCommand command : modCommand.unpack()) {
            Object virtualFile;
            ModNavigate navigate;
            VirtualFile vFile;
            if (command instanceof ModUpdateFileText) {
                ModUpdateFileText modFile = (ModUpdateFileText)command;
                vFile = modFile.file();
                boolean currentFile = vFile.equals(file.getOriginalFile().getVirtualFile()) || vFile.equals(InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file).getOriginalFile().getVirtualFile());
                customDiffList.add(new IntentionPreviewInfo.CustomDiff(vFile.getFileType(), currentFile ? null : this.getFileNamePresentation(project, vFile), modFile.oldText(), modFile.newText(), true));
                continue;
            }
            if (command instanceof ModCreateFile) {
                String string;
                VirtualFile content;
                VirtualFile createdFile;
                ModCreateFile modCreateFile = (ModCreateFile)command;
                try {
                    createdFile = vFile = modCreateFile.file();
                    content = vFile = modCreateFile.content();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (content instanceof ModCreateFile.Directory) {
                    createdDirs.add(this.getFileNamePresentation(project, createdFile));
                    continue;
                }
                if (content instanceof ModCreateFile.Text) {
                    ModCreateFile.Text text3 = (ModCreateFile.Text)content;
                    {
                        String string2;
                        String text2;
                        string = text2 = (string2 = text3.text());
                    }
                } else {
                    string = AnalysisBundle.message((String)"preview.binary.content", (Object[])new Object[0]);
                }
                String contentRepresentation = string;
                customDiffList.add(new IntentionPreviewInfo.CustomDiff(createdFile.getFileType(), this.getFileNamePresentation(project, createdFile), "", contentRepresentation, true));
                continue;
            }
            if (command instanceof ModNavigate && (navigate = (ModNavigate)command).caret() != -1) {
                PsiFile target;
                virtualFile = navigate.file();
                if (!virtualFile.isValid() || (target = PsiManager.getInstance((Project)project).findFile(virtualFile)) == null) continue;
                navigateInfo = IntentionPreviewInfo.navigate((PsiFile)target, (int)navigate.caret());
                continue;
            }
            if (command instanceof ModChooseAction) {
                ModChooseAction target = (ModChooseAction)command;
                return ModCommandBatchExecutorImpl.getChoosePreview(context, target);
            }
            if (command instanceof ModEditOptions) {
                ModEditOptions target = (ModEditOptions)command;
                return this.getEditOptionsPreview(context, target);
            }
            if (command instanceof ModDisplayMessage) {
                Object text4;
                block30: {
                    ModDisplayMessage modDisplayMessage = (ModDisplayMessage)command;
                    {
                        text4 = virtualFile = modDisplayMessage.messageText();
                        virtualFile = modDisplayMessage.kind();
                        Object kind = virtualFile;
                        if (kind != ModDisplayMessage.MessageKind.ERROR) break block30;
                    }
                    return new IntentionPreviewInfo.Html(new HtmlBuilder().append(AnalysisBundle.message((String)"preview.cannot.perform.action", (Object[])new Object[0])).br().append((String)text4).toFragment(), IntentionPreviewInfo.InfoKind.ERROR);
                }
                if (navigateInfo != IntentionPreviewInfo.EMPTY) continue;
                navigateInfo = new IntentionPreviewInfo.Html((String)text4);
                continue;
            }
            if (command instanceof ModCopyToClipboard) {
                Object content;
                ModCopyToClipboard modCopyToClipboard = (ModCopyToClipboard)command;
                {
                    content = virtualFile = modCopyToClipboard.content();
                }
                navigateInfo = new IntentionPreviewInfo.Html(HtmlChunk.text((String)AnalysisBundle.message((String)"preview.copy.to.clipboard", (Object[])new Object[]{StringUtil.shortenTextWithEllipsis((String)content, (int)50, (int)10)})));
                continue;
            }
            if (command instanceof ModOpenUrl) {
                Object url;
                ModOpenUrl modOpenUrl = (ModOpenUrl)command;
                {
                    url = virtualFile = modOpenUrl.url();
                }
                navigateInfo = new IntentionPreviewInfo.Html(HtmlChunk.text((String)AnalysisBundle.message((String)"preview.open.url", (Object[])new Object[]{StringUtil.shortenTextWithEllipsis((String)url, (int)50, (int)10)})));
                continue;
            }
            if (command instanceof ModMoveFile) {
                IntentionPreviewInfo.Html html;
                ModMoveFile modMoveFile = (ModMoveFile)command;
                {
                    Object fileToCreate = virtualFile = modMoveFile.file();
                    virtualFile = modMoveFile.targetFile();
                    Object targetFile = virtualFile;
                    html = targetFile.getName().equals(fileToCreate.getName()) ? (IntentionPreviewInfo.Html)IntentionPreviewInfo.moveToDirectory((VirtualFile)fileToCreate, (VirtualFile)targetFile.getParent()) : (IntentionPreviewInfo.Html)IntentionPreviewInfo.rename((VirtualFile)fileToCreate, (String)targetFile.getName());
                }
                fsActions.add(html.content());
                continue;
            }
            if (!(command instanceof ModUpdateSystemOptions)) continue;
            ModUpdateSystemOptions options = (ModUpdateSystemOptions)command;
            HtmlChunk preview = ModCommandBatchExecutorImpl.createOptionsPreview(context, options);
            navigateInfo = preview.isEmpty() ? IntentionPreviewInfo.EMPTY : new IntentionPreviewInfo.Html(preview);
        }
        customDiffList.sort(Comparator.comparing(diff -> diff.fileName() != null));
        if (customDiffList.isEmpty()) {
            HtmlBuilder builder = new HtmlBuilder();
            if (!createdDirs.isEmpty()) {
                if (createdDirs.size() == 1) {
                    builder.append(AnalysisBundle.message((String)"preview.create.directory", (Object[])new Object[]{createdDirs.get(0)})).br();
                } else {
                    builder.append((HtmlChunk)HtmlChunk.tag((String)"p").addText(AnalysisBundle.message((String)"preview.create.directories", (Object[])new Object[0])).children(ContainerUtil.map(createdDirs, text -> new HtmlBuilder().br().appendRaw("&bull; ").append(text).toFragment())));
                }
            }
            if (!fsActions.isEmpty()) {
                if (!builder.isEmpty()) {
                    builder.br();
                }
                fsActions.forEach(arg_0 -> ((HtmlBuilder)builder).append(arg_0));
            }
            if (!builder.isEmpty()) {
                return new IntentionPreviewInfo.Html(builder.toFragment());
            }
            IntentionPreviewInfo intentionPreviewInfo = navigateInfo;
            if (intentionPreviewInfo != null) return intentionPreviewInfo;
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(31);
            return intentionPreviewInfo;
        }
        if (customDiffList.size() == 1) {
            multiFileDiff = (IntentionPreviewInfo)customDiffList.get(0);
            return multiFileDiff;
        }
        multiFileDiff = new IntentionPreviewInfo.MultiFileDiff(customDiffList);
        return multiFileDiff;
    }

    @NotNull
    private <T extends OptionContainer> IntentionPreviewInfo getEditOptionsPreview(@NotNull ActionContext context, @NotNull ModEditOptions<T> target) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(32);
        }
        if (target == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(33);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.getPreview((ModCommand)target.nextCommand().apply(target.containerSupplier().get()), context);
        if (intentionPreviewInfo == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(34);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    protected String getFileNamePresentation(Project project, VirtualFile file) {
        VirtualFile virtualFile;
        StringBuilder presentation = new StringBuilder(file.getName());
        while ((virtualFile = file.getParent()) instanceof FutureVirtualFile) {
            FutureVirtualFile parent = (FutureVirtualFile)virtualFile;
            presentation.insert(0, parent.getName() + "/");
            file = parent;
        }
        String string = presentation.toString();
        if (string == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static IntentionPreviewInfo getChoosePreview(@NotNull ActionContext context, @NotNull ModChooseAction target) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(36);
        }
        if (target == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(37);
        }
        IntentionPreviewInfo intentionPreviewInfo = target.actions().stream().filter(action -> action.getPresentation(context) != null).findFirst().map(action -> action.generatePreview(context)).orElse(IntentionPreviewInfo.EMPTY);
        if (intentionPreviewInfo == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(38);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    private static HtmlChunk createOptionsPreview(@NotNull ActionContext context, @NotNull ModUpdateSystemOptions options) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(39);
        }
        if (options == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(40);
        }
        HtmlBuilder builder = new HtmlBuilder();
        for (ModUpdateSystemOptions.ModifiedOption option : options.options()) {
            builder.append(ModCommandBatchExecutorImpl.createOptionPreview(context.file(), option));
        }
        HtmlChunk htmlChunk = builder.toFragment();
        if (htmlChunk == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(41);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk createOptionPreview(@NotNull PsiFile file, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModUpdateSystemOptions.ModifiedOption option) {
        OptionController controller;
        OptionController.OptionControlInfo controlInfo;
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(42);
        }
        if (option == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(43);
        }
        if ((controlInfo = (controller = OptionControllerProvider.rootController((PsiElement)file)).findControl(option.bindId())) == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(44);
            }
            return htmlChunk;
        }
        OptControl control = controlInfo.control();
        Object newValue = option.newValue();
        if (newValue instanceof Boolean) {
            Boolean value2 = (Boolean)newValue;
            OptCheckbox optCheckBox = (OptCheckbox)ObjectUtils.tryCast((Object)control, OptCheckbox.class);
            if (optCheckBox == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(45);
                }
                return htmlChunk;
            }
            HtmlChunk label = HtmlChunk.text((String)optCheckBox.label().label());
            HtmlChunk.Element checkbox = HtmlChunk.tag((String)"input").attr("type", "checkbox").attr("readonly", "true");
            if (value2.booleanValue()) {
                checkbox = checkbox.attr("checked", "true");
            }
            HtmlChunk.Element info = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.tag((String)"td").child((HtmlChunk)checkbox), HtmlChunk.tag((String)"td").child(label)}));
            HtmlChunk htmlChunk = new HtmlBuilder().append(value2 != false ? AnalysisBundle.message((String)"set.option.description.check", (Object[])new Object[0]) : AnalysisBundle.message((String)"set.option.description.uncheck", (Object[])new Object[0])).br().br().append((HtmlChunk)info).toFragment();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(46);
            }
            return htmlChunk;
        }
        if (newValue instanceof Integer) {
            Integer value3 = (Integer)newValue;
            OptNumber optNumber = (OptNumber)ObjectUtils.tryCast((Object)control, OptNumber.class);
            if (optNumber == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(47);
                }
                return htmlChunk;
            }
            LocMessage.PrefixSuffix prefixSuffix = optNumber.splitLabel().splitLabel();
            HtmlChunk info = ModCommandBatchExecutorImpl.getValueChunk(value3, prefixSuffix);
            HtmlChunk htmlChunk = new HtmlBuilder().append(AnalysisBundle.message((String)"set.option.description.input", (Object[])new Object[0])).br().br().append(info).br().toFragment();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(48);
            }
            return htmlChunk;
        }
        if (newValue instanceof String) {
            String value4 = (String)newValue;
            OptString optString = (OptString)ObjectUtils.tryCast((Object)control, OptString.class);
            if (optString == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(49);
                }
                return htmlChunk;
            }
            LocMessage.PrefixSuffix prefixSuffix = optString.splitLabel().splitLabel();
            HtmlChunk info = ModCommandBatchExecutorImpl.getValueChunk(value4, prefixSuffix);
            HtmlChunk htmlChunk = new HtmlBuilder().append(AnalysisBundle.message((String)"set.option.description.string", (Object[])new Object[0])).br().br().append(info).br().toFragment();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(50);
            }
            return htmlChunk;
        }
        if (newValue instanceof List) {
            List list = (List)newValue;
            OptStringList optList = (OptStringList)ObjectUtils.tryCast((Object)control, OptStringList.class);
            if (optList == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(51);
                }
                return htmlChunk;
            }
            List oldList = (List)option.oldValue();
            HtmlChunk htmlChunk = IntentionPreviewInfo.addListOption((List)list, (String)optList.label().label(), value -> !oldList.contains(value)).content();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(52);
            }
            return htmlChunk;
        }
        if (newValue == null) {
            throw new IllegalStateException("Null value is not supported");
        }
        throw new IllegalStateException("Value of type " + String.valueOf(newValue.getClass()) + " is not supported");
    }

    @NotNull
    private static HtmlChunk getValueChunk(Object value, LocMessage.PrefixSuffix prefixSuffix) {
        HtmlChunk.Element input = HtmlChunk.tag((String)"input").attr("type", "text").attr("value", String.valueOf(value)).attr("size", value.toString().length() + 1).attr("readonly", "true");
        HtmlChunk.Element element = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.tag((String)"td").child(HtmlChunk.text((String)prefixSuffix.prefix())), HtmlChunk.tag((String)"td").child((HtmlChunk)input), HtmlChunk.tag((String)"td").child(HtmlChunk.text((String)prefixSuffix.suffix()))}));
        if (element == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(53);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 28, 31, 34, 35, 38, 41, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/modcommand/ModCommandBatchExecutorImpl";
                break;
            }
            case 7: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 20: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "create";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandSupplier";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upd";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modCommand";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/modcommand/ModCommandBatchExecutorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInBatch";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateRanges";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreview";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditOptionsPreview";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNamePresentation";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getChoosePreview";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPreview";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionPreview";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueChunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeInteractively";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeInBatch";
                break;
            }
            case 4: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteInBatch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bypassEditOptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeChooseInBatch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeDelete";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeMove";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeCreate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeForFileCopy";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "obtainAndExecuteInteractively";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ensureWritable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "actualize";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdate";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "applyRanges";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calculateRanges";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPreview";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEditOptionsPreview";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getChoosePreview";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsPreview";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createOptionPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 28, 31, 34, 35, 38, 41, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53 -> new IllegalStateException(string);
        };
    }
}

